/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.gl.web.TestDataGenerator;
import org.kuali.kfs.kns.lookup.LookupableHelperService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.businessobject.AccountStatusBaseFunds;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.businessobject.lookup.LookupableSpringContext;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class BaseFundsLookupableHelperServiceIntegTest
extends KualiIntegTestBase {
    private BusinessObjectService businessObjectService;
    private LookupableHelperService lookupableHelperService;
    private Properties properties;
    private String fieldNames;
    private String deliminator;
    private int baseFundsExpectedInsertion;

    protected void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.lookupableHelperService = LookupableSpringContext.getLookupableHelperService((String)"BaseFundsLookupableHelperService");
        this.lookupableHelperService.setBusinessObjectClass(AccountStatusBaseFunds.class);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("accountNumber", "1031400");
        keys.put("universityFiscalYear", IntegTestUtils.getFiscalYearForTesting().toString());
        keys.put("chartOfAccountsCode", "BL");
        this.businessObjectService.deleteMatching(AccountStatusBaseFunds.class, keys);
    }

    public void testGetSearchResults() {
        this.insertBaseFundsRecords();
        this.insertCSFRecords();
        System.out.println("**** RECORDS INSERTED !!!!!");
        String messageFileName = "org/kuali/kfs/module/ld/testdata/message.properties";
        String propertiesFileName = "org/kuali/kfs/module/ld/testdata/accountStatusBaseFunds.properties";
        this.properties = new TestDataGenerator("org/kuali/kfs/module/ld/testdata/accountStatusBaseFunds.properties", "org/kuali/kfs/module/ld/testdata/message.properties").getProperties();
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        this.properties = new TestDataGenerator("org/kuali/kfs/module/ld/testdata/accountStatusBaseFunds.properties", "org/kuali/kfs/module/ld/testdata/message.properties").getProperties();
        AccountStatusBaseFunds accountStatusBaseFunds = new AccountStatusBaseFunds();
        accountStatusBaseFunds.setAccountNumber("1031400");
        accountStatusBaseFunds.setUniversityFiscalYear(IntegTestUtils.getFiscalYearForTesting());
        accountStatusBaseFunds.setChartOfAccountsCode("BL");
        Map<String, String> fieldValues = this.buildFieldValues(accountStatusBaseFunds, this.getLookupFields());
        this.getInquiryOptionsService().getConsolidationField((Collection)this.lookupableHelperService.getRows()).setPropertyValue("Detail");
        fieldValues.put("dummyBusinessObject.consolidationOption", "Detail");
        List searchResults = this.lookupableHelperService.getSearchResults(fieldValues);
        for (AccountStatusBaseFunds accountStatusBaseFundsReturn : searchResults) {
            BaseFundsLookupableHelperServiceIntegTest.assertTrue((accountStatusBaseFundsReturn.getAccountNumber().equals(accountStatusBaseFunds.getAccountNumber()) && accountStatusBaseFundsReturn.getUniversityFiscalYear().equals(accountStatusBaseFunds.getUniversityFiscalYear()) && accountStatusBaseFundsReturn.getChartOfAccountsCode().equals(accountStatusBaseFunds.getChartOfAccountsCode()) ? 1 : 0) != 0);
        }
        if (searchResults != null) {
            System.out.println("*** Results Size:" + searchResults.size());
        }
        BaseFundsLookupableHelperServiceIntegTest.assertEquals((int)this.baseFundsExpectedInsertion, (int)searchResults.size());
        String testTarget = "getAccountStatusBaseFunds.";
        System.out.println("****1111");
        List expectedDataList = TestDataPreparator.buildExpectedValueList(AccountStatusBaseFunds.class, (Properties)this.properties, (String)"getAccountStatusBaseFunds.expected", (String)this.fieldNames, (String)this.deliminator, (int)this.baseFundsExpectedInsertion);
        for (Object expectedAccountStatusBaseFundsAsObject : expectedDataList) {
            AccountStatusBaseFunds expectedAccountStatusBaseFunds = (AccountStatusBaseFunds)expectedAccountStatusBaseFundsAsObject;
            expectedAccountStatusBaseFunds.setUniversityFiscalYear(IntegTestUtils.getFiscalYearForTesting());
        }
        System.out.println("****2222");
        Iterator iterator = searchResults.iterator();
        while (iterator.hasNext()) {
            AccountStatusBaseFunds searchResult;
            accountStatusBaseFunds = searchResult = (AccountStatusBaseFunds)iterator.next();
            System.out.println("*********DATA:" + accountStatusBaseFunds.toString());
            BaseFundsLookupableHelperServiceIntegTest.assertTrue((String)"Expected data list doesn't contain accountStatusBaseFunds", (boolean)expectedDataList.contains(accountStatusBaseFunds));
        }
        BaseFundsLookupableHelperServiceIntegTest.assertEquals((int)this.baseFundsExpectedInsertion, (int)searchResults.size());
    }

    private Map<String, String> buildFieldValues(AccountStatusBaseFunds accountStatusBaseFunds, List<String> lookupFields) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Map tempFieldValues = ObjectUtil.buildPropertyMap((Object)accountStatusBaseFunds, lookupFields);
        for (String key : tempFieldValues.keySet()) {
            fieldValues.put(key, tempFieldValues.get(key).toString());
        }
        return fieldValues;
    }

    private List<String> getLookupFields() {
        ArrayList<String> lookupFields = new ArrayList<String>();
        lookupFields.add("universityFiscalYear");
        lookupFields.add("accountNumber");
        lookupFields.add("chartOfAccountsCode");
        return lookupFields;
    }

    protected void insertCSFRecords() {
        String messageFileName = "org/kuali/kfs/module/ld/testdata/message.properties";
        String propertiesFileName = "org/kuali/kfs/module/ld/testdata/csfTracker.properties";
        this.properties = new TestDataGenerator("org/kuali/kfs/module/ld/testdata/csfTracker.properties", "org/kuali/kfs/module/ld/testdata/message.properties").getProperties();
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
    }

    protected void insertBaseFundsRecords() {
        String testTarget = "getAccountStatusBaseFunds.";
        String messageFileName = "org/kuali/kfs/module/ld/testdata/message.properties";
        String propertiesFileName = "org/kuali/kfs/module/ld/testdata/accountStatusBaseFunds.properties";
        this.properties = new TestDataGenerator("org/kuali/kfs/module/ld/testdata/accountStatusBaseFunds.properties", "org/kuali/kfs/module/ld/testdata/message.properties").getProperties();
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        int numberOfData = Integer.parseInt(this.properties.getProperty("getAccountStatusBaseFunds.numOfData"));
        ArrayList<AccountStatusBaseFunds> inputDataList = new ArrayList<AccountStatusBaseFunds>();
        for (int i = 1; i <= numberOfData; ++i) {
            AccountStatusBaseFunds inputData = new AccountStatusBaseFunds();
            String propertyKey = "getAccountStatusBaseFunds.testData" + i;
            ObjectUtil.populateBusinessObject((Object)inputData, (Properties)this.properties, (String)propertyKey, (String)this.fieldNames, (String)this.deliminator);
            inputData.setUniversityFiscalYear(IntegTestUtils.getFiscalYearForTesting());
            inputDataList.add(inputData);
        }
        this.baseFundsExpectedInsertion = Integer.parseInt(this.properties.getProperty("getAccountStatusBaseFunds.expectedNumOfData"));
        this.businessObjectService.save(inputDataList);
    }

    private LaborInquiryOptionsService getInquiryOptionsService() {
        return (LaborInquiryOptionsService)SpringContext.getBean(LaborInquiryOptionsService.class);
    }
}

