/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.gl.web.TestDataGenerator;
import org.kuali.kfs.kns.lookup.LookupableHelperService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.businessobject.AccountStatusCurrentFunds;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.businessobject.lookup.LookupableSpringContext;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class CurrentFundsLookupableHelperServiceIntegTest
extends KualiIntegTestBase {
    private BusinessObjectService businessObjectService;
    private LookupableHelperService lookupableHelperService;
    private int currentFundsExpectedInsertion;

    protected void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.lookupableHelperService = LookupableSpringContext.getLookupableHelperService((String)"CurrentFundsLookupableHelperService");
        if (this.lookupableHelperService != null) {
            this.lookupableHelperService.setBusinessObjectClass(AccountStatusCurrentFunds.class);
        }
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("accountNumber", "6044906");
        keys.put("universityFiscalYear", IntegTestUtils.getFiscalYearForTesting().toString());
        keys.put("chartOfAccountsCode", "BA");
        this.businessObjectService.deleteMatching(LedgerBalance.class, keys);
    }

    public void testGetSearchResults() {
        this.insertCurrentFundsRecords();
        AccountStatusCurrentFunds accountStatusCurrentFunds = new AccountStatusCurrentFunds();
        accountStatusCurrentFunds.setAccountNumber("6044906");
        accountStatusCurrentFunds.setUniversityFiscalYear(IntegTestUtils.getFiscalYearForTesting());
        accountStatusCurrentFunds.setChartOfAccountsCode("BA");
        Map<String, String> fieldValues = this.buildFieldValues(accountStatusCurrentFunds, this.getLookupFields());
        this.getInquiryOptionsService().getConsolidationField((Collection)this.lookupableHelperService.getRows()).setPropertyValue("Detail");
        fieldValues.put("dummyBusinessObject.consolidationOption", "Detail");
        List searchResults = this.lookupableHelperService.getSearchResults(fieldValues);
        for (AccountStatusCurrentFunds accountStatusCurrentFundsReturn : searchResults) {
            CurrentFundsLookupableHelperServiceIntegTest.assertTrue((accountStatusCurrentFundsReturn.getAccountNumber().equals(accountStatusCurrentFunds.getAccountNumber()) && accountStatusCurrentFundsReturn.getUniversityFiscalYear().equals(accountStatusCurrentFunds.getUniversityFiscalYear()) && accountStatusCurrentFundsReturn.getChartOfAccountsCode().equals(accountStatusCurrentFunds.getChartOfAccountsCode()) ? 1 : 0) != 0);
        }
        CurrentFundsLookupableHelperServiceIntegTest.assertEquals((int)this.currentFundsExpectedInsertion, (int)searchResults.size());
    }

    public void testGetSearchResultsConsolidated() {
        this.insertCurrentFundsRecords();
        AccountStatusCurrentFunds accountStatusCurrentFunds = new AccountStatusCurrentFunds();
        accountStatusCurrentFunds.setAccountNumber("6044906");
        accountStatusCurrentFunds.setUniversityFiscalYear(IntegTestUtils.getFiscalYearForTesting());
        accountStatusCurrentFunds.setChartOfAccountsCode("BA");
        Map<String, String> fieldValues = this.buildFieldValues(accountStatusCurrentFunds, this.getLookupFields());
        this.getInquiryOptionsService().getConsolidationField((Collection)this.lookupableHelperService.getRows()).setPropertyValue("Consolidation");
        fieldValues.put("dummyBusinessObject.consolidationOption", "Consolidation");
        List searchResults = this.lookupableHelperService.getSearchResults(fieldValues);
        for (AccountStatusCurrentFunds accountStatusCurrentFundsReturn : searchResults) {
            CurrentFundsLookupableHelperServiceIntegTest.assertTrue((accountStatusCurrentFundsReturn.getAccountNumber().equals(accountStatusCurrentFunds.getAccountNumber()) && accountStatusCurrentFundsReturn.getUniversityFiscalYear().equals(accountStatusCurrentFunds.getUniversityFiscalYear()) && accountStatusCurrentFundsReturn.getChartOfAccountsCode().equals(accountStatusCurrentFunds.getChartOfAccountsCode()) ? 1 : 0) != 0);
        }
        CurrentFundsLookupableHelperServiceIntegTest.assertEquals((int)this.currentFundsExpectedInsertion, (int)searchResults.size());
    }

    private Map<String, String> buildFieldValues(AccountStatusCurrentFunds accountStatusCurrentFunds, List<String> lookupFields) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Map tempFieldValues = ObjectUtil.buildPropertyMap((Object)accountStatusCurrentFunds, lookupFields);
        for (String key : tempFieldValues.keySet()) {
            fieldValues.put(key, tempFieldValues.get(key).toString());
        }
        return fieldValues;
    }

    private List<String> getLookupFields() {
        ArrayList<String> lookupFields = new ArrayList<String>();
        lookupFields.add("universityFiscalYear");
        lookupFields.add("accountNumber");
        lookupFields.add("chartOfAccountsCode");
        return lookupFields;
    }

    private void insertCurrentFundsRecords() {
        String messageFileName = "org/kuali/kfs/module/ld/testdata/message.properties";
        String propertiesFileName = "org/kuali/kfs/module/ld/testdata/accountStatusCurrentFunds.properties";
        Properties properties = new TestDataGenerator("org/kuali/kfs/module/ld/testdata/accountStatusCurrentFunds.properties", "org/kuali/kfs/module/ld/testdata/message.properties").getProperties();
        String documentFieldNames = properties.getProperty("fieldNames");
        String deliminator = properties.getProperty("deliminator");
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        int numberOfDocuments = Integer.parseInt(properties.getProperty("getAccountStatusCurrentFunds.numOfData"));
        ArrayList<LedgerBalance> inputDataList = new ArrayList<LedgerBalance>();
        for (int i = 1; i <= numberOfDocuments; ++i) {
            String propertyKey = "getAccountStatusCurrentFunds.testData" + i;
            LedgerBalance inputData = new LedgerBalance();
            ObjectUtil.populateBusinessObject((Object)inputData, (Properties)properties, (String)propertyKey, (String)documentFieldNames, (String)deliminator);
            inputData.setUniversityFiscalYear(IntegTestUtils.getFiscalYearForTesting());
            inputDataList.add(inputData);
        }
        String testTarget = "getAccountStatusCurrentFunds.";
        this.currentFundsExpectedInsertion = Integer.parseInt(properties.getProperty("getAccountStatusCurrentFunds.expectedInsertion"));
        this.businessObjectService.save(inputDataList);
    }

    private LaborInquiryOptionsService getInquiryOptionsService() {
        return (LaborInquiryOptionsService)SpringContext.getBean(LaborInquiryOptionsService.class);
    }
}

