/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.service.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.document.service.impl.LaborPendingEntryConverterServiceImpl;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class LaborPendingEntryConverterServiceImplTest {
    protected LaborPendingEntryConverterServiceImpl cut;
    @Mock
    protected ParameterService paramSvcMock;

    LaborPendingEntryConverterServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new LaborPendingEntryConverterServiceImpl();
        this.cut.setParameterService(this.paramSvcMock);
    }

    @Test
    void copySubObjectToBenefitEntriesEnabled() {
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsBoolean(KfsParameterConstants.LABOR_DOCUMENT.class, "COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES_IND", Boolean.valueOf(false))).thenReturn((Object)true);
        String subCode = "FOO";
        ExpenseTransferSourceAccountingLine sourceLine = new ExpenseTransferSourceAccountingLine();
        sourceLine.setFinancialSubObjectCode("FOO");
        LaborLedgerPendingEntry pendingEntry = new LaborLedgerPendingEntry();
        Assertions.assertNull((Object)pendingEntry.getFinancialSubObjectCode());
        this.cut.setSubobjectCodeOnBenefitPendingEntry((ExpenseTransferAccountingLine)sourceLine, pendingEntry);
        Assertions.assertEquals((Object)"FOO", (Object)pendingEntry.getFinancialSubObjectCode());
    }

    @Test
    void copySubObjectToBenefitEntriesDisabled() {
        Mockito.when((Object)this.paramSvcMock.getParameterValueAsBoolean(KfsParameterConstants.LABOR_DOCUMENT.class, "COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES_IND", Boolean.valueOf(false))).thenReturn((Object)false);
        ExpenseTransferSourceAccountingLine sourceLine = new ExpenseTransferSourceAccountingLine();
        sourceLine.setFinancialSubObjectCode("FOO");
        LaborLedgerPendingEntry pendingEntry = new LaborLedgerPendingEntry();
        Assertions.assertNull((Object)pendingEntry.getFinancialSubObjectCode());
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            DataDictionaryService dataDictionarySvcMock = (DataDictionaryService)Mockito.mock(DataDictionaryService.class);
            Mockito.when((Object)dataDictionarySvcMock.getAttributeMaxLength(OriginEntryFull.class, "financialSubObjectCode")).thenReturn((Object)10);
            springContextMockedStatic.when(() -> SpringContext.getBean(DataDictionaryService.class)).thenReturn((Object)dataDictionarySvcMock);
            this.cut.setSubobjectCodeOnBenefitPendingEntry((ExpenseTransferAccountingLine)sourceLine, pendingEntry);
        }
        Assertions.assertEquals((Object)KFSConstants.getDashFinancialSubObjectCode(), (Object)pendingEntry.getFinancialSubObjectCode());
    }
}

