/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class LaborLedgerPendingEntryServiceIntegTest
extends KualiIntegTestBase {
    private final Properties properties;
    private final String deliminator;
    private LaborLedgerPendingEntryService laborLedgerPendingEntryService;
    private BusinessObjectService businessObjectService;

    public LaborLedgerPendingEntryServiceIntegTest() {
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborLedgerPendingEntryService.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.deliminator = this.properties.getProperty("deliminator");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.laborLedgerPendingEntryService = (LaborLedgerPendingEntryService)SpringContext.getBean(LaborLedgerPendingEntryService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        Map fieldValues = TestDataPreparator.buildCleanupCriteria(LaborLedgerPendingEntry.class, (Properties)this.properties, (String)"dataCleanup");
        this.businessObjectService.deleteMatching(LaborLedgerPendingEntry.class, fieldValues);
    }

    public void testHasPendingLaborLedgerEntryWithAccount() {
        String testTarget = "hasPendingLaborLedgerEntryWithAccount";
        int numberOfTestData = Integer.parseInt(this.properties.getProperty("hasPendingLaborLedgerEntryWithAccount.numOfData"));
        String accountFieldNames = this.properties.getProperty("hasPendingLaborLedgerEntryWithAccount.accountFieldNames");
        String prefixForInput = "hasPendingLaborLedgerEntryWithAccount.testData";
        List inputDataList = TestDataPreparator.buildTestDataList(LaborLedgerPendingEntry.class, (Properties)this.properties, (String)"hasPendingLaborLedgerEntryWithAccount.testData", (int)numberOfTestData);
        this.businessObjectService.save(inputDataList);
        String prefixForValidAccount = "hasPendingLaborLedgerEntryWithAccount.accountWithResults";
        int numOfValidAccounts = Integer.parseInt(this.properties.getProperty("hasPendingLaborLedgerEntryWithAccount.accountWithResults.numOfData"));
        List validAccounts = TestDataPreparator.buildTestDataList(Account.class, (Properties)this.properties, (String)"hasPendingLaborLedgerEntryWithAccount.accountWithResults", (String)accountFieldNames, (String)this.deliminator, (int)numOfValidAccounts);
        for (Account account : validAccounts) {
            LaborLedgerPendingEntryServiceIntegTest.assertTrue((String)"At least one record can be found.", (boolean)this.laborLedgerPendingEntryService.hasPendingLaborLedgerEntry(account.getChartOfAccountsCode(), account.getAccountNumber()));
        }
        String prefixForInvalidAccount = "hasPendingLaborLedgerEntryWithAccount.accountWithoutResults";
        int numOfInvalidAccounts = Integer.parseInt(this.properties.getProperty("hasPendingLaborLedgerEntryWithAccount.accountWithoutResults.numOfData"));
        List invalidAccounts = TestDataPreparator.buildTestDataList(Account.class, (Properties)this.properties, (String)"hasPendingLaborLedgerEntryWithAccount.accountWithoutResults", (String)accountFieldNames, (String)this.deliminator, (int)numOfInvalidAccounts);
        for (Account account : invalidAccounts) {
            LaborLedgerPendingEntryServiceIntegTest.assertFalse((String)"Must not find anything.", (boolean)this.laborLedgerPendingEntryService.hasPendingLaborLedgerEntry(account.getChartOfAccountsCode(), account.getAccountNumber()));
        }
    }
}

