/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.core.api.util.type.KualiInteger;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.util.SimpleAddress;
import org.kuali.kfs.sys.ObjectUtil;

public class ObjectUtilTest {
    @Test
    public void buildObject() {
        SimpleAddress sourceAddress = new SimpleAddress("1000 Main Street", "Source City", "Kuali", 10000);
        ArrayList<String> propertyList = new ArrayList<String>();
        SimpleAddress targetAddress = new SimpleAddress(null, null, null, 9999);
        ObjectUtil.buildObject((Object)targetAddress, (Object)sourceAddress);
        Assertions.assertEquals((Object)targetAddress, (Object)sourceAddress);
        targetAddress = new SimpleAddress(null, null, null, 9999);
        propertyList.add("street");
        ObjectUtil.buildObject((Object)targetAddress, (Object)sourceAddress, propertyList);
        Assertions.assertEquals((Object)sourceAddress.getStreet(), (Object)targetAddress.getStreet());
        Assertions.assertNotEquals((Object)targetAddress, (Object)sourceAddress);
        targetAddress = new SimpleAddress(null, null, null, 9999);
        Object[] sourceAddressArray = new String[]{"1000 Main Street", "Source City", "Kuali", "10000"};
        propertyList.clear();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        ObjectUtil.buildObject((Object)targetAddress, (Object[])sourceAddressArray, propertyList);
        Assertions.assertNotEquals((Object)targetAddress, (Object)sourceAddress);
        propertyList.add("zip");
        ObjectUtil.buildObject((Object)targetAddress, (Object[])sourceAddressArray, propertyList);
        Assertions.assertEquals((Object)targetAddress, (Object)sourceAddress);
    }

    @Test
    public void compareObject() {
        SimpleAddress sourceAddress = new SimpleAddress("1000 Main Street", "Source City", "Kuali", 10000);
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        propertyList.add("zip");
        SimpleAddress targetAddress = new SimpleAddress(null, null, null, 9999);
        Assertions.assertFalse((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
        targetAddress = new SimpleAddress("1000 Main Street", "Source City", "Kuali", 10000);
        Assertions.assertTrue((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
        targetAddress = sourceAddress;
        Assertions.assertTrue((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
        targetAddress = new SimpleAddress(null, null, null, 9999);
        ObjectUtil.buildObject((Object)targetAddress, (Object)sourceAddress);
        Assertions.assertTrue((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
        sourceAddress.setZip(2000);
        Assertions.assertFalse((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
        propertyList.remove("zip");
        Assertions.assertTrue((boolean)ObjectUtil.equals((Object)targetAddress, (Object)sourceAddress, propertyList));
    }

    @Test
    public void buildPropertyMap() {
        SimpleAddress address = new SimpleAddress("1000 Main Street", "Source City", "Kuali", 10000);
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        Map propertyMap = ObjectUtil.buildPropertyMap((Object)address, propertyList);
        Assertions.assertEquals((Object)address.getStreet(), propertyMap.get("street"));
        Assertions.assertEquals((Object)address.getCity(), propertyMap.get("city"));
        Assertions.assertEquals((Object)address.getState(), propertyMap.get("state"));
        Assertions.assertNotEquals((Object)address.getZip(), propertyMap.get("zip"));
        propertyList.add("zip");
        propertyMap = ObjectUtil.buildPropertyMap((Object)address, propertyList);
        Assertions.assertEquals((Object)address.getZip(), propertyMap.get("zip"));
    }

    @Test
    public void buildPropertyMapWithBlankValues() {
        SimpleAddress address = new SimpleAddress("", "", null, 1000);
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        propertyList.add("zip");
        Map propertyMap = ObjectUtil.buildPropertyMap((Object)address, propertyList);
        Assertions.assertNull(propertyMap.get("street"));
        Assertions.assertNull(propertyMap.get("city"));
        Assertions.assertNull(propertyMap.get("state"));
        Assertions.assertEquals((Object)address.getZip(), propertyMap.get("zip"));
        Assertions.assertEquals((int)1, (int)propertyMap.size());
    }

    @Test
    public void convertLineToBusinessObjectBasedOnDeliminatorAndKeyList() {
        String delim = ";";
        String line = "1000 Main Street;Source City;Kuali;10000";
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        propertyList.add("zip");
        SimpleAddress address = new SimpleAddress();
        ObjectUtil.convertLineToBusinessObject((Object)address, (String)"1000 Main Street;Source City;Kuali;10000", (String)";", propertyList);
        Assertions.assertEquals((Object)address.getStreet(), (Object)"1000 Main Street");
        Assertions.assertEquals((Object)address.getCity(), (Object)"Source City");
        Assertions.assertEquals((Object)address.getState(), (Object)"Kuali");
        Assertions.assertEquals((Integer)address.getZip(), (Integer)10000);
    }

    @Test
    public void convertLineToBusinessObjectBasedOnDeliminatorAndKeyString() {
        String delim = ";";
        String line = "1000 Main Street;Source City;Kuali;10000;";
        String fieldNames = "street;city;state;zip;";
        SimpleAddress address = new SimpleAddress();
        ObjectUtil.convertLineToBusinessObject((Object)address, (String)"1000 Main Street;Source City;Kuali;10000;", (String)";", (String)"street;city;state;zip;");
        Assertions.assertEquals((Object)"1000 Main Street", (Object)address.getStreet());
        Assertions.assertEquals((Object)"Source City", (Object)address.getCity());
        Assertions.assertEquals((Object)"Kuali", (Object)address.getState());
        Assertions.assertEquals((Integer)10000, (Integer)address.getZip());
    }

    @Test
    public void convertLineToBusinessObjectAtCompressedFormat() {
        String delim = ";";
        String line = ";;;;";
        String fieldNames = "street;city;state;zip;";
        SimpleAddress address = new SimpleAddress("", "", "", null);
        ObjectUtil.convertLineToBusinessObject((Object)address, (String)";;;;", (String)";", (String)"street;city;state;zip;");
        Assertions.assertNull((Object)address.getStreet());
        Assertions.assertNull((Object)address.getCity());
        Assertions.assertNull((Object)address.getState());
        Assertions.assertNull((Object)address.getZip());
    }

    @Test
    public void convertLineToBusinessObjectBasedOnFieldLength() {
        int[] fieldLength = new int[]{6, 4, 5, 5};
        String line = "StreetCityState10000";
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        propertyList.add("zip");
        SimpleAddress address = new SimpleAddress();
        ObjectUtil.convertLineToBusinessObject((Object)address, (String)"StreetCityState10000", (int[])fieldLength, propertyList);
        Assertions.assertEquals((Object)"Street", (Object)address.getStreet());
        Assertions.assertEquals((Object)"City", (Object)address.getCity());
        Assertions.assertEquals((Object)"State", (Object)address.getState());
        Assertions.assertEquals((Integer)10000, (Integer)address.getZip());
    }

    @Test
    public void convertLineToBusinessObjectBasedOnFieldLength_WithWhiteSpace() {
        int[] fieldLength = new int[]{8, 6, 7, 7};
        String line = "Street  City  State  10000  ";
        ArrayList<String> propertyList = new ArrayList<String>();
        propertyList.add("street");
        propertyList.add("city");
        propertyList.add("state");
        propertyList.add("zip");
        SimpleAddress address = new SimpleAddress();
        ObjectUtil.convertLineToBusinessObject((Object)address, (String)"Street  City  State  10000  ", (int[])fieldLength, propertyList);
        Assertions.assertEquals((Object)"Street", (Object)address.getStreet());
        Assertions.assertEquals((Object)"City", (Object)address.getCity());
        Assertions.assertEquals((Object)"State", (Object)address.getState());
        Assertions.assertEquals((Integer)10000, (Integer)address.getZip());
    }

    @Test
    public void split() {
        String delim = ";";
        Object line = ";;;;";
        List tokens = ObjectUtil.split((String)line, (String)";");
        Assertions.assertEquals((int)4, (int)tokens.size());
        line = ";" + (String)line;
        tokens = ObjectUtil.split((String)line, (String)";");
        Assertions.assertEquals((int)5, (int)tokens.size());
    }

    @Test
    public void valueOfInteger() {
        String integerType = "Integer";
        String[] value = new String[]{"-100", "0", "100", "", "12.9", "bad value"};
        String[] expected = new String[]{"-100", "0", "100", null, null, null};
        for (int i = 0; i < value.length; ++i) {
            String tempvalue = expected[i];
            Integer expectedValue = tempvalue != null ? Integer.valueOf(expected[i]) : null;
            Assertions.assertEquals((Object)expectedValue, (Object)ObjectUtil.valueOf((String)"Integer", (String)value[i]));
        }
    }

    @Test
    public void valueOfKualiDecimal() {
        String type = "KualiDecimal";
        String[] value = new String[]{"-100.00", "0", "100", "100.00", "", "bad value"};
        String[] expected = new String[]{"-100", "0", "100", "100", null, null};
        for (int i = 0; i < value.length; ++i) {
            String tempValue = expected[i];
            KualiDecimal expectedValue = tempValue != null ? new KualiDecimal(expected[i]) : null;
            Assertions.assertEquals((Object)expectedValue, (Object)ObjectUtil.valueOf((String)"KualiDecimal", (String)value[i]));
        }
    }

    @Test
    public void valueOfKualiInteger() {
        String type = "KualiInteger";
        String[] value = new String[]{"-100", "0", "100", "100.00", "", "bad value"};
        String[] expected = new String[]{"-100", "0", "100", null, null, null};
        for (int i = 0; i < value.length; ++i) {
            String tempValue = expected[i];
            KualiInteger expectedValue = tempValue != null ? new KualiInteger(expected[i]) : null;
            Assertions.assertEquals((Object)expectedValue, (Object)ObjectUtil.valueOf((String)"KualiInteger", (String)value[i]));
        }
    }

    @Test
    public void valueOfDate() {
        String type = "Date";
        String[] value = new String[]{"2000-01-31", "2000/1/1", "1/1/2000", "", "bad value"};
        String[] expected = new String[]{"2000-01-31", null, null, null, null};
        for (int i = 0; i < value.length; ++i) {
            String tempValue = expected[i];
            Date expectedValue = tempValue != null ? Date.valueOf(expected[i]) : null;
            Assertions.assertEquals((Object)expectedValue, (Object)ObjectUtil.valueOf((String)"Date", (String)value[i]));
        }
    }

    @Test
    public void valueOfTimestamp() {
        String type = "Timestamp";
        String[] value = new String[]{"2000-01-31 00:12:00.55", "2000-01-31", "2000/1/1", "1/1/2000", "", "bad value"};
        String[] expected = new String[]{"2000-01-31 00:12:00.55", "2000-01-31 00:00:00.0", null, null, null, null};
        for (int i = 0; i < value.length; ++i) {
            String tempValue = expected[i];
            Timestamp expectedValue = tempValue != null ? Timestamp.valueOf(expected[i]) : null;
            Assertions.assertEquals((Object)expectedValue, (Object)ObjectUtil.valueOf((String)"Timestamp", (String)value[i]));
        }
    }

    @Test
    public void hasNullValueField() {
        SimpleAddress sourceAddress = new SimpleAddress(null, null, null, 9999);
        Assertions.assertTrue((boolean)ObjectUtil.hasNullValueField((Object)sourceAddress));
        sourceAddress = new SimpleAddress("1000 Main Street", "Source City", "Kuali", 10000, new KualiDecimal(200000), new Date(1000000L));
        Assertions.assertFalse((boolean)ObjectUtil.hasNullValueField((Object)sourceAddress));
    }

    @Test
    public void parseNestedAttribute() {
        String attributes = "laborObject.chartOfAccounts.chartOfAccountsCode";
        System.out.println(ObjectUtil.getNestedAttributeTypes(LedgerBalance.class, (String)"laborObject.chartOfAccounts.chartOfAccountsCode"));
    }
}

