/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.LateAdjustment;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.validation.impl.LateAdjustmentValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
@Execution(value=ExecutionMode.SAME_THREAD)
class LateAdjustmentValidationTest {
    private LateAdjustmentValidation cut;
    @Mock
    private AttributedDocumentEvent eventMock;
    private LateAdjustment lateAdjustment;

    LateAdjustmentValidationTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.lateAdjustment = new LateAdjustment();
        this.lateAdjustment.setDocumentNumber("1");
        this.lateAdjustment.setLateAdjustmentReason("test reason");
        this.lateAdjustment.setLateAdjustmentDescription("test desc");
        SalaryExpenseTransferDocument stDocumentMock = (SalaryExpenseTransferDocument)Mockito.mock(SalaryExpenseTransferDocument.class);
        Mockito.when((Object)stDocumentMock.getLateAdjustment()).thenReturn((Object)this.lateAdjustment);
        Mockito.when((Object)this.eventMock.getDocument()).thenReturn((Object)stDocumentMock);
        this.cut = new LateAdjustmentValidation();
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validate_PartiallyFullLateAdjustment() {
        this.cut.validate(this.eventMock);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.lateAdjustment");
        Assertions.assertTrue((boolean)hasError, (String)"Late Adjustment Tab isn't required, but should be.");
    }

    @Test
    void validate_FullLateAdjustment() {
        this.lateAdjustment.setExpenditureDescription("test description");
        this.lateAdjustment.setExpenditureProjectBenefit("test benefit");
        this.cut.validate(this.eventMock);
        boolean hasError = GlobalVariables.getMessageMap().doesPropertyHaveError("document.lateAdjustment");
        Assertions.assertFalse((boolean)hasError, (String)"Unexpected requirement of Late Adjustment Tab.");
    }
}

