/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.batch;

import org.kuali.kfs.module.ld.batch.service.LaborNightlyOutService;
import org.kuali.kfs.sys.batch.AbstractStep;

import java.util.Date;

/**
 * Clear Labor Batch Step.
 */
public class ClearLaborPendingStep extends AbstractStep {

    private LaborNightlyOutService laborNightlyOutService;

    /**
     * Deletes copied labor general ledger entries from pending entry table.
     *
     * @param jobName    String that contains the job that will be executed.
     * @param jobRunDate the time/date the job is run
     * @return boolean
     */
    @Override
    public boolean execute(final String jobName, final Date jobRunDate) {
        laborNightlyOutService.deleteCopiedPendingLedgerEntries();
        return true;
    }

    public void setLaborNightlyOutService(final LaborNightlyOutService laborNightlyOutService) {
        this.laborNightlyOutService = laborNightlyOutService;
    }
}
