/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.batch;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.core.api.datetime.DateTimeService;
import org.kuali.kfs.module.ld.LaborKeyConstants;
import org.kuali.kfs.module.ld.LaborPropertyConstants;
import org.kuali.kfs.sys.batch.BatchInputFileTypeBase;
import org.kuali.kfs.sys.exception.ParseException;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class LaborEncumbranceInputFileType extends BatchInputFileTypeBase {

    private static final Logger LOG = LogManager.getLogger();

    private static final String FILE_NAME_PREFIX = "ENCUMBRANCE_DATA";
    private static final String FILE_NAME_PART_DELIMITER = "_";
    private DateTimeService dateTimeService;

    @Override
    public String getAuthorPrincipalName(final File file) {
        final String[] fileNameParts = StringUtils.split(file.getName(), FILE_NAME_PART_DELIMITER);
        if (fileNameParts.length > 2) {
            return fileNameParts[1];
        }
        return null;
    }

    @Override
    public String getFileName(final String principalName, final Object parsedFileContents, final String fileUserIdentifier) {
        final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_hh.mm.ss.SSS", Locale.US);

        return FILE_NAME_PREFIX + FILE_NAME_PART_DELIMITER + principalName + FILE_NAME_PART_DELIMITER + sdf.format(
                dateTimeService.getCurrentDate());
    }

    @Override
    public String getFileTypeIdentifier() {
        return LaborPropertyConstants.LABOR_ENCUMBRANCE_INPUT_FILE_TYPE_INDENTIFIER;
    }

    @Override
    public String getTitleKey() {
        return LaborKeyConstants.MESSAGE_BATCH_UPLOAD_TITLE_ADP_PAYROLL_ENCUMBRANCE;
    }

    public void setDateTimeService(final DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    @Override
    public boolean validate(final Object parsedFileContents) {
        return true;
    }

    @Override
    public void process(final String fileName, final Object parsedFileContents) {
        // do not do anything
    }

    @Override
    public Object parse(final byte[] fileByteContent) throws ParseException {
        return fileByteContent;
    }
}
