/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class LaborExpenseTransferDuplicateSourceAccountingLineValidation
extends GenericValidation {
    private AccountingLine accountingLineForValidation;
    private AccountingDocument accountingDocumentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        AccountingLine accountingLine;
        AccountingDocument accountingDocument = this.getAccountingDocumentForValidation();
        if (this.isDuplicateSourceAccountingLine(accountingDocument, accountingLine = this.getAccountingLineForValidation())) {
            GlobalVariables.getMessageMap().putError("sourceAccountingLines", "error.labor.duplicateSourceAccountingLine", new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isDuplicateSourceAccountingLine(AccountingDocument accountingDocument, AccountingLine accountingLine) {
        if (!(accountingLine instanceof ExpenseTransferSourceAccountingLine)) {
            return false;
        }
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)accountingDocument;
        List sourceAccountingLines = expenseTransferDocument.getSourceAccountingLines();
        List<String> key = this.defaultKeyOfExpenseTransferAccountingLine();
        int counter = 0;
        for (AccountingLine sourceAccountingLine : sourceAccountingLines) {
            boolean isExisting = ObjectUtil.equals((Object)accountingLine, (Object)sourceAccountingLine, key);
            counter = isExisting ? counter + 1 : counter;
            if (counter <= 1) continue;
            return true;
        }
        return false;
    }

    protected List<String> defaultKeyOfExpenseTransferAccountingLine() {
        ArrayList<String> defaultKey = new ArrayList<String>();
        defaultKey.add("postingYear");
        defaultKey.add("chartOfAccountsCode");
        defaultKey.add("accountNumber");
        defaultKey.add("subAccountNumber");
        defaultKey.add("balanceTypeCode");
        defaultKey.add("financialObjectCode");
        defaultKey.add("financialSubObjectCode");
        defaultKey.add("emplid");
        defaultKey.add("positionNumber");
        defaultKey.add("payrollEndDateFiscalYear");
        defaultKey.add("payrollEndDateFiscalPeriodCode");
        return defaultKey;
    }

    public AccountingDocument getAccountingDocumentForValidation() {
        return this.accountingDocumentForValidation;
    }

    public void setAccountingDocumentForValidation(AccountingDocument accountingDocumentForValidation) {
        this.accountingDocumentForValidation = accountingDocumentForValidation;
    }

    public AccountingLine getAccountingLineForValidation() {
        return this.accountingLineForValidation;
    }

    public void setAccountingLineForValidation(AccountingLine accountingLineForValidation) {
        this.accountingLineForValidation = accountingLineForValidation;
    }
}

