/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.kns.document.MaintenanceDocumentBase;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.validation.PurapRuleTestBase;
import org.kuali.kfs.module.purap.document.validation.impl.ThresholdRule;
import org.kuali.kfs.module.purap.fixture.ThresholdFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ThresholdRuleTest
extends PurapRuleTestBase {
    private ThresholdRule thresholdRule;

    protected void setUp() throws Exception {
        super.setUp();
        this.thresholdRule = new ThresholdRule();
    }

    public final void testThreshold_InvalidDescription() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE);
        doc.getDocumentHeader().setDocumentDescription(null);
        ThresholdRuleTest.assertFalse((boolean)this.thresholdRule.processSaveDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.documentHeader.documentDescription"));
    }

    public final void testThreshold_ChartOfAccount() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
    }

    public final void testThreshold_ChartOfAccount_Invalid() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_INVALID);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processRouteDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        ThresholdRuleTest.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.newMaintainableObject.chartOfAccountsCode"));
    }

    public final void testThreshold_ChartOfAccountAndAccountType() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_ACCOUNTTYPE);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
    }

    public final void testThreshold_ChartOfAccountAndSubAccountType() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_SUBACCOUNTTYPE);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
    }

    public final void testThreshold_ChartOfAccountAndSubAccountType_Invalid() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_SUBACCOUNTTYPE_INVALID);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processRouteDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        ThresholdRuleTest.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.newMaintainableObject.subFundGroupCode"));
    }

    public final void testThreshold_ChartOfAccountAndAccountTypeAndSubAccountType() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_ACCOUNTTYPE_AND_SUBACCOUNTTYPE);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
        ThresholdRuleTest.assertFalse((boolean)this.thresholdRule.processRouteDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        ThresholdRuleTest.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.newMaintainableObject.accountTypeCode"));
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.newMaintainableObject.subFundGroupCode"));
    }

    public final void testThreshold_ChartOfAccountAndCommodityCode() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_COMMODITYCODE);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
    }

    public final void testThreshold_ChartOfAccountAndCommodityCode_Invalid() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_COMMODITYCODE_INVALID);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processRouteDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        ThresholdRuleTest.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.newMaintainableObject.purchasingCommodityCode"));
    }

    public final void testThreshold_ChartOfAccountAndObjectCode() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_OBJECTCODE);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
    }

    public final void testThreshold_ChartOfAccountAndObjectCode_Invalid() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_OBJECTCODE_INVALID);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processRouteDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        ThresholdRuleTest.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.newMaintainableObject.financialObjectCode"));
    }

    public final void testThreshold_ChartOfAccountAndOrgCode() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_ORGCODE);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
    }

    public final void testThreshold_ChartOfAccountAndOrgCode_Invalid() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_ORGCODE_INVALID);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processRouteDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        ThresholdRuleTest.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.newMaintainableObject.organizationCode"));
    }

    public final void testThreshold_ChartOfAccountAndVendorNumber() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_VENDORNUMBER);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
    }

    public final void testThreshold_ChartOfAccountAndVendorNumber_Invalid() {
        MaintenanceDocumentBase doc = this.getMaintenanceDocument(ThresholdFixture.CHARTCODE_AND_VENDORNUMBER_INVALID);
        ThresholdRuleTest.assertTrue((boolean)this.thresholdRule.processSaveDocument((Document)doc));
        ThresholdRuleTest.assertFalse((boolean)this.thresholdRule.processRouteDocument((Document)doc));
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().hasErrors());
        ThresholdRuleTest.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ThresholdRuleTest.assertTrue((boolean)GlobalVariables.getMessageMap().getErrorMessages().containsKey("document.newMaintainableObject.vendorNumber"));
    }

    private MaintenanceDocumentBase getMaintenanceDocument(ThresholdFixture thresholdFixture) {
        MaintenanceDocumentBase doc = null;
        try {
            doc = (MaintenanceDocumentBase)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("THLD");
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Document creation failed.");
        }
        doc.getDocumentHeader().setDocumentDescription("JUnit test document");
        Maintainable maintainableDoc = doc.getNewMaintainableObject();
        maintainableDoc.setBusinessObject((PersistableBusinessObject)thresholdFixture.getThresholdBO());
        return doc;
    }
}

