/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderSensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignment;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignmentDetail;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.SensitiveDataFixture;
import org.kuali.kfs.module.purap.service.SensitiveDataService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class SensitiveDataServiceTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(SensitiveDataServiceTest.class);
    protected BusinessObjectService boService;
    protected SensitiveDataService sdService;
    protected PurchaseOrderDocument po;
    protected SensitiveData sdNew;

    protected void setUp() throws Exception {
        super.setUp();
        if (this.boService == null) {
            this.boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
        if (this.sdService == null) {
            this.sdService = (SensitiveDataService)SpringContext.getBean(SensitiveDataService.class);
        }
        if (this.po == null) {
            this.po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        }
        if (this.po.getPurapDocumentIdentifier() == null) {
            this.po.setPurapDocumentIdentifier(new Integer(9001));
        }
        if (this.po.getRequisitionIdentifier() == null) {
            this.po.setRequisitionIdentifier(new Integer(9001));
        }
        if (this.sdNew == null) {
            this.sdNew = SensitiveDataFixture.SENSITIVE_DATA_ACTIVE.getSensitiveDataBO();
        }
        if (this.boService.retrieve((PersistableBusinessObject)this.sdNew) == null) {
            this.boService.save((PersistableBusinessObject)this.sdNew);
        }
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testGetSensitiveData() {
        List sds = this.sdService.getAllSensitiveDatas();
        SensitiveDataServiceTest.assertTrue((sds.size() > 0 ? 1 : 0) != 0);
        String code = this.sdNew.getSensitiveDataCode();
        SensitiveData sdRet = this.sdService.getSensitiveDataByCode(code);
        SensitiveDataServiceTest.assertTrue((sdRet != null ? 1 : 0) != 0);
        SensitiveDataServiceTest.assertTrue((boolean)sdRet.getSensitiveDataCode().equalsIgnoreCase(code));
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public void testSensitiveDataAssignment() {
        Integer poId = this.po.getPurapDocumentIdentifier();
        String reason = "test";
        String userId = "parke";
        Date date = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
        List sds = this.sdService.getAllSensitiveDatas();
        SensitiveDataAssignment sda = new SensitiveDataAssignment();
        sda.setPurapDocumentIdentifier(poId);
        sda.setSensitiveDataAssignmentReasonText(reason);
        sda.setSensitiveDataAssignmentChangeDate((java.util.Date)date);
        sda.setSensitiveDataAssignmentPersonIdentifier(userId);
        this.sdService.saveSensitiveDataAssignment(sda);
        SensitiveDataAssignment sdaRet = this.sdService.getLastSensitiveDataAssignment(poId);
        SensitiveDataServiceTest.assertTrue((boolean)sdaRet.getPurapDocumentIdentifier().equals(poId));
        SensitiveDataServiceTest.assertTrue((boolean)sdaRet.getSensitiveDataAssignmentReasonText().equals(reason));
        SensitiveDataServiceTest.assertTrue((boolean)sdaRet.getSensitiveDataAssignmentPersonIdentifier().equals(userId));
        Integer sdaId = sdaRet.getSensitiveDataAssignmentIdentifier();
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put("purapDocumentIdentifier", poId);
        Collection sdas = this.boService.findMatching(SensitiveDataAssignment.class, fieldValues);
        for (Object sdaR : sdas) {
            SensitiveDataServiceTest.assertTrue((sdaId >= sdaR.getSensitiveDataAssignmentIdentifier() ? 1 : 0) != 0);
        }
        ArrayList<SensitiveDataAssignmentDetail> sdads = new ArrayList<SensitiveDataAssignmentDetail>();
        for (Object sd : sds) {
            SensitiveDataAssignmentDetail sdad = new SensitiveDataAssignmentDetail();
            sdad.setSensitiveDataAssignmentIdentifier(sdaId);
            sdad.setSensitiveDataCode(sd.getSensitiveDataCode());
            sdads.add(sdad);
        }
        this.sdService.saveSensitiveDataAssignmentDetails(sdads);
        List sdadsRet = this.sdService.getLastSensitiveDataAssignmentDetails(poId);
        SensitiveDataServiceTest.assertTrue((sdadsRet.size() == sdads.size() ? 1 : 0) != 0);
        for (SensitiveDataAssignmentDetail sdadR : sdadsRet) {
            SensitiveDataServiceTest.assertTrue((boolean)sdadR.getSensitiveDataAssignmentIdentifier().equals(sdaId));
        }
        this.sdService.deletePurchaseOrderSensitiveDatas(poId);
        List sdsRet = this.sdService.getSensitiveDatasAssignedByPoId(poId);
        SensitiveDataServiceTest.assertTrue((sdsRet.size() == 0 ? 1 : 0) != 0);
        ArrayList<PurchaseOrderSensitiveData> posds = new ArrayList<PurchaseOrderSensitiveData>();
        for (SensitiveData sd : sds) {
            PurchaseOrderSensitiveData posd = new PurchaseOrderSensitiveData();
            posd.setPurapDocumentIdentifier(poId);
            posd.setRequisitionIdentifier(this.po.getRequisitionIdentifier());
            posd.setSensitiveDataCode(sd.getSensitiveDataCode());
            posds.add(posd);
        }
        this.sdService.savePurchaseOrderSensitiveDatas(posds);
        sdsRet = this.sdService.getSensitiveDatasAssignedByPoId(poId);
        SensitiveDataServiceTest.assertTrue((sdsRet.size() == posds.size() ? 1 : 0) != 0);
    }
}

