/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.sql.Timestamp;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.AccountsPayableItem;
import org.kuali.kfs.module.purap.businessobject.PurApItemUseTax;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.service.AccountsPayableDocumentSpecificService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.CampusParameter;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public abstract class AccountsPayableDocumentBase
extends PurchasingAccountsPayableDocumentBase
implements AccountsPayableDocument {
    private static final Logger LOG = Logger.getLogger(AccountsPayableDocumentBase.class);
    protected Timestamp accountsPayableApprovalTimestamp;
    protected String lastActionPerformedByPersonId;
    protected String accountsPayableProcessorIdentifier;
    protected boolean holdIndicator;
    protected Timestamp extractedTimestamp;
    protected Integer purchaseOrderIdentifier;
    protected String processingCampusCode;
    protected String noteLine1Text;
    protected String noteLine2Text;
    protected String noteLine3Text;
    protected boolean continuationAccountIndicator;
    protected boolean closePurchaseOrderIndicator;
    protected boolean reopenPurchaseOrderIndicator;
    protected String bankCode;
    protected boolean unmatchedOverride;
    protected String chartOfAccountsCode;
    protected String organizationCode;
    protected boolean generateEncumbranceEntries;
    protected String debitCreditCodeForGLEntries;
    protected PurApItemUseTax offsetUseTax;
    protected CampusParameter processingCampus;
    protected transient PurchaseOrderDocument purchaseOrderDocument;
    protected Bank bank;

    public AccountsPayableDocumentBase() {
        this.setUnmatchedOverride(false);
    }

    public void setLineItemTotal(KualiDecimal total) {
    }

    public void setGrandTotal(KualiDecimal total) {
    }

    protected void removeGeneralLedgerPendingEntries() {
    }

    @Override
    public boolean requiresAccountsPayableReviewRouting() {
        return !this.approvalAtAccountsPayableReviewAllowed();
    }

    @Override
    public boolean approvalAtAccountsPayableReviewAllowed() {
        return !this.isAttachmentRequired() || !this.documentHasNoImagesAttached();
    }

    protected abstract boolean isAttachmentRequired();

    public abstract boolean documentHasNoImagesAttached();

    public void populateDocumentForRouting() {
        if (ObjectUtils.isNotNull((Object)this.getPurchaseOrderDocument())) {
            this.setChartOfAccountsCode(this.getPurchaseOrderDocument().getChartOfAccountsCode());
            this.setOrganizationCode(this.getPurchaseOrderDocument().getOrganizationCode());
            if (ObjectUtils.isNull((Object)this.getPurchaseOrderDocument().getDocumentHeader().getDocumentNumber())) {
                this.getPurchaseOrderDocument().refreshReferenceObject("documentHeader");
            }
        }
        super.populateDocumentForRouting();
    }

    @Override
    public void prepareForSave(KualiDocumentEvent event) {
        this.customPrepareForSave(event);
    }

    public abstract String getPoDocumentTypeForAccountsPayableDocumentCancel();

    public void doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) {
        LOG.debug((Object)"handleRouteLevelChange() started");
        super.doRouteLevelChange(levelChangeEvent);
        String newNodeName = levelChangeEvent.getNewNodeName();
        this.processNodeChange(newNodeName, levelChangeEvent.getOldNodeName());
        this.saveDocumentFromPostProcessing();
    }

    public abstract boolean processNodeChange(String var1, String var2);

    public abstract void saveDocumentFromPostProcessing();

    @Override
    public Integer getPurchaseOrderIdentifier() {
        return this.purchaseOrderIdentifier;
    }

    @Override
    public void setPurchaseOrderIdentifier(Integer purchaseOrderIdentifier) {
        this.purchaseOrderIdentifier = purchaseOrderIdentifier;
    }

    @Override
    public String getAccountsPayableProcessorIdentifier() {
        return this.accountsPayableProcessorIdentifier;
    }

    @Override
    public void setAccountsPayableProcessorIdentifier(String accountsPayableProcessorIdentifier) {
        this.accountsPayableProcessorIdentifier = accountsPayableProcessorIdentifier;
    }

    @Override
    public String getLastActionPerformedByPersonId() {
        return this.lastActionPerformedByPersonId;
    }

    @Override
    public void setLastActionPerformedByPersonId(String lastActionPerformedByPersonId) {
        this.lastActionPerformedByPersonId = lastActionPerformedByPersonId;
    }

    @Override
    public String getProcessingCampusCode() {
        return this.processingCampusCode;
    }

    @Override
    public void setProcessingCampusCode(String processingCampusCode) {
        this.processingCampusCode = processingCampusCode;
    }

    @Override
    public Timestamp getAccountsPayableApprovalTimestamp() {
        return this.accountsPayableApprovalTimestamp;
    }

    @Override
    public void setAccountsPayableApprovalTimestamp(Timestamp accountsPayableApprovalTimestamp) {
        this.accountsPayableApprovalTimestamp = accountsPayableApprovalTimestamp;
    }

    @Override
    public Timestamp getExtractedTimestamp() {
        return this.extractedTimestamp;
    }

    @Override
    public void setExtractedTimestamp(Timestamp extractedTimestamp) {
        this.extractedTimestamp = extractedTimestamp;
    }

    @Override
    public boolean isHoldIndicator() {
        return this.holdIndicator;
    }

    @Override
    public void setHoldIndicator(boolean holdIndicator) {
        this.holdIndicator = holdIndicator;
    }

    @Override
    public String getNoteLine1Text() {
        return this.noteLine1Text;
    }

    @Override
    public void setNoteLine1Text(String noteLine1Text) {
        this.noteLine1Text = noteLine1Text;
    }

    @Override
    public String getNoteLine2Text() {
        return this.noteLine2Text;
    }

    @Override
    public void setNoteLine2Text(String noteLine2Text) {
        this.noteLine2Text = noteLine2Text;
    }

    @Override
    public String getNoteLine3Text() {
        return this.noteLine3Text;
    }

    @Override
    public void setNoteLine3Text(String noteLine3Text) {
        this.noteLine3Text = noteLine3Text;
    }

    @Override
    public CampusParameter getProcessingCampus() {
        return this.processingCampus;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getOrganizationCode() {
        return this.organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }

    public boolean isGenerateEncumbranceEntries() {
        return this.generateEncumbranceEntries;
    }

    public void setGenerateEncumbranceEntries(boolean generateEncumbranceEntries) {
        this.generateEncumbranceEntries = generateEncumbranceEntries;
    }

    @Override
    public PurchaseOrderDocument getPurchaseOrderDocument() {
        if ((ObjectUtils.isNull((Object)this.purchaseOrderDocument) || ObjectUtils.isNull((Object)this.purchaseOrderDocument.getPurapDocumentIdentifier())) && ObjectUtils.isNotNull((Object)this.getPurchaseOrderIdentifier())) {
            this.setPurchaseOrderDocument(((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).getCurrentPurchaseOrder(this.getPurchaseOrderIdentifier()));
        }
        return this.purchaseOrderDocument;
    }

    @Override
    public void setPurchaseOrderDocument(PurchaseOrderDocument purchaseOrderDocument) {
        if (ObjectUtils.isNull((Object)purchaseOrderDocument)) {
            this.purchaseOrderDocument = null;
        } else {
            if (ObjectUtils.isNotNull((Object)purchaseOrderDocument.getPurapDocumentIdentifier())) {
                this.setPurchaseOrderIdentifier(purchaseOrderDocument.getPurapDocumentIdentifier());
            }
            this.purchaseOrderDocument = purchaseOrderDocument;
        }
    }

    public boolean isClosePurchaseOrderIndicator() {
        return this.closePurchaseOrderIndicator;
    }

    public void setClosePurchaseOrderIndicator(boolean closePurchaseOrderIndicator) {
        this.closePurchaseOrderIndicator = closePurchaseOrderIndicator;
    }

    public boolean isReopenPurchaseOrderIndicator() {
        return this.reopenPurchaseOrderIndicator;
    }

    public void setReopenPurchaseOrderIndicator(boolean reopenPurchaseOrderIndicator) {
        this.reopenPurchaseOrderIndicator = reopenPurchaseOrderIndicator;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    @Deprecated
    public void setProcessingCampus(CampusParameter processingCampus) {
        this.processingCampus = processingCampus;
    }

    public Person getLastActionPerformedByUser() {
        return ((PersonService)SpringContext.getBean(PersonService.class)).getPerson(this.getLastActionPerformedByPersonId());
    }

    public String getLastActionPerformedByPersonName() {
        Person user = this.getLastActionPerformedByUser();
        if (ObjectUtils.isNull((Object)user)) {
            return "";
        }
        return user.getName();
    }

    public String getDebitCreditCodeForGLEntries() {
        return this.debitCreditCodeForGLEntries;
    }

    public void setDebitCreditCodeForGLEntries(String debitCreditCodeForGLEntries) {
        this.debitCreditCodeForGLEntries = debitCreditCodeForGLEntries;
    }

    @Override
    public boolean isUnmatchedOverride() {
        return this.unmatchedOverride;
    }

    @Override
    public void setUnmatchedOverride(boolean unmatchedOverride) {
        this.unmatchedOverride = unmatchedOverride;
    }

    public boolean getExtractedIndicatorForSearching() {
        return this.extractedTimestamp != null;
    }

    public boolean isHoldIndicatorForSearching() {
        return this.holdIndicator;
    }

    @Override
    public abstract KualiDecimal getGrandTotal();

    @Override
    public abstract KualiDecimal getInitialAmount();

    @Override
    public boolean isContinuationAccountIndicator() {
        return this.continuationAccountIndicator;
    }

    @Override
    public void setContinuationAccountIndicator(boolean continuationAccountIndicator) {
        this.continuationAccountIndicator = continuationAccountIndicator;
    }

    @Override
    public boolean isExtracted() {
        return ObjectUtils.isNotNull((Object)this.getExtractedTimestamp());
    }

    @Override
    public abstract AccountsPayableDocumentSpecificService getDocumentSpecificService();

    @Override
    public AccountsPayableItem getAPItemFromPOItem(PurchaseOrderItem poi) {
        for (AccountsPayableItem preqItem : this.getItems()) {
            preqItem.refreshReferenceObject("itemType");
            if (preqItem.getItemType().isLineItemIndicator()) {
                if (preqItem.getItemLineNumber().compareTo(poi.getItemLineNumber()) != 0) continue;
                return preqItem;
            }
            return (AccountsPayableItem)((PurapService)SpringContext.getBean(PurapService.class)).getBelowTheLineByType(this, poi.getItemType());
        }
        return null;
    }

    @Override
    public Class getItemClass() {
        return null;
    }

    @Override
    public PurchasingAccountsPayableDocument getPurApSourceDocumentIfPossible() {
        return null;
    }

    @Override
    public String getPurApSourceDocumentLabelIfPossible() {
        return null;
    }

    public void updateExtendedPriceOnItems() {
        for (AccountsPayableItem item : this.getItems()) {
            KualiDecimal itemExtendedPrice;
            item.refreshReferenceObject("itemType");
            KualiDecimal kualiDecimal = itemExtendedPrice = item.getExtendedPrice() == null ? KualiDecimal.ZERO : item.getExtendedPrice();
            if (!ObjectUtils.isNotNull((Object)((Object)item.getItemType())) || !item.getItemType().isQuantityBasedGeneralLedgerIndicator() || item.getExtendedPrice() != null) continue;
            KualiDecimal newExtendedPrice = item.calculateExtendedPrice();
            item.setExtendedPrice(newExtendedPrice);
        }
    }

    @Override
    public KualiDecimal getTotalRemitTax() {
        if (!this.isUseTaxIndicator()) {
            return KualiDecimal.ZERO.equals((Object)this.getTotalTaxAmount()) ? null : this.getTotalTaxAmount();
        }
        return null;
    }

    public boolean customizeOffsetGeneralLedgerPendingEntry(GeneralLedgerPendingEntrySourceDetail accountingLine, GeneralLedgerPendingEntry explicitEntry, GeneralLedgerPendingEntry offsetEntry) {
        boolean value = super.customizeOffsetGeneralLedgerPendingEntry(accountingLine, explicitEntry, offsetEntry);
        if (offsetEntry != null && this.offsetUseTax != null) {
            offsetEntry.setChartOfAccountsCode(this.offsetUseTax.getChartOfAccountsCode());
            offsetEntry.refreshReferenceObject("chart");
            offsetEntry.setAccountNumber(this.offsetUseTax.getAccountNumber());
            offsetEntry.refreshReferenceObject("account");
            offsetEntry.setFinancialObjectCode(this.offsetUseTax.getFinancialObjectCode());
            offsetEntry.refreshReferenceObject("financialObject");
        } else {
            value = false;
        }
        return value;
    }

    @Override
    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper, PurApItemUseTax offsetUseTax) {
        this.offsetUseTax = offsetUseTax;
        boolean value = this.generateGeneralLedgerPendingEntries(glpeSourceDetail, sequenceHelper);
        this.offsetUseTax = null;
        return value;
    }

    public String getHoldIndicatorForResult() {
        return this.isHoldIndicator() ? "Yes" : "No";
    }

    public String getProcessingCampusCodeForSearch() {
        return this.getProcessingCampusCode();
    }

    public String getDocumentChartOfAccountsCodeForSearching() {
        return this.getPurchaseOrderDocument().getChartOfAccountsCode();
    }

    public String getDocumentOrganizationCodeForSearching() {
        return this.getPurchaseOrderDocument().getOrganizationCode();
    }

    public String getDocumentType() {
        return ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getDocumentTypeNameByClass(this.getClass());
    }

    @Override
    public boolean shouldGiveErrorForEmptyAccountsProration() {
        return true;
    }
}

