/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service.impl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.B2BInformation;
import org.kuali.kfs.module.purap.businessobject.B2BShoppingCartItem;
import org.kuali.kfs.module.purap.businessobject.BillingAddress;
import org.kuali.kfs.module.purap.businessobject.DefaultPrincipalAddress;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.dataaccess.B2BDao;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.B2BShoppingService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchasingService;
import org.kuali.kfs.module.purap.exception.B2BShoppingException;
import org.kuali.kfs.module.purap.util.PurApDateFormatUtils;
import org.kuali.kfs.module.purap.util.cxml.B2BParserHelper;
import org.kuali.kfs.module.purap.util.cxml.B2BShoppingCart;
import org.kuali.kfs.module.purap.util.cxml.PunchOutSetupResponse;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.vnd.businessobject.CommodityCode;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorCommodityCode;
import org.kuali.kfs.vnd.businessobject.VendorContract;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.kfs.vnd.service.PhoneNumberService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class B2BShoppingServiceImpl
implements B2BShoppingService {
    private static Logger LOG = Logger.getLogger(B2BShoppingServiceImpl.class);
    private B2BDao b2bDao;
    private BusinessObjectService businessObjectService;
    private ConfigurationService kualiConfigurationService;
    private DocumentService documentService;
    private ParameterService parameterService;
    private PersistenceService persistenceService;
    private PhoneNumberService phoneNumberService;
    private PurchasingService purchasingService;
    private PurapService purapService;
    private VendorService vendorService;
    private String b2bEnvironment;
    private String b2bPunchoutURL;
    private String b2bPunchbackURL;
    private String b2bUserAgent;
    private String b2bShoppingIdentity;
    private String b2bShoppingPassword;

    protected B2BInformation getB2bShoppingConfigurationInformation() {
        B2BInformation b2b = new B2BInformation();
        b2b.setPunchoutURL(this.b2bPunchoutURL);
        b2b.setPunchbackURL(this.b2bPunchbackURL);
        b2b.setEnvironment(this.b2bEnvironment);
        b2b.setUserAgent(this.b2bUserAgent);
        b2b.setIdentity(this.b2bShoppingIdentity);
        b2b.setPassword(this.b2bShoppingPassword);
        return b2b;
    }

    @Override
    public String getPunchOutUrl(Person user) {
        B2BInformation b2b = this.getB2bShoppingConfigurationInformation();
        String response = this.b2bDao.sendPunchOutRequest(this.getPunchOutSetupRequestMessage(user, b2b), b2b.getPunchoutURL());
        PunchOutSetupResponse posr = B2BParserHelper.getInstance().parsePunchOutSetupResponse(response);
        return posr.getPunchOutUrl();
    }

    @Override
    public String getPunchOutSetupRequestMessage(Person user, B2BInformation b2bInformation) {
        StringBuffer cxml = new StringBuffer();
        Date d = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentDate();
        SimpleDateFormat date = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.CXML_SIMPLE_DATE_FORMAT);
        SimpleDateFormat time = PurApDateFormatUtils.getSimpleDateFormat(PurapConstants.NamedDateFormats.CXML_SIMPLE_TIME_FORMAT);
        cxml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        cxml.append("<!DOCTYPE cXML SYSTEM \"cXML.dtd\">\n");
        cxml.append("<cXML payloadID=\"irrelevant\" xml:lang=\"en-US\" timestamp=\"").append(date.format(d)).append("T").append(time.format(d)).append("-05:00").append("\">\n");
        cxml.append("  <Header>\n");
        cxml.append("    <From>\n");
        cxml.append("      <Credential domain=\"NetworkId\">\n");
        cxml.append("        <Identity>").append(b2bInformation.getIdentity()).append("</Identity>\n");
        cxml.append("      </Credential>\n");
        cxml.append("    </From>\n");
        cxml.append("    <To>\n");
        cxml.append("      <Credential domain=\"DUNS\">\n");
        cxml.append("        <Identity>").append(b2bInformation.getIdentity()).append("</Identity>\n");
        cxml.append("      </Credential>\n");
        cxml.append("      <Credential domain=\"internalsupplierid\">\n");
        cxml.append("        <Identity>1016</Identity>\n");
        cxml.append("      </Credential>\n");
        cxml.append("    </To>\n");
        cxml.append("    <Sender>\n");
        cxml.append("      <Credential domain=\"TOPSNetworkUserId\">\n");
        cxml.append("        <Identity>").append(user.getPrincipalName().toUpperCase()).append("</Identity>\n");
        cxml.append("        <SharedSecret>").append(b2bInformation.getPassword()).append("</SharedSecret>\n");
        cxml.append("      </Credential>\n");
        cxml.append("      <UserAgent>").append(b2bInformation.getUserAgent()).append("</UserAgent>\n");
        cxml.append("    </Sender>\n");
        cxml.append("  </Header>\n");
        cxml.append("  <Request deploymentMode=\"").append(b2bInformation.getEnvironment()).append("\">\n");
        cxml.append("    <PunchOutSetupRequest operation=\"create\">\n");
        cxml.append("      <BuyerCookie>").append(user.getPrincipalName().toUpperCase()).append("</BuyerCookie>\n");
        cxml.append("      <Extrinsic name=\"UniqueName\">").append(user.getPrincipalName().toUpperCase()).append("</Extrinsic>\n");
        cxml.append("      <Extrinsic name=\"Department\">IU").append(user.getCampusCode()).append(user.getPrimaryDepartmentCode()).append("</Extrinsic>\n");
        cxml.append("      <Extrinsic name=\"Campus\">").append(user.getCampusCode()).append("</Extrinsic>\n");
        cxml.append("      <BrowserFormPost>\n");
        cxml.append("        <URL>").append(b2bInformation.getPunchbackURL()).append("</URL>\n");
        cxml.append("      </BrowserFormPost>\n");
        cxml.append("      <Contact role=\"endUser\">\n");
        cxml.append("        <Name xml:lang=\"en\">").append(user.getName()).append("</Name>\n");
        cxml.append("      </Contact>\n");
        cxml.append("      <SupplierSetup>\n");
        cxml.append("        <URL>").append(b2bInformation.getPunchoutURL()).append("</URL>\n");
        cxml.append("      </SupplierSetup>\n");
        cxml.append("    </PunchOutSetupRequest>\n");
        cxml.append("  </Request>\n");
        cxml.append("</cXML>\n");
        return cxml.toString();
    }

    @Override
    public List createRequisitionsFromCxml(B2BShoppingCart message, Person user) throws WorkflowException {
        LOG.debug((Object)"createRequisitionsFromCxml() started");
        ArrayList<RequisitionDocument> requisitions = new ArrayList<RequisitionDocument>();
        List items = message.getItems();
        List vendors = this.getAllVendors(items);
        for (VendorDetail vendor : vendors) {
            ChartOrgHolder purapChartOrg;
            RequisitionDocument req = (RequisitionDocument)this.documentService.getNewDocument("REQS");
            req.setupAccountDistributionMethod();
            VendorContract contract = this.vendorService.getVendorB2BContract(vendor, user.getCampusCode());
            if (ObjectUtils.isNotNull((Object)contract)) {
                req.setVendorContractGeneratedIdentifier(contract.getVendorContractGeneratedIdentifier());
                if (ObjectUtils.isNotNull((Object)contract.getPurchaseOrderCostSourceCode())) {
                    req.setPurchaseOrderCostSourceCode(contract.getPurchaseOrderCostSourceCode());
                } else {
                    req.setPurchaseOrderCostSourceCode("EST");
                }
            } else {
                LOG.error((Object)("createRequisitionsFromCxml() Contract is missing for vendor " + vendor.getVendorName() + " (" + vendor.getVendorNumber() + ")"));
                throw new B2BShoppingException("The vendor whose shopping cart you are attempting to return does not have an active contract for your organization.");
            }
            List itemsForVendor = this.getAllVendorItems(items, vendor);
            req.setDeliveryCampusCode(user.getCampusCode());
            req.setDeliveryToName(user.getName());
            req.setDeliveryToEmailAddress(user.getEmailAddressUnmasked());
            req.setDeliveryToPhoneNumber(((PhoneNumberService)SpringContext.getBean(PhoneNumberService.class)).formatNumberIfPossible(user.getPhoneNumber()));
            DefaultPrincipalAddress defaultPrincipalAddress = new DefaultPrincipalAddress(user.getPrincipalId());
            Map addressKeys = ((PersistenceService)SpringContext.getBean(PersistenceService.class)).getPrimaryKeyFieldValues((Object)defaultPrincipalAddress);
            defaultPrincipalAddress = (DefaultPrincipalAddress)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(DefaultPrincipalAddress.class, addressKeys);
            if (ObjectUtils.isNotNull((Object)((Object)defaultPrincipalAddress)) && ObjectUtils.isNotNull((Object)defaultPrincipalAddress.getBuilding())) {
                if (defaultPrincipalAddress.getBuilding().isActive()) {
                    req.setDeliveryCampusCode(defaultPrincipalAddress.getCampusCode());
                    req.templateBuildingToDeliveryAddress(defaultPrincipalAddress.getBuilding());
                    req.setDeliveryBuildingRoomNumber(defaultPrincipalAddress.getBuildingRoomNumber());
                } else {
                    ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).delete((PersistableBusinessObject)defaultPrincipalAddress);
                }
            }
            if (ObjectUtils.isNotNull((Object)(purapChartOrg = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPrimaryOrganization(user, "KFS-PURAP")))) {
                req.setChartOfAccountsCode(purapChartOrg.getChartOfAccountsCode());
                req.setOrganizationCode(purapChartOrg.getOrganizationCode());
            }
            req.setRequestorPersonName(user.getName());
            req.setRequestorPersonEmailAddress(user.getEmailAddress());
            req.setRequestorPersonPhoneNumber(this.phoneNumberService.formatNumberIfPossible(user.getPhoneNumber()));
            req.setUseTaxIndicator(this.purchasingService.getDefaultUseTaxIndicatorValue(req));
            req.setVendorHeaderGeneratedIdentifier(vendor.getVendorHeaderGeneratedIdentifier());
            req.setVendorDetailAssignedIdentifier(vendor.getVendorDetailAssignedIdentifier());
            req.setVendorName(vendor.getVendorName());
            req.setVendorRestrictedIndicator(vendor.getVendorRestrictedIndicator());
            req.setItems(itemsForVendor);
            req.setDocumentFundingSourceCode(this.parameterService.getParameterValueAsString(RequisitionDocument.class, "DEFAULT_FUNDING_SOURCE"));
            req.setRequisitionSourceCode("B2B");
            req.updateAndSaveAppDocStatus("In Process");
            req.setPurchaseOrderTransmissionMethodCode("ELEC");
            req.setOrganizationAutomaticPurchaseOrderLimit(this.purapService.getApoLimit(req.getVendorContractGeneratedIdentifier(), req.getChartOfAccountsCode(), req.getOrganizationCode()));
            req.setExternalOrganizationB2bSupplierIdentifier(this.getSupplierIdFromFirstItem(itemsForVendor));
            VendorAddress vendorAddress = this.vendorService.getVendorDefaultAddress(vendor.getVendorHeaderGeneratedIdentifier(), vendor.getVendorDetailAssignedIdentifier(), "PO", user.getCampusCode());
            if (ObjectUtils.isNotNull((Object)vendorAddress)) {
                req.templateVendorAddress(vendorAddress);
            }
            BillingAddress billingAddress = new BillingAddress();
            billingAddress.setBillingCampusCode(req.getDeliveryCampusCode());
            Map keys = this.persistenceService.getPrimaryKeyFieldValues((Object)billingAddress);
            billingAddress = (BillingAddress)this.businessObjectService.findByPrimaryKey(BillingAddress.class, keys);
            req.templateBillingAddress(billingAddress);
            req.loadReceivingAddress();
            req.fixItemReferences();
            this.purapService.saveDocumentNoValidation((Document)req);
            requisitions.add(req);
        }
        return requisitions;
    }

    private boolean isDunsNumberEnabled() {
        return this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_B2B_BY_VENDOR_DUNS_NUMBER_IND");
    }

    protected List getAllVendors(List items) {
        LOG.debug((Object)"getAllVendors() started");
        HashSet<String> vendorIdentifiers = new HashSet<String>();
        for (B2BShoppingCartItem item : items) {
            vendorIdentifiers.add(this.getVendorNumber(item));
        }
        ArrayList<VendorDetail> vendors = new ArrayList<VendorDetail>();
        for (String vendorIdentifier : vendorIdentifiers) {
            VendorDetail vd = null;
            vd = this.isDunsNumberEnabled() ? this.vendorService.getVendorByDunsNumber(vendorIdentifier) : this.vendorService.getVendorDetail(vendorIdentifier);
            if (ObjectUtils.isNotNull((Object)vd)) {
                vendors.add(vd);
                continue;
            }
            LOG.error((Object)("getAllVendors() Invalid vendor number or DUNS from shopping cart: " + vendorIdentifier));
            throw new B2BShoppingException("Invalid vendor number or DUNS from shopping cart: " + vendorIdentifier);
        }
        return vendors;
    }

    protected List getAllVendorItems(List items, VendorDetail vendorDetail) {
        LOG.debug((Object)"getAllVendorItems() started");
        String vendorNumberOrDUNS = this.isDunsNumberEnabled() ? vendorDetail.getVendorDunsNumber() : vendorDetail.getVendorNumber();
        ArrayList<B2BShoppingCartItem> scItems = new ArrayList<B2BShoppingCartItem>();
        for (B2BShoppingCartItem item : items) {
            if (!StringUtils.equals((String)vendorNumberOrDUNS, (String)this.getVendorNumber(item))) continue;
            scItems.add(item);
        }
        List vcc = vendorDetail.getVendorCommodities();
        String defaultCommodityCode = null;
        for (VendorCommodityCode commodity : vcc) {
            if (!commodity.isCommodityDefaultIndicator()) continue;
            defaultCommodityCode = commodity.getPurchasingCommodityCode();
        }
        int itemLine = 1;
        ArrayList<RequisitionItem> vendorItems = new ArrayList<RequisitionItem>();
        for (B2BShoppingCartItem item : scItems) {
            RequisitionItem reqItem = this.createRequisitionItem(item, new Integer(itemLine), defaultCommodityCode);
            ++itemLine;
            vendorItems.add(reqItem);
        }
        return vendorItems;
    }

    protected RequisitionItem createRequisitionItem(B2BShoppingCartItem item, Integer itemLine, String defaultCommodityCode) {
        RequisitionItem reqItem = new RequisitionItem();
        reqItem.setItemTypeCode("ITEM");
        reqItem.setItemLineNumber(itemLine);
        reqItem.setItemUnitPrice(new BigDecimal(item.getUnitPrice()));
        reqItem.setItemQuantity(new KualiDecimal(item.getQuantity()));
        reqItem.setItemCatalogNumber(item.getSupplierPartId());
        reqItem.setItemAuxiliaryPartIdentifier(item.getSupplierPartAuxiliaryId());
        reqItem.setItemDescription(item.getDescription());
        reqItem.setItemUnitOfMeasureCode(item.getUnitOfMeasure());
        reqItem.setExternalOrganizationB2bProductTypeName(item.getExtrinsic("Product Source"));
        reqItem.setExternalOrganizationB2bProductReferenceNumber(item.getExtrinsic("SystemProductID"));
        reqItem.setItemRestrictedIndicator(false);
        boolean commCodeParam = this.parameterService.getParameterValueAsBoolean(RequisitionDocument.class, "ENABLE_DEFAULT_VENDOR_COMMODITY_CODE_IND");
        if (commCodeParam) {
            String commodityCode;
            String classification = this.parameterService.getParameterValueAsString(RequisitionDocument.class, "B2B_CLASSIFICATION_FOR_COMMODITY_CODE");
            if (StringUtils.isBlank((String)classification)) {
                classification = "UNSPSC";
            }
            if (this.verifyCommodityCode(commodityCode = item.getClassification(classification))) {
                reqItem.setPurchasingCommodityCode(commodityCode);
            } else {
                reqItem.setPurchasingCommodityCode(defaultCommodityCode);
            }
        }
        reqItem.setHoldSupplierId(item.getSupplier("SystemSupplierID"));
        return reqItem;
    }

    private boolean verifyCommodityCode(String commodityCode) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("purchasingCommodityCode", commodityCode);
        CommodityCode commodity = (CommodityCode)this.businessObjectService.findByPrimaryKey(CommodityCode.class, fieldValues);
        if (ObjectUtils.isNotNull((Object)commodity)) {
            return true;
        }
        LOG.warn((Object)("Could not retrieve CommodityCode: " + commodityCode + "! Instead using default commodity code for vendor"));
        return false;
    }

    protected String getSupplierIdFromFirstItem(List reqItems) {
        if (ObjectUtils.isNotNull((Object)reqItems) && !reqItems.isEmpty()) {
            return ((RequisitionItem)reqItems.get(0)).getHoldSupplierId();
        }
        return "";
    }

    protected String getVendorNumber(B2BShoppingCartItem item) {
        String vendorNumber = null;
        vendorNumber = this.isDunsNumberEnabled() ? item.getSupplier("DUNS") : item.getExtrinsic("ExternalSupplierId");
        if (StringUtils.isBlank((String)vendorNumber)) {
            throw new B2BShoppingException("The vendor whose shopping cart you are attempting to return does not have an active contract for your organization.");
        }
        return vendorNumber;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setB2bDao(B2BDao b2bDao) {
        this.b2bDao = b2bDao;
    }

    public void setPhoneNumberService(PhoneNumberService phoneNumberService) {
        this.phoneNumberService = phoneNumberService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }

    public void setPurchasingService(PurchasingService purchasingService) {
        this.purchasingService = purchasingService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setB2bEnvironment(String environment) {
        this.b2bEnvironment = environment;
    }

    public void setB2bPunchoutURL(String punchoutURL) {
        this.b2bPunchoutURL = punchoutURL;
    }

    public void setB2bPunchbackURL(String punchbackURL) {
        this.b2bPunchbackURL = punchbackURL;
    }

    public void setB2bUserAgent(String userAgent) {
        this.b2bUserAgent = userAgent;
    }

    public void setB2bShoppingIdentity(String b2bShoppingIdentity) {
        this.b2bShoppingIdentity = b2bShoppingIdentity;
    }

    public void setB2bShoppingPassword(String password) {
        this.b2bShoppingPassword = password;
    }
}

