/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.event;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.purap.CapitalAssetLocation;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.document.validation.event.AttributedPurchasingCapitalAssetLocationEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;

public abstract class AttributedPurchasingCapitalAssetLocationEventBase
extends AttributedDocumentEventBase
implements AttributedPurchasingCapitalAssetLocationEvent {
    private static final Logger LOG = Logger.getLogger(AttributedPurchasingCapitalAssetLocationEventBase.class);
    private final CapitalAssetLocation capitalAssetLocation;

    public AttributedPurchasingCapitalAssetLocationEventBase(String description, String errorPathPrefix, Document document, CapitalAssetLocation capitalAssetLocation) {
        super(description, errorPathPrefix, document);
        this.capitalAssetLocation = capitalAssetLocation;
        this.logEvent();
    }

    @Override
    public CapitalAssetLocation getCapitalAssetLocation() {
        return this.capitalAssetLocation;
    }

    public void validate() {
        super.validate();
        if (this.getCapitalAssetLocation() == null) {
            throw new IllegalArgumentException("invalid (null) location");
        }
    }

    private void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.capitalAssetLocation == null) {
            logMessage.append("null capital asset location");
        } else {
            logMessage.append(" capital asset location# ");
            logMessage.append(this.capitalAssetLocation.getCapitalAssetLocationIdentifier());
        }
        LOG.debug((Object)logMessage);
    }
}

