/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingAccountsPayableAccountPercentValidation
extends GenericValidation {
    private PurApItem itemForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        boolean isAnyAccountingLineZero = false;
        BigDecimal totalPercent = BigDecimal.ZERO;
        BigDecimal desiredPercent = new BigDecimal("100");
        for (PurApAccountingLine account : this.itemForValidation.getSourceAccountingLines()) {
            if (account.getAccountLinePercent() != null && account.getAccountLinePercent().compareTo(BigDecimal.ZERO) == 0) {
                isAnyAccountingLineZero = true;
            }
            if (account.getAccountLinePercent() != null) {
                totalPercent = totalPercent.add(account.getAccountLinePercent());
                continue;
            }
            totalPercent = totalPercent.add(BigDecimal.ZERO);
        }
        if (desiredPercent.compareTo(totalPercent) != 0) {
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.total", new String[]{this.itemForValidation.getItemIdentifierString()});
            valid = false;
        }
        if (isAnyAccountingLineZero && this.itemForValidation.getSourceAccountingLines().size() > 1) {
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.zero", new String[]{this.itemForValidation.getItemIdentifierString()});
            valid = false;
        }
        return valid;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }
}

