/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.kns.rules.DocumentRuleBase;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.document.validation.PurchasingAccountsPayableItemPreCalculationRule;

public class PurchasingAccountsPayablesItemPreCalculateDocumentRule
extends DocumentRuleBase
implements PurchasingAccountsPayableItemPreCalculationRule {
    @Override
    public boolean checkPercentOrTotalAmountsEqual(PurApItem item) {
        boolean valid = true;
        if (valid &= this.validatePercent(item)) {
            valid &= this.validateTotalAmount(item);
        }
        return valid;
    }

    public boolean validatePercent(PurApItem item) {
        boolean valid = true;
        BigDecimal totalPercent = BigDecimal.ZERO;
        BigDecimal desiredPercent = new BigDecimal("100");
        for (PurApAccountingLine account : item.getSourceAccountingLines()) {
            if (account.getAccountLinePercent() != null) {
                totalPercent = totalPercent.add(account.getAccountLinePercent());
                continue;
            }
            totalPercent = totalPercent.add(BigDecimal.ZERO);
        }
        if (desiredPercent.compareTo(totalPercent) != 0) {
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.total", new String[]{item.getItemIdentifierString()});
            valid = false;
        }
        return valid;
    }

    public boolean validateTotalAmount(PurApItem item) {
        boolean valid = true;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal desiredAmount = item.getTotalAmount() == null ? new BigDecimal(0) : item.getTotalAmount().bigDecimalValue();
        for (PurApAccountingLine account : item.getSourceAccountingLines()) {
            if (account.getAmount() != null) {
                totalAmount = totalAmount.add(account.getAmount().bigDecimalValue());
                continue;
            }
            totalAmount = totalAmount.add(BigDecimal.ZERO);
        }
        if (desiredAmount.compareTo(totalAmount) != 0) {
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.total.amount", new String[]{item.getItemIdentifierString(), desiredAmount.toString()});
            valid = false;
        }
        return valid;
    }
}

