/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingItemDescriptionValidation
extends GenericValidation {
    private PurApItem itemForValidation;
    private DataDictionaryService dataDictionaryService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        if (StringUtils.isEmpty((String)this.itemForValidation.getItemDescription())) {
            valid = false;
            String attributeLabel = this.dataDictionaryService.getDataDictionary().getBusinessObjectEntry(this.itemForValidation.getClass().getName()).getAttributeDefinition("itemDescription").getLabel();
            String errorPrefix = "document.item[" + (this.itemForValidation.getItemLineNumber() - 1) + "]." + "itemDescription";
            GlobalVariables.getMessageMap().putError(errorPrefix, "error.required", new String[]{attributeLabel + " in " + this.itemForValidation.getItemIdentifierString()});
        }
        return valid;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

