/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.util.Date;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coa.businessobject.SubObjectCode;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.SubObjectCodeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.batch.ScrubberStep;
import org.kuali.kfs.krad.datadictionary.DataDictionary;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.service.impl.PurapAccountingLineRuleHelperServiceImpl;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class PaymentRequestAccountingLineRuleHelperServiceImpl
extends PurapAccountingLineRuleHelperServiceImpl {
    @Override
    public boolean hasRequiredOverrides(AccountingLine line, String overrideCode) {
        boolean hasOverrides = true;
        Account account = ((AccountService)SpringContext.getBean(AccountService.class)).getByPrimaryId(line.getChartOfAccountsCode(), line.getAccountNumber());
        String docStatus = this.getDocument().getApplicationDocumentStatus();
        if (ObjectUtils.isNotNull((Object)account)) {
            if ("Awaiting Sub-Account Manager Approval".equals(docStatus) || "Awaiting Fiscal Officer Approval".equals(docStatus) || "Awaiting Chart Approval".equals(docStatus) || "Awaiting Tax Approval".equals(docStatus) || "Department-Approved".equals(docStatus) || "Auto-Approved".equals(docStatus)) {
                String expirationExtensionDays = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(ScrubberStep.class, "CG_ACCOUNT_EXPIRATION_EXTENSION_DAYS");
                int expirationExtensionDaysInt = 90;
                if (ObjectUtils.isNotNull((Object)expirationExtensionDays) && expirationExtensionDays.trim().length() > 0) {
                    expirationExtensionDaysInt = new Integer(expirationExtensionDays);
                }
                if (account.isExpired() && account.isForContractsAndGrants() && ((DateTimeService)SpringContext.getBean(DateTimeService.class)).dateDiff((Date)account.getAccountExpirationDate(), ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentDate(), true) > expirationExtensionDaysInt) {
                    GlobalVariables.getMessageMap().putError("accountNumber", "errors.item.accounting.expired.replace", new String[]{account.getAccountNumber()});
                    hasOverrides = false;
                }
            }
        } else {
            hasOverrides = false;
        }
        return hasOverrides;
    }

    public boolean isValidObjectCode(ObjectCode objectCode, DataDictionary dataDictionary, String errorPropertyName) {
        String label = this.getObjectCodeLabel();
        if (ObjectUtils.isNull((Object)objectCode)) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.existence", new String[]{label});
            return false;
        }
        Integer universityFiscalYear = ((PaymentRequestDocument)this.getDocument()).getPostingYearPriorOrCurrent();
        ObjectCode objectCodeForValidation = ((ObjectCodeService)SpringContext.getBean(ObjectCodeService.class)).getByPrimaryId(universityFiscalYear, objectCode.getChartOfAccountsCode(), objectCode.getFinancialObjectCode());
        if (!objectCodeForValidation.isFinancialObjectActiveCode()) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.inactive", new String[]{label});
            return false;
        }
        return true;
    }

    public boolean isValidSubObjectCode(SubObjectCode subObjectCode, DataDictionary dataDictionary, String errorPropertyName) {
        String label = this.getSubObjectCodeLabel();
        if (ObjectUtils.isNull((Object)subObjectCode)) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.existence", new String[]{label});
            return false;
        }
        Integer universityFiscalYear = ((PaymentRequestDocument)this.getDocument()).getPostingYearPriorOrCurrent();
        SubObjectCode subObjectCodeForValidation = ((SubObjectCodeService)SpringContext.getBean(SubObjectCodeService.class)).getByPrimaryId(universityFiscalYear, subObjectCode.getChartOfAccountsCode(), subObjectCode.getAccountNumber(), subObjectCode.getFinancialObjectCode(), subObjectCode.getFinancialSubObjectCode());
        if (!subObjectCodeForValidation.isActive() && ((PaymentRequestDocument)this.getDocument()).getApplicationDocumentStatus().equals("Awaiting Fiscal Officer Approval")) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.inactive", new String[]{label});
            return false;
        }
        return true;
    }

    public boolean isValidSubAccount(SubAccount subAccount, DataDictionary dataDictionary, String errorPropertyName, String errorPropertyIdentifyingName) {
        String label = this.getSubAccountLabel();
        if (ObjectUtils.isNull((Object)subAccount)) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.existence", new String[]{label});
            return false;
        }
        if (!subAccount.isActive() && ((PaymentRequestDocument)this.getDocument()).getApplicationDocumentStatus().equals("Awaiting Fiscal Officer Approval")) {
            GlobalVariables.getMessageMap().putError(errorPropertyName, "error.inactive", new String[]{label});
            return false;
        }
        return true;
    }
}

