/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import org.apache.log4j.Logger;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class PurchaseOrderRemoveHoldDocument
extends PurchaseOrderDocument {
    protected static Logger LOG = Logger.getLogger(PurchaseOrderRemoveHoldDocument.class);

    @Override
    public void customPrepareForSave(KualiDocumentEvent event) {
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        try {
            if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isProcessed()) {
                ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForApprovedPODocuments(this);
                this.updateAndSaveAppDocStatus("Open");
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isDisapproved()) {
                ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForDisapprovedRemoveHoldPODocuments(this);
                try {
                    String nodeName = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).getCurrentRouteLevelName(this.getFinancialSystemDocumentHeader().getWorkflowDocument());
                    String reqStatus = PurapConstants.PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(nodeName);
                    this.updateAndSaveAppDocStatus(PurapConstants.PurchaseOrderStatuses.getPurchaseOrderAppDocDisapproveStatuses().get(reqStatus));
                }
                catch (WorkflowException e) {
                    this.logAndThrowRuntimeException("Error saving routing data while saving App Doc Status " + this.getDocumentNumber(), (Exception)((Object)e));
                }
            } else if (this.getFinancialSystemDocumentHeader().getWorkflowDocument().isCanceled()) {
                ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).setCurrentAndPendingIndicatorsForCancelledRemoveHoldPODocuments(this);
                this.updateAndSaveAppDocStatus("Cancelled");
            }
        }
        catch (WorkflowException e) {
            this.logAndThrowRuntimeException("Error saving routing data while saving document with id " + this.getDocumentNumber(), (Exception)((Object)e));
        }
    }

    @Override
    protected boolean shouldAdhocFyi() {
        return false;
    }
}

