/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.lang.constant.Constable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.kns.rules.TransactionalDocumentRuleBase;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.ContractManagerAssignmentDetail;
import org.kuali.kfs.module.purap.document.ContractManagerAssignmentDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.ContractManager;

public class ContractManagerAssignmentDocumentRule
extends TransactionalDocumentRuleBase {
    protected static Logger LOG = Logger.getLogger(ContractManagerAssignmentDocumentRule.class);

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        boolean isValid = true;
        ContractManagerAssignmentDocument acmDocument = (ContractManagerAssignmentDocument)document;
        return isValid &= this.processValidation(acmDocument);
    }

    protected boolean processCustomApproveDocumentBusinessRules(ApproveDocumentEvent approveEvent) {
        boolean isValid = true;
        ContractManagerAssignmentDocument acmDocument = (ContractManagerAssignmentDocument)approveEvent.getDocument();
        return isValid;
    }

    protected boolean processValidation(ContractManagerAssignmentDocument document) {
        return this.validateContractManagerCodes(document.getContractManagerAssignmentDetails());
    }

    public boolean validateContractManagerCodes(List contractManagerAssignmentDetails) {
        LOG.debug((Object)"validateContractManagerCodes(): entered method.");
        boolean isValid = true;
        int count = 0;
        int index = 0;
        String propertyNamePattern = "document.contractManagerAssignmentDetails[{0}].contractManagerCode";
        for (ContractManagerAssignmentDetail detail : contractManagerAssignmentDetails) {
            if (ObjectUtils.isNotNull((Object)detail.getContractManagerCode())) {
                HashMap<String, Constable> fieldValues = new HashMap<String, Constable>();
                fieldValues.put("contractManagerCode", detail.getContractManagerCode());
                fieldValues.put("active", Boolean.valueOf(true));
                String propertyWithInvalidValue = MessageFormat.format(propertyNamePattern, index);
                if (((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).countMatching(ContractManager.class, fieldValues) != 1) {
                    GlobalVariables.getMessageMap().putError(propertyWithInvalidValue, "error.invalidContractManagerCode", new String[]{detail.getContractManagerCode().toString()});
                    isValid = false;
                }
                if (detail.getContractManagerCode().equals(PurapConstants.APO_CONTRACT_MANAGER)) {
                    GlobalVariables.getMessageMap().putError(propertyWithInvalidValue, "error.apoContractManagerCodeChosen", new String[]{detail.getContractManagerCode().toString()});
                    isValid = false;
                }
                if (isValid) {
                    ++count;
                }
            }
            ++index;
        }
        if (count < 1) {
            GlobalVariables.getMessageMap().putError("document.unassignedRequisition*,document.contractManagerAssignmentDetail*", "error.noContractManagerAssigned", new String[0]);
            isValid = false;
        }
        LOG.debug((Object)"validateContractManagerCodes(): leaving method.");
        return isValid;
    }
}

