/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.document.PurchaseOrderAmendmentDocument;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderNewIndividualItemValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;

public class PurchaseOrderAmendmentNewIndividualItemValidation
extends PurchaseOrderNewIndividualItemValidation {
    private PurchaseOrderService purchaseOrderService;

    @Override
    public boolean validate(AttributedDocumentEvent event) {
        PurchaseOrderAmendmentDocument document;
        WorkflowDocument workflowDocument;
        KualiDecimal total;
        boolean valid = super.validate(event);
        PurchaseOrderItem item = (PurchaseOrderItem)this.getItemForValidation();
        String identifierString = item.getItemIdentifierString();
        if (item.getItemInvoicedTotalQuantity() != null && !item.getItemInvoicedTotalQuantity().isZero()) {
            if (item.getItemQuantity() == null) {
                valid = false;
                GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.amnd.null", new String[]{"Item Quantity", identifierString});
            } else if (item.getItemQuantity().compareTo((AbstractKualiDecimal)item.getItemInvoicedTotalQuantity()) < 0) {
                valid = false;
                GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.amnd.invalid", new String[]{"Item Quantity", identifierString});
            }
        }
        if (item.getItemInvoicedTotalAmount() != null && ((total = (KualiDecimal)item.getTotalAmount().abs()) == null || total.compareTo(item.getItemInvoicedTotalAmount().abs()) < 0)) {
            valid = false;
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.amnd.invalidAmt", new String[]{"Item Extended Price", identifierString});
        }
        if (!((workflowDocument = (document = (PurchaseOrderAmendmentDocument)event.getDocument()).getDocumentHeader().getWorkflowDocument()).isInitiated() || workflowDocument.isSaved() || !this.purchaseOrderService.isNewUnorderedItem(item) || item.getSourceAccountingLines() != null && item.getSourceAccountingLines().size() != 0)) {
            valid = false;
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.incomplete", new String[]{identifierString, identifierString});
        }
        return valid;
    }

    @Override
    protected boolean validateCommodityCodes(PurApItem item, boolean commodityCodeRequired) {
        if (!((PurchaseOrderItem)item).isItemActiveIndicator()) {
            return true;
        }
        return super.validateCommodityCodes(item, commodityCodeRequired);
    }

    @Override
    protected boolean validateThatCommodityCodeIsActive(PurApItem item) {
        if (item.getVersionNumber() != null) {
            return true;
        }
        if (!((PurchasingItemBase)item).getCommodityCode().isActive()) {
            GlobalVariables.getMessageMap().putError("purchasingCommodityCode", "error.commodity.code.inactive", new String[]{" in " + item.getItemIdentifierString()});
            return false;
        }
        return true;
    }

    public PurchaseOrderService getPurchaseOrderService() {
        return this.purchaseOrderService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }
}

