/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocumentBase;
import org.kuali.kfs.module.purap.document.validation.impl.PurapDocumentPreRulesBase;
import org.kuali.kfs.module.purap.document.web.struts.PurchasingFormBase;

public abstract class PurchasingDocumentPreRulesBase
extends PurapDocumentPreRulesBase {
    @Override
    public boolean doPrompts(Document document) {
        PurchasingAccountsPayableDocument purapDocument = (PurchasingAccountsPayableDocument)document;
        boolean preRulesValid = super.doPrompts(document);
        if (StringUtils.isBlank((String)this.event.getQuestionContext()) || StringUtils.equals((String)this.question, (String)"FixCapitalAssetWarnings")) {
            preRulesValid &= this.confirmFixCapitalAssetWarningConditions(purapDocument);
        }
        return preRulesValid;
    }

    protected boolean checkForTaxRecalculation(PurchasingAccountsPayableDocument purapDocument) {
        String initialZipCode = ((PurchasingFormBase)this.form).getInitialZipCode();
        if (StringUtils.isNotEmpty((String)initialZipCode) && !StringUtils.equals((String)initialZipCode, (String)((PurchasingDocumentBase)purapDocument).getDeliveryPostalCode())) {
            for (PurApItem purApItem : purapDocument.getItems()) {
                PurchasingItemBase item = (PurchasingItemBase)purApItem;
                if (item.getItemTaxAmount() == null) continue;
                StringBuffer questionTextBuffer = new StringBuffer("");
                questionTextBuffer.append("The postal code of the delivery address has changed.[br]Selecting \"Yes\" will submit the document without recalculating the taxes.[br]Selecting \"No\" will return you to the document so that the taxes can be recalculated.[br]The \"clear all\" button can be used to clear all tax amounts which will force taxes to be recalculated upon submission.");
                Boolean proceed = super.askOrAnalyzeYesNoQuestion("TaxRecalculationQuestion", questionTextBuffer.toString());
                if (proceed.booleanValue() && StringUtils.isBlank((String)this.event.getQuestionContext())) {
                    this.event.setQuestionContext("TaxRecalculationQuestion");
                }
                if (proceed.booleanValue()) continue;
                this.event.setActionForwardName("basic");
                return false;
            }
        }
        return true;
    }
}

