/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.ChartService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.ReceivingThreshold;
import org.kuali.kfs.module.purap.util.ThresholdField;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.VendorUtils;
import org.kuali.kfs.vnd.businessobject.VendorDetail;

public class ThresholdRule
extends MaintenanceDocumentRuleBase {
    protected static Logger LOG = Logger.getLogger(ThresholdRule.class);
    protected ChartService chartService = (ChartService)SpringContext.getBean(ChartService.class);
    protected AccountService accountService = (AccountService)SpringContext.getBean(AccountService.class);
    protected ReceivingThreshold newThreshold;
    protected ReceivingThreshold oldThreshold;

    protected boolean isValidDocument(ReceivingThreshold newThreshold, boolean checkDuplicate) {
        boolean valid = this.isValidThresholdCriteria(newThreshold);
        if (valid) {
            valid = this.isValidVendorNumber(newThreshold);
            if (valid && checkDuplicate) {
                valid = !this.isDuplicateEntry(newThreshold);
            }
        } else {
            this.constructFieldError(newThreshold);
        }
        return valid;
    }

    protected void constructFieldError(ReceivingThreshold threshold) {
        if (StringUtils.isNotBlank((String)threshold.getAccountTypeCode())) {
            this.putFieldError(ThresholdField.ACCOUNT_TYPE_CODE.getName(), "errors.threshold.criteria.invalid");
        }
        if (StringUtils.isNotBlank((String)threshold.getSubFundGroupCode())) {
            this.putFieldError(ThresholdField.SUBFUND_GROUP_CODE.getName(), "errors.threshold.criteria.invalid");
        }
        if (StringUtils.isNotBlank((String)threshold.getPurchasingCommodityCode())) {
            this.putFieldError(ThresholdField.COMMODITY_CODE.getName(), "errors.threshold.criteria.invalid");
        }
        if (StringUtils.isNotBlank((String)threshold.getFinancialObjectCode())) {
            this.putFieldError(ThresholdField.FINANCIAL_OBJECT_CODE.getName(), "errors.threshold.criteria.invalid");
        }
        if (StringUtils.isNotBlank((String)threshold.getOrganizationCode())) {
            this.putFieldError(ThresholdField.ORGANIZATION_CODE.getName(), "errors.threshold.criteria.invalid");
        }
        if (StringUtils.isNotBlank((String)threshold.getVendorNumber())) {
            this.putFieldError(ThresholdField.VENDOR_NUMBER.getName(), "errors.threshold.criteria.invalid");
        }
    }

    protected boolean isValidVendorNumber(ReceivingThreshold threshold) {
        if (StringUtils.isNotBlank((String)threshold.getVendorNumber())) {
            String vendorNumber = threshold.getVendorNumber();
            if (StringUtils.isNotBlank((String)vendorNumber)) {
                HashMap<String, Integer> keys = new HashMap<String, Integer>();
                Integer headerId = VendorUtils.getVendorHeaderId((String)vendorNumber);
                Integer detailId = VendorUtils.getVendorDetailId((String)vendorNumber);
                keys.put("vendorHeaderGeneratedIdentifier", headerId);
                keys.put("vendorDetailAssignedIdentifier", detailId);
                VendorDetail vendorDetail = (VendorDetail)this.getBoService().findByPrimaryKey(VendorDetail.class, keys);
                if (ObjectUtils.isNull((Object)vendorDetail)) {
                    this.putFieldError("vendorNumber", "errors.threshold.field.invalid", "Vendor Number " + vendorNumber);
                    return false;
                }
                VendorDetail vendor = threshold.getVendorDetail();
                vendor.setVendorHeaderGeneratedIdentifier(headerId);
                vendor.setVendorDetailAssignedIdentifier(detailId);
            }
            return true;
        }
        return true;
    }

    protected boolean isValidThresholdCriteria(ReceivingThreshold threshold) {
        if (StringUtils.isBlank((String)threshold.getAccountTypeCode()) && StringUtils.isBlank((String)threshold.getSubFundGroupCode()) && StringUtils.isBlank((String)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((String)threshold.getFinancialObjectCode()) && StringUtils.isBlank((String)threshold.getOrganizationCode()) && StringUtils.isBlank((String)threshold.getVendorNumber())) {
            return true;
        }
        if (StringUtils.isNotBlank((String)threshold.getAccountTypeCode()) && StringUtils.isBlank((String)threshold.getSubFundGroupCode()) && StringUtils.isBlank((String)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((String)threshold.getFinancialObjectCode()) && StringUtils.isBlank((String)threshold.getOrganizationCode()) && StringUtils.isBlank((String)threshold.getVendorNumber())) {
            return true;
        }
        if (StringUtils.isBlank((String)threshold.getAccountTypeCode()) && StringUtils.isNotBlank((String)threshold.getSubFundGroupCode()) && StringUtils.isBlank((String)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((String)threshold.getFinancialObjectCode()) && StringUtils.isBlank((String)threshold.getOrganizationCode()) && StringUtils.isBlank((String)threshold.getVendorNumber())) {
            return true;
        }
        if (StringUtils.isBlank((String)threshold.getAccountTypeCode()) && StringUtils.isBlank((String)threshold.getSubFundGroupCode()) && StringUtils.isNotBlank((String)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((String)threshold.getFinancialObjectCode()) && StringUtils.isBlank((String)threshold.getOrganizationCode()) && StringUtils.isBlank((String)threshold.getVendorNumber())) {
            return true;
        }
        if (StringUtils.isBlank((String)threshold.getAccountTypeCode()) && StringUtils.isBlank((String)threshold.getSubFundGroupCode()) && StringUtils.isBlank((String)threshold.getPurchasingCommodityCode()) && StringUtils.isNotBlank((String)threshold.getFinancialObjectCode()) && StringUtils.isBlank((String)threshold.getOrganizationCode()) && StringUtils.isBlank((String)threshold.getVendorNumber())) {
            return true;
        }
        if (StringUtils.isBlank((String)threshold.getAccountTypeCode()) && StringUtils.isBlank((String)threshold.getSubFundGroupCode()) && StringUtils.isBlank((String)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((String)threshold.getFinancialObjectCode()) && StringUtils.isNotBlank((String)threshold.getOrganizationCode()) && StringUtils.isBlank((String)threshold.getVendorNumber())) {
            return true;
        }
        return StringUtils.isBlank((String)threshold.getAccountTypeCode()) && StringUtils.isBlank((String)threshold.getSubFundGroupCode()) && StringUtils.isBlank((String)threshold.getPurchasingCommodityCode()) && StringUtils.isBlank((String)threshold.getFinancialObjectCode()) && StringUtils.isBlank((String)threshold.getOrganizationCode()) && StringUtils.isNotBlank((String)threshold.getVendorNumber());
    }

    protected boolean isDuplicateEntry(ReceivingThreshold newThreshold) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(ThresholdField.CHART_OF_ACCOUNTS_CODE.getName(), newThreshold.getChartOfAccountsCode());
        if (StringUtils.isNotBlank((String)newThreshold.getAccountTypeCode())) {
            fieldValues.put(ThresholdField.ACCOUNT_TYPE_CODE.getName(), newThreshold.getAccountTypeCode());
        } else if (StringUtils.isNotBlank((String)newThreshold.getSubFundGroupCode())) {
            fieldValues.put(ThresholdField.SUBFUND_GROUP_CODE.getName(), newThreshold.getSubFundGroupCode());
        } else if (StringUtils.isNotBlank((String)newThreshold.getPurchasingCommodityCode())) {
            fieldValues.put(ThresholdField.COMMODITY_CODE.getName(), newThreshold.getPurchasingCommodityCode());
        } else if (StringUtils.isNotBlank((String)newThreshold.getFinancialObjectCode())) {
            fieldValues.put(ThresholdField.FINANCIAL_OBJECT_CODE.getName(), newThreshold.getFinancialObjectCode());
        } else if (StringUtils.isNotBlank((String)newThreshold.getOrganizationCode())) {
            fieldValues.put(ThresholdField.ORGANIZATION_CODE.getName(), newThreshold.getOrganizationCode());
        } else if (StringUtils.isNotBlank((String)newThreshold.getVendorNumber())) {
            fieldValues.put(ThresholdField.VENDOR_HEADER_GENERATED_ID.getName(), newThreshold.getVendorHeaderGeneratedIdentifier());
            fieldValues.put(ThresholdField.VENDOR_DETAIL_ASSIGNED_ID.getName(), newThreshold.getVendorDetailAssignedIdentifier());
        }
        Collection result = this.getBoService().findMatching(ReceivingThreshold.class, fieldValues);
        if (result != null && result.size() > 0) {
            this.putGlobalError("error.document.purap.potentialDuplicate");
            return true;
        }
        return false;
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean valid = true;
        if (document.isNew() || document.isEdit() || document.isNewWithExisting()) {
            this.newThreshold = (ReceivingThreshold)document.getNewMaintainableObject().getBusinessObject();
            this.oldThreshold = document.getOldMaintainableObject() != null ? (ReceivingThreshold)document.getOldMaintainableObject().getBusinessObject() : null;
            boolean checkDuplicate = this.oldThreshold == null;
            checkDuplicate |= !StringUtils.equals((String)this.newThreshold.getChartOfAccountsCode(), (String)this.oldThreshold.getChartOfAccountsCode());
            checkDuplicate |= !StringUtils.equals((String)this.newThreshold.getAccountTypeCode(), (String)this.oldThreshold.getAccountTypeCode());
            checkDuplicate |= !StringUtils.equals((String)this.newThreshold.getSubFundGroupCode(), (String)this.oldThreshold.getSubFundGroupCode());
            checkDuplicate |= !StringUtils.equals((String)this.newThreshold.getPurchasingCommodityCode(), (String)this.oldThreshold.getPurchasingCommodityCode());
            checkDuplicate |= !StringUtils.equals((String)this.newThreshold.getFinancialObjectCode(), (String)this.oldThreshold.getFinancialObjectCode());
            checkDuplicate |= !StringUtils.equals((String)this.newThreshold.getOrganizationCode(), (String)this.oldThreshold.getOrganizationCode());
            valid &= this.isValidDocument(this.newThreshold, checkDuplicate |= !StringUtils.equals((String)this.newThreshold.getVendorNumber(), (String)this.oldThreshold.getVendorNumber()));
        }
        return valid && super.processCustomRouteDocumentBusinessRules(document);
    }
}

