/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.kns.web.struts.action.KualiAction;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorQuote;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.authorization.DocumentInitiationException;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.context.SpringContext;

public class PrintAction
extends KualiAction {
    private static Logger LOG = Logger.getLogger(PrintAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String poDocNumber = request.getParameter("poDocNumber");
        Integer vendorQuoteId = new Integer(request.getParameter("vendorQuoteId"));
        if (StringUtils.isEmpty((String)poDocNumber) || StringUtils.isEmpty((String)poDocNumber)) {
            throw new RuntimeException();
        }
        PurchaseOrderDocument po = (PurchaseOrderDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(poDocNumber);
        DocumentAuthorizer documentAuthorizer = ((DocumentHelperService)SpringContext.getBean(DocumentHelperService.class)).getDocumentAuthorizer((Document)po);
        if (!documentAuthorizer.canInitiate("PO", GlobalVariables.getUserSession().getPerson()) && !documentAuthorizer.canInitiate("ACM", GlobalVariables.getUserSession().getPerson())) {
            throw new DocumentInitiationException("error.authorization.document", new String[]{GlobalVariables.getUserSession().getPerson().getPrincipalName(), "print", "Purchase Order"});
        }
        PurchaseOrderVendorQuote poVendorQuote = null;
        for (PurchaseOrderVendorQuote vendorQuote : po.getPurchaseOrderVendorQuotes()) {
            if (!vendorQuote.getPurchaseOrderVendorQuoteIdentifier().equals(vendorQuoteId)) continue;
            poVendorQuote = vendorQuote;
            break;
        }
        if (poVendorQuote == null) {
            throw new RuntimeException();
        }
        ByteArrayOutputStream baosPDF = new ByteArrayOutputStream();
        poVendorQuote.setTransmitPrintDisplayed(false);
        try {
            StringBuffer sbFilename = new StringBuffer();
            sbFilename.append("PURAP_PO_QUOTE_");
            sbFilename.append(po.getPurapDocumentIdentifier());
            sbFilename.append("_");
            sbFilename.append(System.currentTimeMillis());
            sbFilename.append(".pdf");
            boolean success = ((PurchaseOrderService)SpringContext.getBean(PurchaseOrderService.class)).printPurchaseOrderQuotePDF(po, poVendorQuote, baosPDF);
            if (!success) {
                poVendorQuote.setTransmitPrintDisplayed(true);
                if (baosPDF != null) {
                    baosPDF.reset();
                }
                ActionForward actionForward = mapping.findForward("basic");
                return actionForward;
            }
            response.setHeader("Cache-Control", "max-age=30");
            response.setContentType("application/pdf");
            StringBuffer sbContentDispValue = new StringBuffer();
            sbContentDispValue.append("attachment");
            sbContentDispValue.append("; filename=");
            sbContentDispValue.append(sbFilename);
            response.setHeader("Content-disposition", sbContentDispValue.toString());
            response.setContentLength(baosPDF.size());
            ServletOutputStream sos = response.getOutputStream();
            baosPDF.writeTo((OutputStream)sos);
            sos.flush();
        }
        finally {
            if (baosPDF != null) {
                baosPDF.reset();
            }
        }
        return null;
    }
}

