/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.service.impl.StringHelper;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.AttachmentService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.MailService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceInputFileType;
import org.kuali.kfs.module.purap.batch.ElectronicInvoiceStep;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceLoad;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceLoadSummary;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReason;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectReasonType;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.dataaccess.ElectronicInvoicingDao;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.AccountsPayableService;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.module.purap.document.validation.event.AttributedCalculateAccountsPayableEvent;
import org.kuali.kfs.module.purap.document.validation.event.AttributedPaymentRequestForEInvoiceEvent;
import org.kuali.kfs.module.purap.exception.CxmlParseException;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceHelperService;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceMatchingService;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceItemHolder;
import org.kuali.kfs.module.purap.service.impl.ElectronicInvoiceOrderHolder;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.module.purap.util.ExpiredOrClosedAccountEntry;
import org.kuali.kfs.sys.batch.BatchInputFileType;
import org.kuali.kfs.sys.batch.InitiateDirectoryBase;
import org.kuali.kfs.sys.batch.service.BatchInputFileService;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.transaction.annotation.Transactional;
import org.w3c.dom.Element;

public class ElectronicInvoiceHelperServiceImpl
extends InitiateDirectoryBase
implements ElectronicInvoiceHelperService {
    private static Logger LOG = Logger.getLogger(ElectronicInvoiceHelperServiceImpl.class);
    protected final String UNKNOWN_DUNS_IDENTIFIER = "Unknown";
    protected final String INVOICE_FILE_MIME_TYPE = "text/xml";
    private StringBuffer emailTextErrorList;
    protected ElectronicInvoiceInputFileType electronicInvoiceInputFileType;
    protected MailService mailService;
    protected ElectronicInvoiceMatchingService matchingService;
    protected ElectronicInvoicingDao electronicInvoicingDao;
    protected BatchInputFileService batchInputFileService;
    protected VendorService vendorService;
    protected PurchaseOrderService purchaseOrderService;
    protected PaymentRequestService paymentRequestService;
    protected ConfigurationService kualiConfigurationService;
    protected DateTimeService dateTimeService;
    protected ParameterService parameterService;

    @Override
    @NonTransactional
    public ElectronicInvoiceLoad loadElectronicInvoices() {
        this.prepareDirectories(this.getRequiredDirectoryNames());
        String rejectDirName = this.getRejectDirName();
        String acceptDirName = this.getAcceptDirName();
        this.emailTextErrorList = new StringBuffer();
        boolean moveFiles = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(ElectronicInvoiceStep.class, "FILE_MOVE_AFTER_LOAD_IND");
        int failedCnt = 0;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Invoice Base Directory - " + this.electronicInvoiceInputFileType.getDirectoryPath()));
            LOG.info((Object)("Invoice Accept Directory - " + acceptDirName));
            LOG.info((Object)("Invoice Reject Directory - " + rejectDirName));
            LOG.info((Object)("Is moving files allowed - " + moveFiles));
        }
        if (StringUtils.isBlank((String)rejectDirName)) {
            throw new RuntimeException("Reject directory name should not be empty");
        }
        if (StringUtils.isBlank((String)acceptDirName)) {
            throw new RuntimeException("Accept directory name should not be empty");
        }
        File[] filesToBeProcessed = this.getFilesToBeProcessed();
        ElectronicInvoiceLoad eInvoiceLoad = new ElectronicInvoiceLoad();
        if (filesToBeProcessed == null || filesToBeProcessed.length == 0) {
            StringBuffer mailText = new StringBuffer();
            mailText.append("\n\n");
            mailText.append(PurapConstants.ElectronicInvoice.NO_FILES_PROCESSED_EMAIL_MESSAGE);
            mailText.append("\n\n");
            this.sendSummary(mailText);
            return eInvoiceLoad;
        }
        try {
            FileUtils.forceMkdir((File)new File(acceptDirName));
            FileUtils.forceMkdir((File)new File(rejectDirName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(filesToBeProcessed.length + " file(s) available for processing"));
        }
        StringBuilder emailMsg = new StringBuilder();
        for (int i = 0; i < filesToBeProcessed.length; ++i) {
            File xmlFile = filesToBeProcessed[i];
            LOG.info((Object)("Processing " + xmlFile.getName() + "...."));
            byte[] modifiedXML = null;
            if (xmlFile.length() != 0L) {
                modifiedXML = this.addNamespaceDefinition(eInvoiceLoad, xmlFile);
            }
            boolean isRejected = false;
            if (modifiedXML == null) {
                isRejected = true;
            } else {
                try {
                    isRejected = this.processElectronicInvoice(eInvoiceLoad, xmlFile, modifiedXML);
                }
                catch (Exception e) {
                    String msg = xmlFile.getName() + "\n";
                    LOG.error((Object)msg);
                    StackTraceElement[] elements = e.getStackTrace();
                    StringBuffer trace = new StringBuffer();
                    trace.append(e.getClass().getName());
                    if (e.getMessage() != null) {
                        trace.append(": ");
                        trace.append(e.getMessage());
                    }
                    trace.append("\n");
                    for (int j = 0; j < elements.length; ++j) {
                        StackTraceElement element = elements[j];
                        trace.append("    at ");
                        trace.append(ElectronicInvoiceHelperServiceImpl.describeStackTraceElement(element));
                        trace.append("\n");
                    }
                    LOG.error((Object)trace);
                    emailMsg.append(msg);
                    msg = msg + "\n--------------------------------------------------------------------------------------\n" + trace;
                    this.logProcessElectronicInvoiceError(msg);
                    ++failedCnt;
                    GlobalVariables.getMessageMap().clearErrorMessages();
                    continue;
                }
            }
            if (isRejected) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(xmlFile.getName() + " has been rejected"));
                }
                if (moveFiles) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)(xmlFile.getName() + " has been marked to move to " + rejectDirName));
                    }
                    eInvoiceLoad.addRejectFileToMove(xmlFile, rejectDirName);
                }
            } else {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)(xmlFile.getName() + " has been accepted"));
                }
                if (moveFiles && !this.moveFile(xmlFile, acceptDirName)) {
                    String msg = xmlFile.getName() + " unable to move";
                    LOG.error((Object)msg);
                    throw new PurError(msg);
                }
            }
            if (!moveFiles) {
                String fullPath = FilenameUtils.getFullPath((String)xmlFile.getAbsolutePath());
                String fileName = FilenameUtils.getBaseName((String)xmlFile.getAbsolutePath());
                File processedFile = new File(fullPath + File.separator + fileName + ".processed");
                try {
                    FileUtils.touch((File)processedFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.deleteDoneFile(xmlFile);
        }
        this.emailTextErrorList.append("\nFAILED FILES\n");
        this.emailTextErrorList.append("-----------------------------------------------------------\n\n");
        this.emailTextErrorList.append((CharSequence)emailMsg);
        this.emailTextErrorList.append("\nTOTAL COUNT\n");
        this.emailTextErrorList.append("===========================\n");
        this.emailTextErrorList.append("      " + failedCnt + " FAILED\n");
        this.emailTextErrorList.append("===========================\n");
        StringBuffer summaryText = this.saveLoadSummary(eInvoiceLoad);
        StringBuffer finalText = new StringBuffer();
        finalText.append(summaryText);
        finalText.append("\n");
        finalText.append(this.emailTextErrorList);
        this.sendSummary(finalText);
        LOG.info((Object)"Processing completed");
        return eInvoiceLoad;
    }

    protected File[] getFilesToBeProcessed() {
        String baseDirName = this.getBaseDirName();
        File baseDir = new File(baseDirName);
        if (!baseDir.exists()) {
            throw new RuntimeException("Base dir [" + baseDirName + "] doesn't exists in the system");
        }
        File[] filesToBeProcessed = baseDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fullPath = FilenameUtils.getFullPath((String)file.getAbsolutePath());
                String fileName = FilenameUtils.getBaseName((String)file.getAbsolutePath());
                File processedFile = new File(fullPath + File.separator + fileName + ".processed");
                return !file.isDirectory() && file.getName().endsWith(ElectronicInvoiceHelperServiceImpl.this.electronicInvoiceInputFileType.getFileExtension()) && !processedFile.exists();
            }
        });
        return filesToBeProcessed;
    }

    protected void logProcessElectronicInvoiceError(String msg) {
        File file = new File(this.electronicInvoiceInputFileType.getReportPath() + "/" + this.electronicInvoiceInputFileType.getReportPrefix() + "_" + this.dateTimeService.toDateTimeStringForFilename(this.dateTimeService.getCurrentDate()) + "." + this.electronicInvoiceInputFileType.getReportExtension());
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new PrintWriter(file));
            writer.write(msg);
            writer.newLine();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)(file + " not found " + " " + e.getMessage()));
            throw new RuntimeException(file + " not found " + e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.error((Object)("Error writing to BufferedWriter " + e.getMessage()));
            throw new RuntimeException("Error writing to BufferedWriter " + e.getMessage(), e);
        }
        finally {
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private static String describeStackTraceElement(StackTraceElement element) {
        StringBuffer description = new StringBuffer();
        if (element == null) {
            description.append("invalid (null) element");
        }
        description.append(element.getClassName());
        description.append(".");
        description.append(element.getMethodName());
        description.append("(");
        description.append(element.getFileName());
        description.append(":");
        description.append(element.getLineNumber());
        description.append(")");
        return description.toString();
    }

    protected byte[] addNamespaceDefinition(ElectronicInvoiceLoad eInvoiceLoad, File invoiceFile) {
        Element node;
        boolean result = true;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Adding namespace definition");
        }
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setValidating(false);
        builderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder builder = null;
        try {
            builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)("Error getting document builder - " + e.getMessage()));
            throw new RuntimeException(e);
        }
        org.w3c.dom.Document xmlDoc = null;
        try {
            xmlDoc = builder.parse(invoiceFile);
        }
        catch (Exception e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Error parsing the file - " + e.getMessage()));
            }
            this.rejectElectronicInvoiceFile(eInvoiceLoad, "Unknown", invoiceFile, e.getMessage(), "INFF");
            return null;
        }
        Element element = node = xmlDoc.getDocumentElement();
        String xmlnsValue = element.getAttribute("xmlns");
        String xmlnsXsiValue = element.getAttribute("xmlns:xsi");
        File namespaceAddedFile = this.getInvoiceFile(invoiceFile.getName());
        if (StringUtils.equals((String)xmlnsValue, (String)"http://www.kuali.org/kfs/purap/electronicInvoice") && StringUtils.equals((String)xmlnsXsiValue, (String)"http://www.w3.org/2001/XMLSchema-instance")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"xmlns and xmlns:xsi attributes already exists in the invoice xml");
            }
        } else {
            element.setAttribute("xmlns", "http://www.kuali.org/kfs/purap/electronicInvoice");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        OutputFormat outputFormat = new OutputFormat(xmlDoc);
        outputFormat.setOmitDocumentType(true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer((OutputStream)out, outputFormat);
        try {
            serializer.asDOMSerializer();
            serializer.serialize(xmlDoc.getDocumentElement());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Namespace validation completed");
        }
        return out.toByteArray();
    }

    @Transactional
    protected boolean processElectronicInvoice(ElectronicInvoiceLoad eInvoiceLoad, File invoiceFile, byte[] xmlAsBytes) {
        ElectronicInvoice eInvoice = null;
        try {
            eInvoice = this.loadElectronicInvoice(xmlAsBytes);
        }
        catch (CxmlParseException e) {
            LOG.info((Object)("Error loading file - " + e.getMessage()));
            this.rejectElectronicInvoiceFile(eInvoiceLoad, "Unknown", invoiceFile, e.getMessage(), "INFF");
            return true;
        }
        eInvoice.setFileName(invoiceFile.getName());
        boolean isCompleteFailure = this.checkForCompleteFailure(eInvoiceLoad, eInvoice, invoiceFile);
        if (isCompleteFailure) {
            return true;
        }
        this.setVendorDUNSNumber(eInvoice);
        this.setVendorDetails(eInvoice);
        Map itemTypeMappings = this.getItemTypeMappings(eInvoice.getVendorHeaderID(), eInvoice.getVendorDetailID());
        Map<String, ItemType> kualiItemTypes = this.getKualiItemTypes();
        if (LOG.isInfoEnabled() && itemTypeMappings != null && itemTypeMappings.size() > 0) {
            LOG.info((Object)"Item mappings found");
        }
        boolean validateHeader = true;
        for (ElectronicInvoiceOrder order : eInvoice.getInvoiceDetailOrders()) {
            ElectronicInvoiceLoadSummary loadSummary;
            String poID = order.getOrderReferenceOrderID();
            PurchaseOrderDocument po = null;
            if (NumberUtils.isDigits((String)StringUtils.defaultString((String)poID)) && (po = this.purchaseOrderService.getCurrentPurchaseOrder(new Integer(poID))) != null) {
                order.setInvoicePurchaseOrderID(poID);
                order.setPurchaseOrderID(po.getPurapDocumentIdentifier());
                order.setPurchaseOrderCampusCode(po.getDeliveryCampusCode());
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"PO matching Document found");
                }
            }
            ElectronicInvoiceOrderHolder orderHolder = new ElectronicInvoiceOrderHolder(eInvoice, order, po, itemTypeMappings, kualiItemTypes, validateHeader);
            this.matchingService.doMatchingProcess(orderHolder);
            if (orderHolder.isInvoiceRejected()) {
                ElectronicInvoiceRejectDocument rejectDocument = this.createRejectDocument(eInvoice, order, eInvoiceLoad);
                if (orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier() != null) {
                    rejectDocument.setAccountsPayablePurchasingDocumentLinkIdentifier(orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier());
                }
                String dunsNumber = StringUtils.isEmpty((String)eInvoice.getDunsNumber()) ? "Unknown" : eInvoice.getDunsNumber();
                loadSummary = this.getOrCreateLoadSummary(eInvoiceLoad, dunsNumber);
                loadSummary.addFailedInvoiceOrder(rejectDocument.getTotalAmount(), eInvoice);
                eInvoiceLoad.insertInvoiceLoadSummary(loadSummary);
            } else {
                PaymentRequestDocument preqDoc = this.createPaymentRequest(orderHolder);
                if (orderHolder.isInvoiceRejected()) {
                    GlobalVariables.getMessageMap().clearErrorMessages();
                    ElectronicInvoiceRejectDocument rejectDocument = this.createRejectDocument(eInvoice, order, eInvoiceLoad);
                    if (orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier() != null) {
                        rejectDocument.setAccountsPayablePurchasingDocumentLinkIdentifier(orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier());
                    }
                    loadSummary = this.getOrCreateLoadSummary(eInvoiceLoad, eInvoice.getDunsNumber());
                    loadSummary.addFailedInvoiceOrder(rejectDocument.getTotalAmount(), eInvoice);
                    eInvoiceLoad.insertInvoiceLoadSummary(loadSummary);
                } else {
                    ElectronicInvoiceLoadSummary loadSummary2 = this.getOrCreateLoadSummary(eInvoiceLoad, eInvoice.getDunsNumber());
                    loadSummary2.addSuccessfulInvoiceOrder(preqDoc.getTotalDollarAmount(), eInvoice);
                    eInvoiceLoad.insertInvoiceLoadSummary(loadSummary2);
                }
            }
            validateHeader = false;
        }
        return eInvoice.isFileRejected();
    }

    protected void setVendorDUNSNumber(ElectronicInvoice eInvoice) {
        String dunsNumber = null;
        if (StringUtils.equals((String)eInvoice.getCxmlHeader().getFromDomain(), (String)"DUNS")) {
            dunsNumber = eInvoice.getCxmlHeader().getFromIdentity();
        } else if (StringUtils.equals((String)eInvoice.getCxmlHeader().getSenderDomain(), (String)"DUNS")) {
            dunsNumber = eInvoice.getCxmlHeader().getSenderIdentity();
        }
        if (StringUtils.isNotEmpty((String)dunsNumber)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Setting Vendor DUNS number - " + dunsNumber));
            }
            eInvoice.setDunsNumber(dunsNumber);
        }
    }

    protected void setVendorDetails(ElectronicInvoice eInvoice) {
        if (StringUtils.isNotEmpty((String)eInvoice.getDunsNumber())) {
            VendorDetail vendorDetail = this.vendorService.getVendorByDunsNumber(eInvoice.getDunsNumber());
            if (vendorDetail != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Vendor match found - " + vendorDetail.getVendorNumber()));
                }
                eInvoice.setVendorHeaderID(vendorDetail.getVendorHeaderGeneratedIdentifier());
                eInvoice.setVendorDetailID(vendorDetail.getVendorDetailAssignedIdentifier());
                eInvoice.setVendorName(vendorDetail.getVendorName());
            } else {
                eInvoice.setVendorHeaderID(null);
                eInvoice.setVendorDetailID(null);
                eInvoice.setVendorName(null);
            }
        }
    }

    protected void validateVendorDetails(ElectronicInvoiceRejectDocument rejectDocument) {
        VendorDetail vendorDetail;
        boolean vendorFound = false;
        if (StringUtils.isNotEmpty((String)rejectDocument.getVendorDunsNumber()) && (vendorDetail = this.vendorService.getVendorByDunsNumber(rejectDocument.getVendorDunsNumber())) != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Vendor [" + vendorDetail.getVendorNumber() + "] match found for the DUNS - " + rejectDocument.getVendorDunsNumber()));
            }
            rejectDocument.setVendorHeaderGeneratedIdentifier(vendorDetail.getVendorHeaderGeneratedIdentifier());
            rejectDocument.setVendorDetailAssignedIdentifier(vendorDetail.getVendorDetailAssignedIdentifier());
            rejectDocument.setVendorDetail(vendorDetail);
            vendorFound = true;
        }
        if (!vendorFound) {
            rejectDocument.setVendorHeaderGeneratedIdentifier(null);
            rejectDocument.setVendorDetailAssignedIdentifier(null);
            rejectDocument.setVendorDetail(null);
        }
        String newDocumentDesc = this.generateRejectDocumentDescription(rejectDocument);
        rejectDocument.getDocumentHeader().setDocumentDescription(newDocumentDesc);
    }

    protected Map getItemTypeMappings(Integer vendorHeaderId, Integer vendorDetailId) {
        Map itemTypeMappings = null;
        if (vendorHeaderId != null && vendorDetailId != null) {
            String vendorNumber = this.getVendorNumber(vendorHeaderId, vendorDetailId);
            itemTypeMappings = this.electronicInvoicingDao.getItemMappingMap(vendorHeaderId, vendorDetailId);
        }
        if (itemTypeMappings == null || itemTypeMappings.isEmpty()) {
            itemTypeMappings = this.electronicInvoicingDao.getDefaultItemMappingMap();
        }
        return itemTypeMappings;
    }

    protected String getVendorNumber(Integer vendorHeaderId, Integer vendorDetailId) {
        if (vendorHeaderId != null && vendorDetailId != null) {
            VendorDetail forVendorNo = new VendorDetail();
            forVendorNo.setVendorHeaderGeneratedIdentifier(vendorHeaderId);
            forVendorNo.setVendorDetailAssignedIdentifier(vendorDetailId);
            return forVendorNo.getVendorNumber();
        }
        return null;
    }

    protected Map<String, ItemType> getKualiItemTypes() {
        Collection collection = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findAll(ItemType.class);
        HashMap<String, ItemType> kualiItemTypes = new HashMap<String, ItemType>();
        if (collection == null || collection.size() == 0) {
            throw new RuntimeException("Kauli Item types not available");
        }
        if (collection != null) {
            ItemType[] itemTypes = new ItemType[collection.size()];
            collection.toArray(itemTypes);
            for (int i = 0; i < itemTypes.length; ++i) {
                kualiItemTypes.put(itemTypes[i].getItemTypeCode(), itemTypes[i]);
            }
        }
        return kualiItemTypes;
    }

    protected boolean checkForCompleteFailure(ElectronicInvoiceLoad electronicInvoiceLoad, ElectronicInvoice electronicInvoice, File invoiceFile) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Checking for complete failure...");
        }
        if (electronicInvoice.getInvoiceDetailRequestHeader().isHeaderInvoiceIndicator()) {
            this.rejectElectronicInvoiceFile(electronicInvoiceLoad, "Unknown", invoiceFile, "HIIO");
            return true;
        }
        if (electronicInvoice.getInvoiceDetailOrders().size() < 1) {
            this.rejectElectronicInvoiceFile(electronicInvoiceLoad, "Unknown", invoiceFile, "NOIV");
            return true;
        }
        for (ElectronicInvoiceOrder invoiceOrder : electronicInvoice.getInvoiceDetailOrders()) {
            for (ElectronicInvoiceItem invoiceItem : invoiceOrder.getInvoiceItems()) {
                if (invoiceItem == null) continue;
                invoiceItem.setCatalogNumber(invoiceItem.getReferenceItemIDSupplierPartID());
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"No Complete failure");
        }
        return false;
    }

    protected ElectronicInvoiceRejectReasonType getRejectReasonType(String rejectReasonTypeCode) {
        return this.matchingService.getElectronicInvoiceRejectReasonType(rejectReasonTypeCode);
    }

    protected void rejectElectronicInvoiceFile(ElectronicInvoiceLoad eInvoiceLoad, String fileDunsNumber, File filename, String rejectReasonTypeCode) {
        this.rejectElectronicInvoiceFile(eInvoiceLoad, fileDunsNumber, filename, null, rejectReasonTypeCode);
    }

    protected void rejectElectronicInvoiceFile(ElectronicInvoiceLoad eInvoiceLoad, String fileDunsNumber, File invoiceFile, String extraDescription, String rejectReasonTypeCode) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Rejecting the entire invoice file - " + invoiceFile.getName()));
        }
        ElectronicInvoiceLoadSummary eInvoiceLoadSummary = this.getOrCreateLoadSummary(eInvoiceLoad, fileDunsNumber);
        eInvoiceLoadSummary.addFailedInvoiceOrder();
        eInvoiceLoad.insertInvoiceLoadSummary(eInvoiceLoadSummary);
        ElectronicInvoiceRejectDocument eInvoiceRejectDocument = null;
        try {
            eInvoiceRejectDocument = (ElectronicInvoiceRejectDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("EIRT");
            eInvoiceRejectDocument.setInvoiceProcessTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
            eInvoiceRejectDocument.setVendorDunsNumber(fileDunsNumber);
            eInvoiceRejectDocument.setDocumentCreationInProgress(true);
            if (invoiceFile != null) {
                eInvoiceRejectDocument.setInvoiceFileName(invoiceFile.getName());
            }
            ArrayList<ElectronicInvoiceRejectReason> list = new ArrayList<ElectronicInvoiceRejectReason>(1);
            String message = "Complete failure document has been created for the Invoice with Filename '" + invoiceFile.getName() + "' due to the following error:\n";
            this.emailTextErrorList.append(message);
            ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason(rejectReasonTypeCode, extraDescription, invoiceFile.getName());
            list.add(rejectReason);
            this.emailTextErrorList.append("    - " + rejectReason.getInvoiceRejectReasonDescription());
            this.emailTextErrorList.append("\n\n");
            eInvoiceRejectDocument.setInvoiceRejectReasons(list);
            eInvoiceRejectDocument.getDocumentHeader().setDocumentDescription("Complete failure");
            ((DocumentService)SpringContext.getBean(DocumentService.class)).saveDocument((Document)eInvoiceRejectDocument);
            String noteText = "Invoice file";
            this.attachInvoiceXMLWithRejectDoc(eInvoiceRejectDocument, invoiceFile, noteText);
            eInvoiceLoad.addInvoiceReject(eInvoiceRejectDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Complete failure document has been created (DocNo:" + eInvoiceRejectDocument.getDocumentNumber() + ")"));
        }
    }

    protected void attachInvoiceXMLWithRejectDoc(ElectronicInvoiceRejectDocument eInvoiceRejectDocument, File attachmentFile, String noteText) {
        Note note = null;
        try {
            note = ((DocumentService)SpringContext.getBean(DocumentService.class)).createNoteFromDocument((Document)eInvoiceRejectDocument, noteText);
            note.setRemoteObjectIdentifier(eInvoiceRejectDocument.getDocumentHeader().getObjectId());
        }
        catch (Exception e1) {
            throw new RuntimeException("Unable to create note from document: ", e1);
        }
        String attachmentType = null;
        BufferedInputStream fileStream = null;
        try {
            fileStream = new BufferedInputStream(new FileInputStream(attachmentFile));
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Exception opening attachment file", (Throwable)e);
        }
        Attachment attachment = null;
        try {
            attachment = ((AttachmentService)SpringContext.getBean(AttachmentService.class)).createAttachment(eInvoiceRejectDocument.getNoteTarget(), attachmentFile.getName(), "text/xml", (int)attachmentFile.length(), (InputStream)fileStream, attachmentType);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create attachment", e);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Exception closing file", (Throwable)e);
                }
            }
        }
        note.setAttachment(attachment);
        attachment.setNote(note);
        ((NoteService)SpringContext.getBean(NoteService.class)).save(note);
    }

    @NonTransactional
    public ElectronicInvoiceRejectDocument createRejectDocument(ElectronicInvoice eInvoice, ElectronicInvoiceOrder electronicInvoiceOrder, ElectronicInvoiceLoad eInvoiceLoad) {
        ElectronicInvoiceRejectDocument eInvoiceRejectDocument;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Creating reject document [DUNS=" + eInvoice.getDunsNumber() + ",POID=" + electronicInvoiceOrder.getInvoicePurchaseOrderID() + "]"));
        }
        try {
            eInvoiceRejectDocument = (ElectronicInvoiceRejectDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("EIRT");
            eInvoiceRejectDocument.setInvoiceProcessTimestamp(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentTimestamp());
            String rejectdocDesc = this.generateRejectDocumentDescription(eInvoice, electronicInvoiceOrder);
            eInvoiceRejectDocument.getDocumentHeader().setDocumentDescription(rejectdocDesc);
            eInvoiceRejectDocument.setDocumentCreationInProgress(true);
            eInvoiceRejectDocument.setFileLevelData(eInvoice);
            eInvoiceRejectDocument.setInvoiceOrderLevelData(eInvoice, electronicInvoiceOrder);
            ((DocumentService)SpringContext.getBean(DocumentService.class)).saveDocument((Document)eInvoiceRejectDocument);
            String noteText = "Invoice file";
            this.attachInvoiceXMLWithRejectDoc(eInvoiceRejectDocument, this.getInvoiceFile(eInvoice.getFileName()), noteText);
            eInvoiceLoad.addInvoiceReject(eInvoiceRejectDocument);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Reject document has been created (DocNo=" + eInvoiceRejectDocument.getDocumentNumber() + ")"));
        }
        this.emailTextErrorList.append("DUNS Number - " + eInvoice.getDunsNumber() + " " + eInvoice.getVendorName() + ":\n");
        this.emailTextErrorList.append("An Invoice from file '" + eInvoice.getFileName() + "' has been rejected due to the following error(s):\n");
        int index = 1;
        for (ElectronicInvoiceRejectReason reason : eInvoiceRejectDocument.getInvoiceRejectReasons()) {
            this.emailTextErrorList.append("    - " + reason.getInvoiceRejectReasonDescription() + "\n");
            this.addRejectReasonsToNote("Reject Reason " + index + ". " + reason.getInvoiceRejectReasonDescription(), eInvoiceRejectDocument);
            ++index;
        }
        this.emailTextErrorList.append("\n");
        return eInvoiceRejectDocument;
    }

    protected void addRejectReasonsToNote(String rejectReasons, ElectronicInvoiceRejectDocument eInvoiceRejectDocument) {
        try {
            Note note = ((DocumentService)SpringContext.getBean(DocumentService.class)).createNoteFromDocument((Document)eInvoiceRejectDocument, rejectReasons);
            note.setRemoteObjectIdentifier(eInvoiceRejectDocument.getDocumentHeader().getObjectId());
            PersistableBusinessObject noteParent = eInvoiceRejectDocument.getNoteTarget();
            ((NoteService)SpringContext.getBean(NoteService.class)).save(note);
        }
        catch (Exception e) {
            LOG.error((Object)("Error creating reject reason note - " + e.getMessage()));
        }
    }

    protected String generateRejectDocumentDescription(ElectronicInvoice eInvoice, ElectronicInvoiceOrder electronicInvoiceOrder) {
        String poID = StringUtils.isEmpty((String)electronicInvoiceOrder.getInvoicePurchaseOrderID()) ? "UNKNOWN" : electronicInvoiceOrder.getInvoicePurchaseOrderID();
        String vendorName = StringUtils.isEmpty((String)eInvoice.getVendorName()) ? "UNKNOWN" : eInvoice.getVendorName();
        String description = "PO: " + poID + " Vendor: " + vendorName;
        return this.checkDescriptionLengthAndStripIfNeeded(description);
    }

    protected String generateRejectDocumentDescription(ElectronicInvoiceRejectDocument rejectDoc) {
        String poID = StringUtils.isEmpty((String)rejectDoc.getInvoicePurchaseOrderNumber()) ? "UNKNOWN" : rejectDoc.getInvoicePurchaseOrderNumber();
        String vendorName = "UNKNOWN";
        if (rejectDoc.getVendorDetail() != null) {
            vendorName = rejectDoc.getVendorDetail().getVendorName();
        }
        String description = "PO: " + poID + " Vendor: " + vendorName;
        return this.checkDescriptionLengthAndStripIfNeeded(description);
    }

    protected String checkDescriptionLengthAndStripIfNeeded(String description) {
        int noteTextMaxLength = ((DataDictionaryService)SpringContext.getBean(DataDictionaryService.class)).getAttributeMaxLength(DocumentHeader.class, "documentDescription");
        if (noteTextMaxLength < description.length()) {
            description = description.substring(0, noteTextMaxLength);
        }
        return description;
    }

    @NonTransactional
    public ElectronicInvoiceLoadSummary getOrCreateLoadSummary(ElectronicInvoiceLoad eInvoiceLoad, String fileDunsNumber) {
        ElectronicInvoiceLoadSummary eInvoiceLoadSummary = eInvoiceLoad.getInvoiceLoadSummaries().containsKey(fileDunsNumber) ? (ElectronicInvoiceLoadSummary)((Object)eInvoiceLoad.getInvoiceLoadSummaries().get(fileDunsNumber)) : new ElectronicInvoiceLoadSummary(fileDunsNumber);
        return eInvoiceLoadSummary;
    }

    @NonTransactional
    public ElectronicInvoice loadElectronicInvoice(byte[] xmlAsBytes) throws CxmlParseException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Loading Invoice File");
        }
        ElectronicInvoice electronicInvoice = null;
        try {
            electronicInvoice = (ElectronicInvoice)this.batchInputFileService.parse((BatchInputFileType)this.electronicInvoiceInputFileType, xmlAsBytes);
        }
        catch (ParseException e) {
            throw new CxmlParseException(e.getMessage());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Successfully loaded the Invoice File");
        }
        return electronicInvoice;
    }

    protected StringBuffer saveLoadSummary(ElectronicInvoiceLoad eInvoiceLoad) {
        HashMap<String, ElectronicInvoiceLoadSummary> savedLoadSummariesMap = new HashMap<String, ElectronicInvoiceLoadSummary>();
        StringBuffer summaryMessage = new StringBuffer();
        for (String dunsNumber : eInvoiceLoad.getInvoiceLoadSummaries().keySet()) {
            ElectronicInvoiceLoadSummary eInvoiceLoadSummary = (ElectronicInvoiceLoadSummary)((Object)eInvoiceLoad.getInvoiceLoadSummaries().get(dunsNumber));
            if (!eInvoiceLoadSummary.isEmpty().booleanValue()) {
                LOG.info((Object)("Saving Load Summary for DUNS '" + dunsNumber + "'"));
                ElectronicInvoiceLoadSummary currentLoadSummary = this.saveElectronicInvoiceLoadSummary(eInvoiceLoadSummary);
                summaryMessage.append("DUNS Number - " + eInvoiceLoadSummary.getVendorDescriptor() + ":\n");
                summaryMessage.append("     " + eInvoiceLoadSummary.getInvoiceLoadSuccessCount() + " successfully processed invoices for a total of $ " + eInvoiceLoadSummary.getInvoiceLoadSuccessAmount().doubleValue() + "\n");
                summaryMessage.append("     " + eInvoiceLoadSummary.getInvoiceLoadFailCount() + " rejected invoices for an approximate total of $ " + eInvoiceLoadSummary.getInvoiceLoadFailAmount().doubleValue() + "\n");
                summaryMessage.append("\n\n");
                savedLoadSummariesMap.put(currentLoadSummary.getVendorDunsNumber(), eInvoiceLoadSummary);
                continue;
            }
            LOG.info((Object)("Not saving Load Summary for DUNS '" + dunsNumber + "' because empty indicator is '" + eInvoiceLoadSummary.isEmpty() + "'"));
        }
        summaryMessage.append("\n\n");
        for (ElectronicInvoiceRejectDocument rejectDoc : eInvoiceLoad.getRejectDocuments()) {
            this.routeRejectDocument(rejectDoc, savedLoadSummariesMap);
        }
        this.moveFileList(eInvoiceLoad.getRejectFilesToMove());
        return summaryMessage;
    }

    protected void routeRejectDocument(ElectronicInvoiceRejectDocument rejectDoc, Map savedLoadSummariesMap) {
        LOG.info((Object)("Saving Invoice Reject for DUNS '" + rejectDoc.getVendorDunsNumber() + "'"));
        if (savedLoadSummariesMap.containsKey(rejectDoc.getVendorDunsNumber())) {
            rejectDoc.setInvoiceLoadSummary((ElectronicInvoiceLoadSummary)((Object)savedLoadSummariesMap.get(rejectDoc.getVendorDunsNumber())));
        } else {
            rejectDoc.setInvoiceLoadSummary((ElectronicInvoiceLoadSummary)((Object)savedLoadSummariesMap.get("Unknown")));
        }
        try {
            ((DocumentService)SpringContext.getBean(DocumentService.class)).routeDocument((Document)rejectDoc, "Routed by electronic invoice batch job", null);
        }
        catch (WorkflowException e) {
            e.printStackTrace();
        }
    }

    protected void sendSummary(StringBuffer message) {
        String fromMailId = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(ElectronicInvoiceStep.class, "DAILY_SUMMARY_REPORT_FROM_EMAIL_ADDRESS");
        ArrayList<String> toMailIds = new ArrayList<String>(((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValuesAsString(ElectronicInvoiceStep.class, "DAILY_SUMMARY_REPORT_TO_EMAIL_ADDRESSES"));
        LOG.info((Object)("From email address parameter value:" + fromMailId));
        LOG.info((Object)("To email address parameter value:" + toMailIds));
        if (StringUtils.isBlank((String)fromMailId) || toMailIds.isEmpty()) {
            LOG.error((Object)"From/To mail addresses are empty. Unable to send the message");
        } else {
            MailMessage mailMessage = new MailMessage();
            mailMessage.setFromAddress(fromMailId);
            this.setMessageToAddressesAndSubject(mailMessage, toMailIds);
            mailMessage.setMessage(message.toString());
            try {
                this.mailService.sendMessage(mailMessage);
            }
            catch (Exception e) {
                LOG.error((Object)"Invalid email address. Message not sent", (Throwable)e);
            }
        }
    }

    protected MailMessage setMessageToAddressesAndSubject(MailMessage message, List<String> toAddressList) {
        if (!toAddressList.isEmpty()) {
            for (int i = 0; i < toAddressList.size(); ++i) {
                if (!StringUtils.isNotEmpty((String)toAddressList.get(i))) continue;
                message.addToAddress(toAddressList.get(i).trim());
            }
        }
        String mailTitle = "E-Invoice Load Results for " + ElectronicInvoiceUtils.getDateDisplayText(((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentDate());
        message.setSubject(mailTitle);
        return message;
    }

    @Override
    @NonTransactional
    public boolean doMatchingProcess(ElectronicInvoiceRejectDocument rejectDocument) {
        this.validateVendorDetails(rejectDocument);
        Map itemTypeMappings = this.getItemTypeMappings(rejectDocument.getVendorHeaderGeneratedIdentifier(), rejectDocument.getVendorDetailAssignedIdentifier());
        Map<String, ItemType> kualiItemTypes = this.getKualiItemTypes();
        ElectronicInvoiceOrderHolder rejectDocHolder = new ElectronicInvoiceOrderHolder(rejectDocument, itemTypeMappings, kualiItemTypes);
        this.matchingService.doMatchingProcess(rejectDocHolder);
        if (!rejectDocHolder.isInvoiceRejected()) {
            this.validateInvoiceOrderValidForPREQCreation(rejectDocHolder);
        }
        ArrayList ignoreRejectTypes = new ArrayList(this.parameterService.getParameterValuesAsString("KFS-PURAP", "ElectronicInvoiceReject", "SUPPRESS_REJECT_REASON_CODES_ON_EIRT_APPROVAL"));
        ArrayList<ElectronicInvoiceRejectReason> rejectReasonsToDelete = new ArrayList<ElectronicInvoiceRejectReason>();
        for (ElectronicInvoiceRejectReason rejectReason : rejectDocument.getInvoiceRejectReasons()) {
            String rejectedReasonTypeCode = rejectReason.getInvoiceRejectReasonTypeCode();
            if (!StringUtils.isNotBlank((String)rejectedReasonTypeCode) || !ignoreRejectTypes.contains(rejectedReasonTypeCode)) continue;
            rejectReasonsToDelete.add(rejectReason);
        }
        if (!rejectReasonsToDelete.isEmpty()) {
            rejectDocument.getInvoiceRejectReasons().removeAll(rejectReasonsToDelete);
        }
        if (rejectDocument.getInvoiceRejectReasons().isEmpty()) {
            GlobalVariables.getMessageMap().clearErrorMessages();
        }
        return !rejectDocHolder.isInvoiceRejected();
    }

    @Override
    @NonTransactional
    public boolean createPaymentRequest(ElectronicInvoiceRejectDocument rejectDocument) {
        if (rejectDocument.getInvoiceRejectReasons().size() > 0) {
            throw new RuntimeException("Not possible to create payment request since the reject document contains " + rejectDocument.getInvoiceRejectReasons().size() + " rejects");
        }
        Map itemTypeMappings = this.getItemTypeMappings(rejectDocument.getVendorHeaderGeneratedIdentifier(), rejectDocument.getVendorDetailAssignedIdentifier());
        Map<String, ItemType> kualiItemTypes = this.getKualiItemTypes();
        ElectronicInvoiceOrderHolder rejectDocHolder = new ElectronicInvoiceOrderHolder(rejectDocument, itemTypeMappings, kualiItemTypes);
        PaymentRequestDocument preqDocument = this.createPaymentRequest(rejectDocHolder);
        rejectDocument.setPaymentRequestIdentifier(preqDocument.getPurapDocumentIdentifier());
        return !rejectDocHolder.isInvoiceRejected();
    }

    protected PaymentRequestDocument createPaymentRequest(ElectronicInvoiceOrderHolder orderHolder) {
        Bank defaultBank;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Creating Payment Request document");
        }
        KNSGlobalVariables.getMessageList().clear();
        this.validateInvoiceOrderValidForPREQCreation(orderHolder);
        if (LOG.isInfoEnabled()) {
            if (orderHolder.isInvoiceRejected()) {
                LOG.info((Object)"Not possible to convert einvoice details into payment request");
            } else {
                LOG.info((Object)"Payment request document creation validation succeeded");
            }
        }
        if (orderHolder.isInvoiceRejected()) {
            return null;
        }
        PaymentRequestDocument preqDoc = null;
        try {
            preqDoc = (PaymentRequestDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getNewDocument("PREQ");
        }
        catch (WorkflowException e) {
            String extraDescription = "Error=" + e.getMessage();
            ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason("PRWE", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason);
            LOG.error((Object)("Error creating Payment request document - " + e.getMessage()));
            return null;
        }
        PurchaseOrderDocument poDoc = orderHolder.getPurchaseOrderDocument();
        if (poDoc == null) {
            throw new RuntimeException("Purchase Order document (POId=" + poDoc.getPurapDocumentIdentifier() + ") does not exist in the system");
        }
        preqDoc.getDocumentHeader().setDocumentDescription(this.generatePREQDocumentDescription(poDoc));
        try {
            preqDoc.updateAndSaveAppDocStatus("In Process");
        }
        catch (WorkflowException we) {
            throw new RuntimeException("Unable to save route status data for document: " + preqDoc.getDocumentNumber(), we);
        }
        preqDoc.setInvoiceDate(orderHolder.getInvoiceDate());
        preqDoc.setInvoiceNumber(orderHolder.getInvoiceNumber());
        preqDoc.setVendorInvoiceAmount(new KualiDecimal(orderHolder.getInvoiceNetAmount()));
        preqDoc.setAccountsPayableProcessorIdentifier("E-Invoice");
        preqDoc.setVendorCustomerNumber(orderHolder.getCustomerNumber());
        preqDoc.setPaymentRequestElectronicInvoiceIndicator(true);
        if (orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier() != null) {
            preqDoc.setAccountsPayablePurchasingDocumentLinkIdentifier(orderHolder.getAccountsPayablePurchasingDocumentLinkIdentifier());
        }
        if ((defaultBank = ((BankService)SpringContext.getBean(BankService.class)).getDefaultBankByDocType(preqDoc.getClass())) != null) {
            preqDoc.setBankCode(defaultBank.getBankCode());
            preqDoc.setBank(defaultBank);
        }
        RequisitionDocument reqDoc = ((RequisitionService)SpringContext.getBean(RequisitionService.class)).getRequisitionById(poDoc.getRequisitionIdentifier());
        String reqDocInitiator = reqDoc.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
        try {
            Person user = KimApiServiceLocator.getPersonService().getPerson(reqDocInitiator);
            this.setProcessingCampus(preqDoc, user.getCampusCode());
        }
        catch (Exception e) {
            String extraDescription = "Error setting processing campus code - " + e.getMessage();
            ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason("PRVE", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason);
            return null;
        }
        HashMap<String, ExpiredOrClosedAccountEntry> expiredOrClosedAccountList = ((AccountsPayableService)SpringContext.getBean(AccountsPayableService.class)).expiredOrClosedAccountsList(poDoc);
        if (expiredOrClosedAccountList == null) {
            expiredOrClosedAccountList = new HashMap();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(expiredOrClosedAccountList.size() + " accounts has been found as Expired or Closed"));
        }
        preqDoc.populatePaymentRequestFromPurchaseOrder(orderHolder.getPurchaseOrderDocument(), expiredOrClosedAccountList);
        this.populateItemDetails(preqDoc, orderHolder);
        ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedCalculateAccountsPayableEvent((Document)preqDoc));
        ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).calculatePaymentRequest(preqDoc, true);
        this.processItemsForDiscount(preqDoc, orderHolder);
        if (orderHolder.isInvoiceRejected()) {
            return null;
        }
        ((PaymentRequestService)SpringContext.getBean(PaymentRequestService.class)).calculatePaymentRequest(preqDoc, false);
        ((KualiRuleService)SpringContext.getBean(KualiRuleService.class)).applyRules((KualiDocumentEvent)new AttributedPaymentRequestForEInvoiceEvent((Document)preqDoc));
        if (GlobalVariables.getMessageMap().hasErrors()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("***************Error in rules processing - " + GlobalVariables.getMessageMap()));
            }
            Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
            String errors = errorMessages.toString();
            ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason("PRVE", errors, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason);
            return null;
        }
        if (KNSGlobalVariables.getMessageList().size() > 0 && LOG.isInfoEnabled()) {
            LOG.info((Object)("Payment request contains " + KNSGlobalVariables.getMessageList().size() + " warning message(s)"));
            for (int i = 0; i < KNSGlobalVariables.getMessageList().size(); ++i) {
                LOG.info((Object)("Warning " + i + "  - " + KNSGlobalVariables.getMessageList().get(i)));
            }
        }
        this.addShipToNotes(preqDoc, orderHolder);
        String routingAnnotation = null;
        if (!orderHolder.isRejectDocumentHolder()) {
            routingAnnotation = "Routed by electronic invoice batch job";
        }
        try {
            ((DocumentService)SpringContext.getBean(DocumentService.class)).routeDocument((Document)preqDoc, routingAnnotation, null);
        }
        catch (WorkflowException e) {
            e.printStackTrace();
            ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason("PRRF", e.getMessage(), orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason);
            return null;
        }
        catch (ValidationException e) {
            String extraDescription = GlobalVariables.getMessageMap().toString();
            ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason("PRVE", extraDescription, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason);
            return null;
        }
        return preqDoc;
    }

    protected void setProcessingCampus(PaymentRequestDocument preqDoc, String initiatorCampusCode) {
        String campusCode = this.parameterService.getParameterValueAsString(ElectronicInvoiceStep.class, "OVERRIDE_PROCESSING_CAMPUS");
        if (!StringHelper.isNullOrEmpty((String)campusCode)) {
            preqDoc.setProcessingCampusCode(campusCode);
        } else {
            preqDoc.setProcessingCampusCode(initiatorCampusCode);
        }
    }

    protected void addShipToNotes(PaymentRequestDocument preqDoc, ElectronicInvoiceOrderHolder orderHolder) {
        String shipToAddress = orderHolder.getInvoiceShipToAddressAsString();
        try {
            Note noteObj = ((DocumentService)SpringContext.getBean(DocumentService.class)).createNoteFromDocument((Document)preqDoc, shipToAddress);
            preqDoc.addNote(noteObj);
        }
        catch (Exception e) {
            LOG.error((Object)("Error creating ShipTo notes - " + e.getMessage()));
        }
    }

    protected void processItemsForDiscount(PaymentRequestDocument preqDocument, ElectronicInvoiceOrderHolder orderHolder) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Processing payment request items for discount");
        }
        if (!orderHolder.isItemTypeAvailableInItemMapping(ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Skipping discount processing since there is no mapping of discount type for this vendor");
            }
            return;
        }
        if (orderHolder.getInvoiceDiscountAmount() == null || orderHolder.getInvoiceDiscountAmount() == BigDecimal.ZERO) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Skipping discount processing since there is no discount amount found in the invoice file");
            }
            return;
        }
        KualiDecimal discountValueToUse = new KualiDecimal(orderHolder.getInvoiceDiscountAmount().negate());
        List preqItems = preqDocument.getItems();
        boolean alreadyProcessedInvoiceDiscount = false;
        boolean hasKualiPaymentTermsDiscountItem = false;
        for (int i = 0; i < preqItems.size(); ++i) {
            PaymentRequestItem preqItem = (PaymentRequestItem)preqItems.get(i);
            boolean bl = hasKualiPaymentTermsDiscountItem = hasKualiPaymentTermsDiscountItem || StringUtils.equals((String)"DISC", (String)preqItem.getItemTypeCode());
            if (!this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT, orderHolder)) continue;
            alreadyProcessedInvoiceDiscount = true;
            if (StringUtils.equals((String)preqItem.getItemTypeCode(), (String)"DISC")) {
                KualiDecimal preqExtendedPrice;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Discount Check - E-Invoice matches PREQ item type '" + preqItem.getItemTypeCode() + "'... now checking for amount"));
                }
                KualiDecimal kualiDecimal = preqExtendedPrice = preqItem.getExtendedPrice() == null ? KualiDecimal.ZERO : preqItem.getExtendedPrice();
                if (discountValueToUse.compareTo((AbstractKualiDecimal)preqExtendedPrice) >= 0) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Discount Check - Using E-Invoice amount (" + discountValueToUse + ") as it is more discount than current payment terms amount " + preqExtendedPrice));
                }
                preqItem.setItemUnitPrice(discountValueToUse.bigDecimalValue());
                preqItem.setExtendedPrice(discountValueToUse);
                continue;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Discount Check - E-Invoice matches PREQ item type '" + preqItem.getItemTypeCode() + "'"));
                LOG.info((Object)("Discount Check - Using E-Invoice amount (" + discountValueToUse + ") as it is greater than payment terms amount"));
            }
            preqItem.addToUnitPrice(discountValueToUse.bigDecimalValue());
            preqItem.addToExtendedPrice(discountValueToUse);
        }
        if (!alreadyProcessedInvoiceDiscount) {
            String itemTypeRequired = "DISC";
            if (hasKualiPaymentTermsDiscountItem || !orderHolder.isItemTypeAvailableInItemMapping(ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT)) {
                ElectronicInvoiceRejectReason rejectReason = this.matchingService.createRejectReason("PRDE", null, orderHolder.getFileName());
                orderHolder.addInvoiceOrderRejectReason(rejectReason);
                return;
            }
            PaymentRequestItem newItem = new PaymentRequestItem();
            newItem.setItemUnitPrice(discountValueToUse.bigDecimalValue());
            newItem.setItemTypeCode("DISC");
            newItem.setExtendedPrice(discountValueToUse);
            newItem.setPurapDocument(preqDocument);
            preqDocument.addItem(newItem);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Completed processing payment request items for discount");
        }
    }

    protected void populateItemDetails(PaymentRequestDocument preqDocument, ElectronicInvoiceOrderHolder orderHolder) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Populating invoice order items into the payment request document");
        }
        List preqItems = preqDocument.getItems();
        for (int i = 0; i < preqItems.size(); ++i) {
            PaymentRequestItem preqItem = (PaymentRequestItem)preqItems.get(i);
            this.processInvoiceItem(preqItem, orderHolder);
        }
        this.addMissingMappedItems(preqItems, orderHolder);
        this.removeEmptyItems(preqItems);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Successfully populated the invoice order items");
        }
    }

    protected void removeEmptyItems(List<PurApItem> preqItems) {
        for (int i = preqItems.size() - 1; i >= 0; --i) {
            PurApItem item = preqItems.get(i);
            if (!this.isNullOrZero(item.getItemUnitPrice()) || !this.isNullOrZero(item.getExtendedPrice())) continue;
            preqItems.remove(i);
        }
    }

    protected void addMissingMappedItems(List<PurApItem> preqItems, ElectronicInvoiceOrderHolder orderHolder) {
        PurchasingAccountsPayableDocument purapDoc = null;
        Integer purapDocIdentifier = null;
        List requiredItemTypeCodeList = this.createInvoiceRequiresItemTypeCodeList(orderHolder);
        if (ObjectUtils.isNotNull((Object)requiredItemTypeCodeList) && !requiredItemTypeCodeList.isEmpty()) {
            int i;
            for (i = 0; i < preqItems.size(); ++i) {
                if (requiredItemTypeCodeList.contains(preqItems.get(i).getItemTypeCode())) {
                    requiredItemTypeCodeList.remove(preqItems.get(i).getItemTypeCode());
                }
                purapDoc = (PurchasingAccountsPayableDocument)preqItems.get(i).getPurapDocument();
                purapDocIdentifier = preqItems.get(i).getPurapDocumentIdentifier();
            }
            if (ObjectUtils.isNotNull((Object)requiredItemTypeCodeList) && !requiredItemTypeCodeList.isEmpty()) {
                for (i = 0; i < requiredItemTypeCodeList.size(); ++i) {
                    PaymentRequestItem preqItem = new PaymentRequestItem();
                    preqItem.resetAccount();
                    preqItem.setPurapDocumentIdentifier(purapDocIdentifier);
                    preqItem.setPurapDocument(purapDoc);
                    preqItem.setItemTypeCode((String)requiredItemTypeCodeList.get(i));
                    this.processInvoiceItem(preqItem, orderHolder);
                    if (!ObjectUtils.isNotNull((Object)preqItem.getItemUnitPrice()) || preqItem.getItemUnitPrice() == BigDecimal.ZERO || !ObjectUtils.isNotNull((Object)preqItem.getExtendedPrice()) || preqItem.getExtendedPrice() == KualiDecimal.ZERO) continue;
                    preqItems.add(preqItem);
                }
            }
        }
    }

    protected List createInvoiceRequiresItemTypeCodeList(ElectronicInvoiceOrderHolder orderHolder) {
        ArrayList itemTypeCodeList = new ArrayList();
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_TAX, orderHolder);
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SHIPPING, orderHolder);
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING, orderHolder);
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DEPOSIT, orderHolder);
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DUE, orderHolder);
        this.addToListIfExists(itemTypeCodeList, ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT, orderHolder);
        return itemTypeCodeList;
    }

    protected void addToListIfExists(List itemTypeCodeList, String invoiceItemTypeCode, ElectronicInvoiceOrderHolder orderHolder) {
        String itemTypeCode = orderHolder.getKualiItemTypeCodeFromMappings(invoiceItemTypeCode);
        if (ObjectUtils.isNotNull((Object)itemTypeCode)) {
            itemTypeCodeList.add(itemTypeCode);
        }
    }

    protected void processInvoiceItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_ITEM, orderHolder)) {
            this.processAboveTheLineItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_TAX, orderHolder)) {
            this.processTaxItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SHIPPING, orderHolder)) {
            this.processShippingItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_SPECIAL_HANDLING, orderHolder)) {
            this.processSpecialHandlingItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DEPOSIT, orderHolder)) {
            this.processDepositItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DUE, orderHolder)) {
            this.processDueItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_DISCOUNT, orderHolder)) {
            this.processDiscountItem(preqItem, orderHolder);
        } else if (this.isItemValidForUpdation(preqItem.getItemTypeCode(), ElectronicInvoice.INVOICE_AMOUNT_TYPE_CODE_EXMT, orderHolder)) {
            this.processAboveTheLineItem(preqItem, orderHolder);
        }
    }

    protected void processAboveTheLineItem(PaymentRequestItem purapItem, ElectronicInvoiceOrderHolder orderHolder) {
        ElectronicInvoiceItemHolder itemHolder;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Processing above the line item");
        }
        if ((itemHolder = orderHolder.getItemByLineNumber(purapItem.getItemLineNumber())) == null) {
            LOG.info((Object)("Electronic Invoice does not have item with Ref Item Line number " + purapItem.getItemLineNumber()));
            return;
        }
        purapItem.setItemUnitPrice(itemHolder.getInvoiceItemUnitPrice());
        purapItem.setItemQuantity(new KualiDecimal(itemHolder.getInvoiceItemQuantity()));
        purapItem.setItemTaxAmount(new KualiDecimal(itemHolder.getTaxAmount()));
        purapItem.setItemCatalogNumber(itemHolder.getInvoiceItemCatalogNumber());
        purapItem.setItemDescription(itemHolder.getInvoiceItemDescription());
        if (itemHolder.getSubTotalAmount() != null && itemHolder.getSubTotalAmount().compareTo((AbstractKualiDecimal)KualiDecimal.ZERO) != 0) {
            purapItem.setExtendedPrice(itemHolder.getSubTotalAmount());
        } else if (purapItem.getItemQuantity() != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Item number " + purapItem.getItemLineNumber() + " needs calculation of extended " + "price from quantity " + purapItem.getItemQuantity() + " and unit cost " + purapItem.getItemUnitPrice()));
            }
            purapItem.setExtendedPrice((KualiDecimal)purapItem.getItemQuantity().multiply((AbstractKualiDecimal)new KualiDecimal(purapItem.getItemUnitPrice())));
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Item number " + purapItem.getItemLineNumber() + " has no quantity so extended price " + "equals unit price of " + purapItem.getItemUnitPrice()));
            }
            purapItem.setExtendedPrice(new KualiDecimal(purapItem.getItemUnitPrice()));
        }
    }

    protected void processSpecialHandlingItem(PaymentRequestItem purapItem, ElectronicInvoiceOrderHolder orderHolder) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Processing special handling item");
        }
        purapItem.addToUnitPrice(orderHolder.getInvoiceSpecialHandlingAmount());
        purapItem.addToExtendedPrice(new KualiDecimal(orderHolder.getInvoiceSpecialHandlingAmount()));
        String invoiceSpecialHandlingDescription = orderHolder.getInvoiceSpecialHandlingDescription();
        if (invoiceSpecialHandlingDescription == null && orderHolder.getInvoiceSpecialHandlingAmount() != null && BigDecimal.ZERO.compareTo(orderHolder.getInvoiceSpecialHandlingAmount()) != 0) {
            invoiceSpecialHandlingDescription = "Handling";
        }
        if (StringUtils.isNotEmpty((String)invoiceSpecialHandlingDescription)) {
            if (StringUtils.isEmpty((String)purapItem.getItemDescription())) {
                purapItem.setItemDescription(invoiceSpecialHandlingDescription);
            } else {
                purapItem.setItemDescription(purapItem.getItemDescription() + " - " + invoiceSpecialHandlingDescription);
            }
        }
    }

    protected void processTaxItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Processing Tax Item");
        }
        preqItem.addToUnitPrice(orderHolder.getTaxAmount());
        preqItem.addToExtendedPrice(new KualiDecimal(orderHolder.getTaxAmount()));
        if (StringUtils.isNotEmpty((String)orderHolder.getTaxDescription())) {
            if (StringUtils.isEmpty((String)preqItem.getItemDescription())) {
                preqItem.setItemDescription(orderHolder.getTaxDescription());
            } else {
                preqItem.setItemDescription(preqItem.getItemDescription() + " - " + orderHolder.getTaxDescription());
            }
        }
    }

    protected void processShippingItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Processing Shipping Item");
        }
        preqItem.addToUnitPrice(orderHolder.getInvoiceShippingAmount());
        preqItem.addToExtendedPrice(new KualiDecimal(orderHolder.getInvoiceShippingAmount()));
        if (StringUtils.isNotEmpty((String)orderHolder.getInvoiceShippingDescription())) {
            if (StringUtils.isEmpty((String)preqItem.getItemDescription())) {
                preqItem.setItemDescription(orderHolder.getInvoiceShippingDescription());
            } else {
                preqItem.setItemDescription(preqItem.getItemDescription() + " - " + orderHolder.getInvoiceShippingDescription());
            }
        }
    }

    protected void processDiscountItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Processing Discount Item");
        }
        preqItem.addToUnitPrice(orderHolder.getInvoiceDiscountAmount());
        preqItem.addToExtendedPrice(new KualiDecimal(orderHolder.getInvoiceDiscountAmount()));
    }

    protected void processDepositItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info((Object)"Processing Deposit Item");
        preqItem.addToUnitPrice(orderHolder.getInvoiceDepositAmount());
        preqItem.addToExtendedPrice(new KualiDecimal(orderHolder.getInvoiceDepositAmount()));
    }

    protected void processDueItem(PaymentRequestItem preqItem, ElectronicInvoiceOrderHolder orderHolder) {
        LOG.info((Object)"Processing Deposit Item");
        preqItem.addToUnitPrice(orderHolder.getInvoiceDueAmount());
        preqItem.addToExtendedPrice(new KualiDecimal(orderHolder.getInvoiceDueAmount()));
    }

    protected boolean isNullOrZero(BigDecimal value) {
        return ObjectUtils.isNull((Object)value) || value.compareTo(BigDecimal.ZERO) == 0;
    }

    protected boolean isNullOrZero(KualiDecimal value) {
        return ObjectUtils.isNull((Object)value) || value.isZero();
    }

    protected void setItemDefaultDescription(PaymentRequestItem preqItem) {
        if (StringUtils.isEmpty((String)preqItem.getItemDescription()) && !StringUtils.equals((String)"ITEM", (String)preqItem.getItemTypeCode()) && ArrayUtils.contains((Object[])PurapConstants.ElectronicInvoice.ITEM_TYPES_REQUIRES_DESCRIPTION, (Object)preqItem.getItemTypeCode())) {
            preqItem.setItemDescription(PurapConstants.ElectronicInvoice.DEFAULT_BELOW_LINE_ITEM_DESCRIPTION);
        }
    }

    protected boolean isItemValidForUpdation(String itemTypeCode, String invoiceItemTypeCode, ElectronicInvoiceOrderHolder orderHolder) {
        boolean isItemTypeAvailableInItemMapping = orderHolder.isItemTypeAvailableInItemMapping(invoiceItemTypeCode);
        String itemTypeCodeFromMappings = orderHolder.getKualiItemTypeCodeFromMappings(invoiceItemTypeCode);
        return isItemTypeAvailableInItemMapping && StringUtils.equals((String)itemTypeCodeFromMappings, (String)itemTypeCode);
    }

    protected String generatePREQDocumentDescription(PurchaseOrderDocument poDocument) {
        String description = "PO: " + poDocument.getPurapDocumentIdentifier() + " Vendor: " + poDocument.getVendorName() + " Electronic Invoice";
        return this.checkDescriptionLengthAndStripIfNeeded(description);
    }

    @NonTransactional
    public void validateInvoiceOrderValidForPREQCreation(ElectronicInvoiceOrderHolder orderHolder) {
        ElectronicInvoiceRejectReason rejectReason;
        List preqs;
        PurchaseOrderDocument poDoc;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Validiting ElectronicInvoice Order to make sure that it can be turned into a Payment Request document");
        }
        if ((poDoc = orderHolder.getPurchaseOrderDocument()) == null) {
            throw new RuntimeException("PurchaseOrder not available");
        }
        if (!orderHolder.isInvoiceNumberAcceptIndicatorEnabled() && (preqs = this.paymentRequestService.getPaymentRequestsByVendorNumberInvoiceNumber(poDoc.getVendorHeaderGeneratedIdentifier(), poDoc.getVendorDetailAssignedIdentifier(), orderHolder.getInvoiceNumber())) != null && preqs.size() > 0) {
            ElectronicInvoiceRejectReason rejectReason2 = this.matchingService.createRejectReason("EIDU", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason2, "invoiceFileNumber", "errors.reject.invoice.duplicate");
            return;
        }
        if (orderHolder.getInvoiceDate() == null) {
            rejectReason = this.matchingService.createRejectReason("IDIV", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceFileDate", "errors.reject.invoicedate.invalid");
            return;
        }
        if (orderHolder.getInvoiceDate().after(this.dateTimeService.getCurrentDate())) {
            rejectReason = this.matchingService.createRejectReason("IDAG", null, orderHolder.getFileName());
            orderHolder.addInvoiceOrderRejectReason(rejectReason, "invoiceFileDate", "errors.reject.invoicedate.greater");
            return;
        }
    }

    protected void moveFileList(Map filesToMove) {
        for (File fileToMove : filesToMove.keySet()) {
            boolean success = this.moveFile(fileToMove, (String)filesToMove.get(fileToMove));
            if (success) continue;
            String errorMessage = "File with name '" + fileToMove.getName() + "' could not be moved";
            throw new PurError(errorMessage);
        }
    }

    protected boolean moveFile(File fileForMove, String location) {
        File moveDir = new File(location);
        boolean success = fileForMove.renameTo(new File(moveDir, fileForMove.getName()));
        return success;
    }

    protected void deleteDoneFile(File invoiceFile) {
        File doneFile = new File(invoiceFile.getAbsolutePath().replace(this.electronicInvoiceInputFileType.getFileExtension(), ".done"));
        if (doneFile.exists()) {
            doneFile.delete();
        }
    }

    protected String getErrorMessages(Map<String, ArrayList> errorMap) {
        ArrayList errorMessages = null;
        ErrorMessage errorMessage = null;
        StringBuffer errorList = new StringBuffer("");
        String errorText = null;
        for (Map.Entry<String, ArrayList> errorEntry : errorMap.entrySet()) {
            errorMessages = errorEntry.getValue();
            for (int i = 0; i < errorMessages.size(); ++i) {
                errorMessage = (ErrorMessage)errorMessages.get(i);
                errorText = this.kualiConfigurationService.getPropertyValueAsString(errorMessage.getErrorKey());
                errorText = MessageFormat.format(errorText, errorMessage.getMessageParameters());
                errorList.append(errorText + "\n");
            }
        }
        return errorList.toString();
    }

    protected String getBaseDirName() {
        return this.electronicInvoiceInputFileType.getDirectoryPath() + File.separator;
    }

    @NonTransactional
    public String getRejectDirName() {
        return this.getBaseDirName() + "reject" + File.separator;
    }

    @NonTransactional
    public String getAcceptDirName() {
        return this.getBaseDirName() + "accept" + File.separator;
    }

    protected File getInvoiceFile(String fileName) {
        return new File(this.getBaseDirName() + fileName);
    }

    protected ElectronicInvoiceLoadSummary saveElectronicInvoiceLoadSummary(ElectronicInvoiceLoadSummary eils) {
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)eils);
        eils.refreshNonUpdateableReferences();
        return eils;
    }

    @NonTransactional
    public void setElectronicInvoiceInputFileType(ElectronicInvoiceInputFileType electronicInvoiceInputFileType) {
        this.electronicInvoiceInputFileType = electronicInvoiceInputFileType;
    }

    @NonTransactional
    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    @NonTransactional
    public void setElectronicInvoicingDao(ElectronicInvoicingDao electronicInvoicingDao) {
        this.electronicInvoicingDao = electronicInvoicingDao;
    }

    @NonTransactional
    public void setBatchInputFileService(BatchInputFileService batchInputFileService) {
        this.batchInputFileService = batchInputFileService;
    }

    @NonTransactional
    public void setElectronicInvoiceMatchingService(ElectronicInvoiceMatchingService matchingService) {
        this.matchingService = matchingService;
    }

    @NonTransactional
    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    @NonTransactional
    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    @NonTransactional
    public void setPaymentRequestService(PaymentRequestService paymentRequestService) {
        this.paymentRequestService = paymentRequestService;
    }

    @NonTransactional
    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    @NonTransactional
    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    @NonTransactional
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @NonTransactional
    public List<String> getRequiredDirectoryNames() {
        return new ArrayList<String>(){
            {
                this.add(ElectronicInvoiceHelperServiceImpl.this.getBaseDirName());
                this.add(ElectronicInvoiceHelperServiceImpl.this.getAcceptDirName());
                this.add(ElectronicInvoiceHelperServiceImpl.this.getRejectDirName());
            }
        };
    }
}

