/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoice;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceItem;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceOrder;
import org.kuali.kfs.module.purap.dataaccess.ElectronicInvoicingDao;
import org.kuali.kfs.module.purap.service.ElectronicInvoiceMappingService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ElectronicInvoiceMappingServiceImpl
implements ElectronicInvoiceMappingService {
    private static Logger LOG = Logger.getLogger(ElectronicInvoiceMappingServiceImpl.class);
    private ElectronicInvoicingDao electronicInvoicingDao;

    public void setElectronicInvoicingDao(ElectronicInvoicingDao electronicInvoicingDao) {
        this.electronicInvoicingDao = electronicInvoicingDao;
    }

    @Override
    public Map getDefaultItemMappingMap() {
        LOG.debug((Object)"getDefaultItemMappingMap() started");
        return this.electronicInvoicingDao.getDefaultItemMappingMap();
    }

    @Override
    public Map getItemMappingMap(Integer vendorHeaderId, Integer vendorDetailId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getItemMappingMap() started for vendor id " + vendorHeaderId + "-" + vendorDetailId));
        }
        return this.electronicInvoicingDao.getItemMappingMap(vendorHeaderId, vendorDetailId);
    }

    @Override
    public boolean acceptAmountType(String cxmlAmountType) {
        return cxmlAmountType != null && !cxmlAmountType.equalsIgnoreCase("");
    }

    @Override
    public String getInvoicePurchaseOrderID(ElectronicInvoiceOrder invoiceOrder) {
        return invoiceOrder.getOrderReferenceOrderID();
    }

    @Override
    public String getCatalogNumber(ElectronicInvoiceItem item) {
        return item.getReferenceItemIDSupplierPartID();
    }

    @Override
    public String getInvoiceCustomerNumber(ElectronicInvoice ei) {
        return null;
    }

    @Override
    public String checkCodeForValidCurrency(String code) {
        if (!this.isCodeValidCurrency(code)) {
            return code;
        }
        return null;
    }

    @Override
    public boolean isCodeValidCurrency(String code) {
        if (code != null) {
            for (int i = 0; i < CXML_VALID_CURRENCY_CODES.length; ++i) {
                String validCode = CXML_VALID_CURRENCY_CODES[i];
                if (!code.equalsIgnoreCase(validCode)) continue;
                return true;
            }
        }
        return false;
    }
}

