/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.Map;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.validation.PurapRuleTestBase;
import org.kuali.kfs.module.purap.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderChangeDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.validation.Validation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.document.validation.impl.CompositeValidation;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
public class PurchaseOrderCloseReopenVoidRuleTest
extends PurapRuleTestBase {
    private Map<String, Validation> validations;
    PurchaseOrderDocument po;

    protected void setUp() throws Exception {
        super.setUp();
        this.po = new PurchaseOrderDocument();
        this.validations = SpringContext.getBeansOfType(Validation.class);
    }

    protected void tearDown() throws Exception {
        this.validations = SpringContext.getBeansOfType(Validation.class);
        this.po = null;
        super.tearDown();
    }

    public void testNothing() {
    }

    private void savePO(PurchaseOrderDocument po) {
        po.prepareForSave();
        try {
            AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)po, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        }
        catch (Exception e) {
            throw new RuntimeException("Problems saving PO: " + e);
        }
    }

    public void PATCHFIX_testCloseValidate_Open() {
        this.po = PurchaseOrderChangeDocumentFixture.STATUS_OPEN.generatePO();
        this.savePO(this.po);
        GlobalVariables.getUserSession().setBackdoorUser("appleton");
        PaymentRequestDocument preq = PaymentRequestDocumentFixture.PREQ_FOR_PO_CLOSE_DOC.createPaymentRequestDocument();
        preq.setPurchaseOrderIdentifier(this.po.getPurapDocumentIdentifier());
        try {
            AccountingDocumentTestUtils.saveDocument((FinancialSystemTransactionalDocument)preq, (DocumentService)((DocumentService)SpringContext.getBean(DocumentService.class)));
        }
        catch (Exception e) {
            throw new RuntimeException("Problems saving PREQ: " + e);
        }
        GlobalVariables.getUserSession().clearBackdoorUser();
        CompositeValidation validation = (CompositeValidation)this.validations.get("PurchaseOrderClose-routeDocumentValidation");
        PurchaseOrderCloseReopenVoidRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.po)));
    }

    public void PATCHFIX_testReopenValidate_Closed() {
        this.po = PurchaseOrderChangeDocumentFixture.STATUS_CLOSED.generatePO();
        this.savePO(this.po);
        CompositeValidation validation = (CompositeValidation)this.validations.get("PurchaseOrderReopen-routeDocumentValidation");
        PurchaseOrderCloseReopenVoidRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.po)));
    }

    public void PATCHFIX_testVoidValidate_Open() {
        this.po = PurchaseOrderChangeDocumentFixture.STATUS_OPEN.generatePO();
        this.savePO(this.po);
        CompositeValidation validation = (CompositeValidation)this.validations.get("PurchaseOrderVoid-routeDocumentValidation");
        PurchaseOrderCloseReopenVoidRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.po)));
    }

    public void PATCHFIX_testVoidValidate_PendingPrint() {
        this.po = PurchaseOrderChangeDocumentFixture.STATUS_PENDING_PRINT.generatePO();
        this.savePO(this.po);
        CompositeValidation validation = (CompositeValidation)this.validations.get("PurchaseOrderVoid-routeDocumentValidation");
        PurchaseOrderCloseReopenVoidRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.po)));
    }
}

