/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.ArrayList;
import java.util.Map;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderVendorStipulation;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.module.purap.document.validation.PurapRuleTestBase;
import org.kuali.kfs.module.purap.document.validation.event.AttributedAddPurchasingAccountsPayableItemEvent;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderDocumentPreRules;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderEmptyItemWithAccountsValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderProcessVendorStipulationValidation;
import org.kuali.kfs.module.purap.document.validation.impl.PurchaseOrderSplitValidation;
import org.kuali.kfs.module.purap.fixture.AmountsLimitsFixture;
import org.kuali.kfs.module.purap.fixture.ItemAccountsFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEventBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.parke)
public class PurchaseOrderDocumentRuleTest
extends PurapRuleTestBase {
    private Map<String, GenericValidation> validations;
    PurchaseOrderDocument po;

    protected void setUp() throws Exception {
        super.setUp();
        this.po = new PurchaseOrderDocument();
        this.validations = SpringContext.getBeansOfType(GenericValidation.class);
    }

    protected void tearDown() throws Exception {
        this.validations = null;
        this.po = null;
        super.tearDown();
    }

    @ConfigureContext(session=UserNameFixture.parke)
    public void testValidateEmptyItemWithAccounts_NullItemWithAccount() {
        PurchaseOrderItem poItem = ItemAccountsFixture.NULL_ITEM_WITH_ACCOUNT.populateItem();
        PurchaseOrderEmptyItemWithAccountsValidation validation = (PurchaseOrderEmptyItemWithAccountsValidation)this.validations.get("PurchaseOrder-emptyItemWithAccountsValidation");
        validation.setItemForValidation(poItem);
        PurchaseOrderDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", (Document)this.po, (PurApItem)poItem)));
    }

    @ConfigureContext(session=UserNameFixture.parke)
    public void testValidateEmptyItemWithAccounts_WithItemWithAccount() {
        PurchaseOrderItem poItem = ItemAccountsFixture.WITH_QUANTITY_WITH_PRICE_WITH_ACCOUNT.populateItem();
        PurchaseOrderEmptyItemWithAccountsValidation validation = (PurchaseOrderEmptyItemWithAccountsValidation)this.validations.get("PurchaseOrder-emptyItemWithAccountsValidation");
        validation.setItemForValidation(poItem);
        PurchaseOrderDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", (Document)this.po, (PurApItem)poItem)));
    }

    @ConfigureContext(session=UserNameFixture.parke)
    public void testValidateEmptyItemWithAccounts_WithItemWithoutAccount() {
        PurchaseOrderItem poItem = ItemAccountsFixture.WITH_QUANTITY_WITH_PRICE_NULL_ACCOUNT.populateItem();
        PurchaseOrderEmptyItemWithAccountsValidation validation = (PurchaseOrderEmptyItemWithAccountsValidation)this.validations.get("PurchaseOrder-emptyItemWithAccountsValidation");
        validation.setItemForValidation(poItem);
        PurchaseOrderDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedAddPurchasingAccountsPayableItemEvent("", (Document)this.po, (PurApItem)poItem)));
    }

    public void testValidateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_ZeroAmountSmallLimit() {
        this.po = AmountsLimitsFixture.ZERO_AMOUNT_SMALL_LIMIT.populatePurchaseOrder();
        PurchaseOrderDocumentPreRules preRule = new PurchaseOrderDocumentPreRules();
        PurchaseOrderDocumentRuleTest.assertTrue((boolean)preRule.validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit((PurchasingDocument)this.po));
    }

    public void testValidateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_SmallAmountSmallLimit() {
        this.po = AmountsLimitsFixture.SMALL_AMOUNT_SMALL_LIMIT.populatePurchaseOrder();
        PurchaseOrderDocumentPreRules preRule = new PurchaseOrderDocumentPreRules();
        PurchaseOrderDocumentRuleTest.assertTrue((boolean)preRule.validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit((PurchasingDocument)this.po));
    }

    public void testValidateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit_LargeAmountSmallLimit() {
        this.po = AmountsLimitsFixture.LARGE_AMOUNT_SMALL_LIMIT.populatePurchaseOrder();
        PurchaseOrderDocumentPreRules preRule = new PurchaseOrderDocumentPreRules();
        PurchaseOrderDocumentRuleTest.assertFalse((boolean)preRule.validateTotalDollarAmountIsLessThanPurchaseOrderTotalLimit((PurchasingDocument)this.po));
    }

    public void testProcessVendorStipulationValidation_NotBlank() {
        this.po = new PurchaseOrderDocument();
        PurchaseOrderVendorStipulation stip = new PurchaseOrderVendorStipulation();
        stip.setVendorStipulationDescription("test");
        ArrayList<PurchaseOrderVendorStipulation> stipulations = new ArrayList<PurchaseOrderVendorStipulation>();
        stipulations.add(stip);
        this.po.setPurchaseOrderVendorStipulations(stipulations);
        PurchaseOrderProcessVendorStipulationValidation validation = (PurchaseOrderProcessVendorStipulationValidation)this.validations.get("PurchaseOrder-processVendorStipulationValidation-test");
        PurchaseOrderDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.po)));
    }

    public void testProcessVendorStipulationValidation_Blank() {
        this.po = new PurchaseOrderDocument();
        PurchaseOrderVendorStipulation stip = new PurchaseOrderVendorStipulation();
        stip.setVendorStipulationDescription("");
        ArrayList<PurchaseOrderVendorStipulation> stipulations = new ArrayList<PurchaseOrderVendorStipulation>();
        stipulations.add(stip);
        this.po.setPurchaseOrderVendorStipulations(stipulations);
        PurchaseOrderProcessVendorStipulationValidation validation = (PurchaseOrderProcessVendorStipulationValidation)this.validations.get("PurchaseOrder-processVendorStipulationValidation-test");
        PurchaseOrderDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.po)));
    }

    public void testValidateSplit_OneMovingOneRemaining() {
        this.po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        ((PurchaseOrderItem)this.po.getItems().get(0)).setMovingToSplit(true);
        PurchaseOrderSplitValidation validation = (PurchaseOrderSplitValidation)this.validations.get("PurchaseOrder-splitValidation-test");
        PurchaseOrderDocumentRuleTest.assertTrue((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.po)));
    }

    public void testValidateSplit_NoneMovingTwoRemaining() {
        this.po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        PurchaseOrderSplitValidation validation = (PurchaseOrderSplitValidation)this.validations.get("PurchaseOrder-splitValidation-test");
        PurchaseOrderDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.po)));
    }

    public void testValidateSplit_TwoMovingNoneRemaining() {
        this.po = PurchaseOrderDocumentFixture.PO_ONLY_REQUIRED_FIELDS_MULTI_ITEMS.createPurchaseOrderDocument();
        ((PurchaseOrderItem)this.po.getItems().get(0)).setMovingToSplit(true);
        ((PurchaseOrderItem)this.po.getItems().get(1)).setMovingToSplit(true);
        PurchaseOrderSplitValidation validation = (PurchaseOrderSplitValidation)this.validations.get("PurchaseOrder-splitValidation-test");
        PurchaseOrderDocumentRuleTest.assertFalse((boolean)validation.validate((AttributedDocumentEvent)new AttributedDocumentEventBase("", "", (Document)this.po)));
    }
}

