/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.util;

import java.math.BigDecimal;
import java.sql.Date;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.purap.util.ElectronicInvoiceUtils;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley, shouldCommitTransactions=false)
public class ElectronicInvoiceUtilsTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(ElectronicInvoiceUtilsTest.class);

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetDate() throws Exception {
        String invoiceDate = "2008-08-11T00:00:00-06:00";
        Date formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        System.out.println("Actual Date= " + invoiceDate + ", Converted Date = " + formattedDate);
        ElectronicInvoiceUtilsTest.assertEquals((String)"2008-08-11", (String)formattedDate.toString());
        invoiceDate = "2008-07-29";
        formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        System.out.println("Actual Date= " + invoiceDate + ", Converted Date = " + formattedDate);
        ElectronicInvoiceUtilsTest.assertEquals((String)"2008-07-29", (String)formattedDate.toString());
        invoiceDate = "2008-07-29T12:00:00";
        formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        System.out.println("Actual Date= " + invoiceDate + ", Converted Date = " + formattedDate);
        ElectronicInvoiceUtilsTest.assertEquals((String)"2008-07-29", (String)formattedDate.toString());
        invoiceDate = "2008-07-23T12:00:00-12:00";
        formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        System.out.println("Actual Date= " + invoiceDate + ", Converted Date = " + formattedDate);
        ElectronicInvoiceUtilsTest.assertEquals((String)"2008-07-23", (String)formattedDate.toString());
        invoiceDate = "07/23/2008";
        formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        System.out.println("Actual Date= " + invoiceDate + ", Converted Date = " + formattedDate + "  (KualiFormat check) ");
        ElectronicInvoiceUtilsTest.assertEquals((String)"2008-07-23", (String)formattedDate.toString());
        invoiceDate = "2008|07|23";
        formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        System.out.println("Actual Date= " + invoiceDate + ", Converted Date = " + formattedDate + "  (InvalidFormat check) ");
        ElectronicInvoiceUtilsTest.assertNull((Object)formattedDate);
        invoiceDate = null;
        formattedDate = ElectronicInvoiceUtils.getDate((String)invoiceDate);
        System.out.println("Actual Date= " + invoiceDate + ", Converted Date = " + formattedDate + "  (InvalidFormat check) ");
        ElectronicInvoiceUtilsTest.assertNull((Object)formattedDate);
        String rawInvoiceId = "A1!B2#C3$D4%";
        System.out.println("Processed InvId " + ElectronicInvoiceUtils.stripSplChars((String)rawInvoiceId));
        BigDecimal d1 = new BigDecimal("0");
        BigDecimal d2 = new BigDecimal("-50");
        System.out.println(d2.compareTo(d1) < 0);
        if (d2.compareTo(d1) < 0) {
            System.out.println("D2 greater");
        } else {
            System.out.println("D1 greater");
        }
    }
}

