/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class PurchasingAccountsPayableAccountTotalValidation
extends GenericValidation {
    private PurApItem itemForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal desiredAmount = this.itemForValidation.getTotalAmount() == null ? new BigDecimal(0) : this.itemForValidation.getTotalAmount().bigDecimalValue();
        for (PurApAccountingLine account : this.itemForValidation.getSourceAccountingLines()) {
            if (account.getAmount() != null) {
                totalAmount = totalAmount.add(account.getAmount().bigDecimalValue());
                continue;
            }
            totalAmount = totalAmount.add(BigDecimal.ZERO);
        }
        if (desiredAmount.compareTo(totalAmount) != 0) {
            GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "errors.item.accounting.total.amount", new String[]{this.itemForValidation.getItemIdentifierString(), desiredAmount.toString()});
            valid = false;
        }
        return valid;
    }

    public PurApItem getItemForValidation() {
        return this.itemForValidation;
    }

    public void setItemForValidation(PurApItem itemForValidation) {
        this.itemForValidation = itemForValidation;
    }
}

