/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestService;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.document.service.PurchaseOrderService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.vnd.VendorUtils;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;

public class VendorCreditMemoInitTabReferenceNumberValidation
extends GenericValidation {
    private PaymentRequestService paymentRequestService;
    private PurapService purapService;
    private PurchaseOrderService purchaseOrderService;
    private VendorService vendorService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean valid = true;
        VendorCreditMemoDocument cmDocument = (VendorCreditMemoDocument)event.getDocument();
        if (!(ObjectUtils.isNotNull((Object)cmDocument.getPaymentRequestIdentifier()) ^ StringUtils.isNotEmpty((String)cmDocument.getVendorNumber()) ^ ObjectUtils.isNotNull((Object)cmDocument.getPurchaseOrderIdentifier())) || ObjectUtils.isNotNull((Object)cmDocument.getPaymentRequestIdentifier()) && StringUtils.isNotEmpty((String)cmDocument.getVendorNumber()) && ObjectUtils.isNotNull((Object)cmDocument.getPurchaseOrderIdentifier())) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("purchaseOrderIdentifier", "errors.creditMemo.required.fields", new String[0]);
            valid = false;
        } else {
            VendorDetail vendor;
            String vendorNumber;
            Integer purchaseOrderID;
            Integer preqNumber = cmDocument.getPaymentRequestIdentifier();
            if (ObjectUtils.isNotNull((Object)preqNumber)) {
                PaymentRequestDocument preq = this.paymentRequestService.getPaymentRequestById(preqNumber);
                if (ObjectUtils.isNull((Object)preq)) {
                    GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("paymentRequestIdentifier", "errors.creditMemo.paymentRequest.invalid", new String[]{preqNumber.toString()});
                    valid = false;
                } else if ("In Process".equals(preq.getApplicationDocumentStatus()) || PurapConstants.PaymentRequestStatuses.CANCELLED_STATUSES.contains(preq.getApplicationDocumentStatus())) {
                    GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("paymentRequestIdentifier", "errors.creditMemo.paymentRequest.invalid.status", new String[]{preqNumber.toString()});
                    valid = false;
                }
            }
            if (ObjectUtils.isNotNull((Object)(purchaseOrderID = cmDocument.getPurchaseOrderIdentifier()))) {
                PurchaseOrderDocument purchaseOrder = this.purchaseOrderService.getCurrentPurchaseOrder(purchaseOrderID);
                if (ObjectUtils.isNull((Object)purchaseOrder)) {
                    GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.creditMemo.purchaseOrder.invalid", new String[]{purchaseOrderID.toString()});
                    valid = false;
                } else if (purchaseOrder.isPendingActionIndicator()) {
                    GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "error.invoice.purchaseOrder.pending.action", new String[0]);
                    valid &= false;
                } else if (!StringUtils.equals((String)purchaseOrder.getApplicationDocumentStatus(), (String)"Open") && !StringUtils.equals((String)purchaseOrder.getApplicationDocumentStatus(), (String)"Closed")) {
                    GlobalVariables.getMessageMap().putError("purchaseOrderIdentifier", "errors.creditMemo.purchaseOrder.invalid.status", new String[]{purchaseOrderID.toString()});
                    valid = false;
                }
            }
            if (StringUtils.isNotEmpty((String)(vendorNumber = cmDocument.getVendorNumber())) && ObjectUtils.isNull((Object)(vendor = this.vendorService.getVendorDetail(VendorUtils.getVendorHeaderId((String)vendorNumber), VendorUtils.getVendorDetailId((String)vendorNumber))))) {
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("vendorNumber", "errors.creditMemo.vendorNumber.invalid", new String[]{vendorNumber});
                valid = false;
            }
        }
        return valid;
    }

    public PaymentRequestService getPaymentRequestService() {
        return this.paymentRequestService;
    }

    public void setPaymentRequestService(PaymentRequestService paymentRequestService) {
        this.paymentRequestService = paymentRequestService;
    }

    public PurchaseOrderService getPurchaseOrderService() {
        return this.purchaseOrderService;
    }

    public void setPurchaseOrderService(PurchaseOrderService purchaseOrderService) {
        this.purchaseOrderService = purchaseOrderService;
    }

    public VendorService getVendorService() {
        return this.vendorService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }

    public PurapService getPurapService() {
        return this.purapService;
    }

    public void setPurapService(PurapService purapService) {
        this.purapService = purapService;
    }
}

