/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.ReceivingItemBase;
import org.kuali.kfs.module.purap.document.AccountsPayableDocumentBase;
import org.kuali.kfs.module.purap.document.LineItemReceivingDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.exception.PurError;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class LineItemReceivingItem
extends ReceivingItemBase {
    private KualiDecimal itemOrderedQuantity;
    private KualiDecimal itemReceivedPriorQuantity;
    private KualiDecimal itemReceivedToBeQuantity;
    private LineItemReceivingDocument lineItemReceivingDocument;
    private static Logger LOG = Logger.getLogger(AccountsPayableDocumentBase.class);

    public LineItemReceivingItem() {
    }

    public LineItemReceivingItem(LineItemReceivingDocument rld) {
        this.setDocumentNumber(rld.getDocumentNumber());
        this.setItemReceivedTotalQuantity(KualiDecimal.ZERO);
        this.setItemReturnedTotalQuantity(KualiDecimal.ZERO);
        this.setItemDamagedTotalQuantity(KualiDecimal.ZERO);
        this.setItemOriginalReceivedTotalQuantity(KualiDecimal.ZERO);
        this.setItemOriginalReturnedTotalQuantity(KualiDecimal.ZERO);
        this.setItemOriginalDamagedTotalQuantity(KualiDecimal.ZERO);
    }

    public LineItemReceivingItem(PurchaseOrderItem poi, LineItemReceivingDocument rld) {
        this.setDocumentNumber(rld.getDocumentNumber());
        this.setItemTypeCode(poi.getItemTypeCode());
        this.setPurchaseOrderIdentifier(rld.getPurchaseOrderIdentifier());
        this.setItemLineNumber(poi.getItemLineNumber());
        this.setItemCatalogNumber(poi.getItemCatalogNumber());
        this.setItemDescription(poi.getItemDescription());
        this.setItemOrderedQuantity(poi.getItemQuantity());
        this.setItemUnitOfMeasureCode(poi.getItemUnitOfMeasureCode());
        if (ObjectUtils.isNull((Object)poi.getItemReceivedTotalQuantity())) {
            this.setItemReceivedPriorQuantity(KualiDecimal.ZERO);
        } else {
            this.setItemReceivedPriorQuantity(poi.getItemReceivedTotalQuantity());
        }
        this.setItemReceivedToBeQuantity((KualiDecimal)this.getItemOrderedQuantity().subtract((AbstractKualiDecimal)this.getItemReceivedPriorQuantity()));
        this.setItemReceivedTotalQuantity(KualiDecimal.ZERO);
        this.setItemReturnedTotalQuantity(KualiDecimal.ZERO);
        this.setItemDamagedTotalQuantity(KualiDecimal.ZERO);
        this.setItemOriginalReceivedTotalQuantity(KualiDecimal.ZERO);
        this.setItemOriginalReturnedTotalQuantity(KualiDecimal.ZERO);
        this.setItemOriginalDamagedTotalQuantity(KualiDecimal.ZERO);
        this.setItemReasonAddedCode(null);
    }

    public PurchaseOrderItem getPurchaseOrderItem() {
        if (ObjectUtils.isNotNull((Object)this.getLineItemReceivingDocument()) && ObjectUtils.isNull((Object)this.getLineItemReceivingDocument())) {
            this.refreshReferenceObject("lineItemReceivingDocument");
        }
        if (this.getLineItemReceivingDocument() != null) {
            PurchaseOrderDocument po = this.getLineItemReceivingDocument().getPurchaseOrderDocument();
            PurchaseOrderItem poi = null;
            if (this.getItemType().isLineItemIndicator()) {
                List items = po.getItems();
                poi = (PurchaseOrderItem)items.get(this.getItemLineNumber() - 1);
            }
            if (poi != null) {
                return poi;
            }
            return null;
        }
        LOG.error((Object)"getPurchaseOrderItem() Returning null because paymentRequest object is null");
        throw new PurError("Receiving Line Object in Purchase Order item line number " + this.getItemLineNumber() + "or itemType " + this.getItemTypeCode() + " is null");
    }

    public KualiDecimal getItemOrderedQuantity() {
        return this.itemOrderedQuantity;
    }

    public void setItemOrderedQuantity(KualiDecimal itemOrderedQuantity) {
        this.itemOrderedQuantity = itemOrderedQuantity;
    }

    public LineItemReceivingDocument getLineItemReceivingDocument() {
        return this.lineItemReceivingDocument;
    }

    public void setLineItemReceivingDocument(LineItemReceivingDocument lineItemReceivingDocument) {
        this.lineItemReceivingDocument = lineItemReceivingDocument;
    }

    public KualiDecimal getItemReceivedPriorQuantity() {
        if (ObjectUtils.isNull((Object)this.itemReceivedPriorQuantity)) {
            this.setItemReceivedPriorQuantity(this.getPurchaseOrderItem().getItemReceivedTotalQuantity());
        }
        return this.itemReceivedPriorQuantity;
    }

    public void setItemReceivedPriorQuantity(KualiDecimal itemReceivedPriorQuantity) {
        this.itemReceivedPriorQuantity = itemReceivedPriorQuantity;
    }

    public KualiDecimal getItemReceivedToBeQuantity() {
        KualiDecimal toBeQuantity = (KualiDecimal)this.getItemOrderedQuantity().subtract((AbstractKualiDecimal)this.getItemReceivedPriorQuantity());
        if (toBeQuantity.isNegative()) {
            toBeQuantity = KualiDecimal.ZERO;
        }
        this.setItemReceivedToBeQuantity(toBeQuantity);
        return this.itemReceivedToBeQuantity;
    }

    public void setItemReceivedToBeQuantity(KualiDecimal itemReceivedToBeQuantity) {
        this.itemReceivedToBeQuantity = itemReceivedToBeQuantity;
    }

    public boolean isOrderedItem() {
        return StringUtils.isEmpty((String)this.getItemReasonAddedCode());
    }
}

