/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.dataaccess.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.purap.document.BulkReceivingDocument;
import org.kuali.kfs.module.purap.document.dataaccess.BulkReceivingDao;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BulkReceivingDaoOjb
extends PlatformAwareDaoBaseOjb
implements BulkReceivingDao {
    private static Logger LOG = Logger.getLogger(BulkReceivingDaoOjb.class);

    @Override
    public List<String> getDocumentNumbersByPurchaseOrderId(Integer id) {
        ArrayList<String> returnList = new ArrayList();
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)id);
        returnList = this.getDocumentNumbersOfBulkReceivingByCriteria(criteria, false);
        return returnList;
    }

    @Override
    public List<String> duplicateBillOfLadingNumber(Integer poId, String billOfLadingNumber) {
        ArrayList<String> returnList = new ArrayList();
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)poId);
        criteria.addEqualTo("shipmentBillOfLadingNumber", (Object)billOfLadingNumber);
        returnList = this.getDocumentNumbersOfBulkReceivingByCriteria(criteria, false);
        return returnList;
    }

    @Override
    public List<String> duplicatePackingSlipNumber(Integer poId, String packingSlipNumber) {
        ArrayList<String> returnList = new ArrayList();
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)poId);
        criteria.addEqualTo("shipmentPackingSlipNumber", (Object)packingSlipNumber);
        returnList = this.getDocumentNumbersOfBulkReceivingByCriteria(criteria, false);
        return returnList;
    }

    @Override
    public List<String> duplicateVendorDate(Integer poId, Date vendorDate) {
        ArrayList<String> returnList = new ArrayList();
        Criteria criteria = new Criteria();
        criteria.addEqualTo("purchaseOrderIdentifier", (Object)poId);
        criteria.addEqualTo("shipmentReceivedDate", (Object)vendorDate);
        returnList = this.getDocumentNumbersOfBulkReceivingByCriteria(criteria, false);
        return returnList;
    }

    protected List<String> getDocumentNumbersOfBulkReceivingByCriteria(Criteria criteria, boolean orderByAscending) {
        ArrayList<String> returnList = new ArrayList<String>();
        ReportQueryByCriteria rqbc = new ReportQueryByCriteria(BulkReceivingDocument.class, criteria);
        if (orderByAscending) {
            rqbc.addOrderByAscending("documentNumber");
        } else {
            rqbc.addOrderByDescending("documentNumber");
        }
        List bulkReceivingDocs = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)rqbc);
        for (BulkReceivingDocument bulkReceivingDoc : bulkReceivingDocs) {
            returnList.add(bulkReceivingDoc.getDocumentNumber());
        }
        return returnList;
    }
}

