/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.document.AccountsPayableDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.validation.impl.AccountsPayableDocumentPreRulesBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.web.format.CurrencyFormatter;

public class CreditMemoDocumentPreRules
extends AccountsPayableDocumentPreRulesBase {
    @Override
    public boolean doPrompts(Document document) {
        return super.doPrompts(document);
    }

    @Override
    public String getDocumentName() {
        return "Credit Memo";
    }

    @Override
    public String createInvoiceNoMatchQuestionText(AccountsPayableDocument accountsPayableDocument) {
        String questionText = super.createInvoiceNoMatchQuestionText(accountsPayableDocument);
        CurrencyFormatter cf = new CurrencyFormatter();
        VendorCreditMemoDocument cm = (VendorCreditMemoDocument)accountsPayableDocument;
        StringBuffer questionTextBuffer = new StringBuffer("");
        questionTextBuffer.append(questionText);
        questionTextBuffer.append("[br][br][b]Summary Detail Below[/b][br][br][table questionTable]");
        questionTextBuffer.append("[tr][td leftTd]Credit Memo Amount entered on start screen:[/td][td rightTd]").append((String)cf.format((Object)cm.getInitialAmount())).append("[/td][/tr]");
        questionTextBuffer.append("[tr][td leftTd]Total credit processed prior to restocking fee:[/td][td rightTd]").append((String)cf.format((Object)cm.getLineItemTotal())).append("[/td][/tr]");
        boolean salesTaxInd = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND");
        if (salesTaxInd) {
            questionTextBuffer.append("[tr][td leftTd]Grand Total Prior to Tax:[/td][td rightTd]").append((String)cf.format((Object)cm.getGrandPreTaxTotal())).append("[/td][/tr]");
            questionTextBuffer.append("[tr][td leftTd]Grand Total Tax:[/td][td rightTd]").append((String)cf.format((Object)cm.getGrandTaxAmount())).append("[/td][/tr]");
        }
        questionTextBuffer.append("[tr][td leftTd]Grand Total:[/td][td rightTd]").append((String)cf.format((Object)cm.getGrandTotal())).append("[/td][/tr][/table]");
        return questionTextBuffer.toString();
    }

    @Override
    protected boolean checkCAMSWarningStatus(PurchasingAccountsPayableDocument purapDocument) {
        return PurapConstants.CAMSWarningStatuses.CREDIT_MEMO_STATUS_WARNING_NO_CAMS_DATA.contains(purapDocument.getApplicationDocumentStatus());
    }

    @Override
    protected boolean validateInvoiceTotalsAreMismatched(AccountsPayableDocument accountsPayableDocument) {
        boolean mismatched = false;
        String[] excludeArray = new String[]{"DISC"};
        if (accountsPayableDocument.isUseTaxIndicator()) {
            if (accountsPayableDocument.getTotalPreTaxDollarAmountAllItems(excludeArray).compareTo((AbstractKualiDecimal)accountsPayableDocument.getInitialAmount()) != 0 && !accountsPayableDocument.isUnmatchedOverride()) {
                mismatched = true;
            }
        } else if (accountsPayableDocument.getTotalDollarAmountAllItems(excludeArray).compareTo((AbstractKualiDecimal)accountsPayableDocument.getInitialAmount()) != 0 && !accountsPayableDocument.isUnmatchedOverride()) {
            mismatched = true;
        }
        return mismatched;
    }
}

