/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.purap.businessobject.BulkReceivingView;
import org.kuali.kfs.module.purap.businessobject.CreditMemoView;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceLoadSummary;
import org.kuali.kfs.module.purap.businessobject.ElectronicInvoiceRejectView;
import org.kuali.kfs.module.purap.businessobject.LineItemReceivingView;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestView;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderView;
import org.kuali.kfs.module.purap.businessobject.RequisitionView;
import org.kuali.kfs.module.purap.document.BulkReceivingDocument;
import org.kuali.kfs.module.purap.document.ElectronicInvoiceRejectDocument;
import org.kuali.kfs.module.purap.document.LineItemReceivingDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PaymentRequestDocumentTest;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.service.PaymentRequestServiceTest;
import org.kuali.kfs.module.purap.fixture.BulkReceivingDocumentFixture;
import org.kuali.kfs.module.purap.fixture.CreditMemoDocumentFixture;
import org.kuali.kfs.module.purap.fixture.ElectronicInvoiceLoadSummaryFixture;
import org.kuali.kfs.module.purap.fixture.ElectronicInvoiceRejectDocumentFixture;
import org.kuali.kfs.module.purap.fixture.LineItemReceivingDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurchaseOrderDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.appleton)
public class RelatedViewsTest
extends KualiTestBase {
    private static Logger LOG = Logger.getLogger(PaymentRequestServiceTest.class);
    private DocumentService documentService;
    private PaymentRequestDocumentTest preqDocTest;
    private BusinessObjectService businessObjectService;

    public void setUp() throws Exception {
        super.setUp();
        if (null == this.documentService) {
            this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        if (null == this.businessObjectService) {
            this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        }
        if (null == this.preqDocTest) {
            this.preqDocTest = new PaymentRequestDocumentTest();
        }
    }

    private PurchaseOrderDocument createBasicPurchaseOrderDocument() throws Exception {
        return this.preqDocTest.createPurchaseOrderDocument(PurchaseOrderDocumentFixture.PO_APPROVAL_REQUIRED, false);
    }

    private PaymentRequestDocument createBasicPaymentRequestDocument() throws Exception {
        PaymentRequestDocument preq = this.preqDocTest.createPaymentRequestDocument(PaymentRequestDocumentFixture.PREQ_APPROVAL_REQUIRED, this.createBasicPurchaseOrderDocument(), true, new KualiDecimal[]{new KualiDecimal(100)});
        return preq;
    }

    private RequisitionDocument createBasicRequisitionDocument() throws Exception {
        return RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
    }

    public VendorCreditMemoDocument createBasicVendorCreditMemoDocument() throws Exception {
        return CreditMemoDocumentFixture.CM_ONLY_REQUIRED_FIELDS.createCreditMemoDocument();
    }

    private LineItemReceivingDocument createBasicLineItemReceivingDocument() throws Exception {
        LineItemReceivingDocument lird = LineItemReceivingDocumentFixture.EMPTY_LINE_ITEM_RECEIVING.createLineItemReceivingDocument();
        lird.populateReceivingLineFromPurchaseOrder(this.createBasicPurchaseOrderDocument());
        return lird;
    }

    private BulkReceivingDocument createBasicBulkReceivingDocument() throws Exception {
        return BulkReceivingDocumentFixture.SIMPLE_DOCUMENT.createBulkReceivingDocument();
    }

    private ElectronicInvoiceRejectDocument createBasicElectronicInvoiceRejectDocument() throws Exception {
        ElectronicInvoiceLoadSummary eils = ElectronicInvoiceLoadSummaryFixture.EILS_BASIC.createElectronicInvoiceLoadSummary();
        BusinessObjectService boService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        boService.save((PersistableBusinessObject)eils);
        this.changeCurrentUser(UserNameFixture.kfs);
        return ElectronicInvoiceRejectDocumentFixture.EIR_ONLY_REQUIRED_FIELDS.createElectronicInvoiceRejectDocument(eils);
    }

    public void testPaymentRequestView() throws Exception {
        PaymentRequestDocument preq = this.createBasicPaymentRequestDocument();
        preq.setApplicationDocumentStatus("Awaiting Fiscal Officer Approval");
        this.documentService.saveDocument((Document)preq);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("documentNumber", preq.getDocumentNumber());
        keys.put("purapDocumentIdentifier", preq.getPurapDocumentIdentifier().toString());
        PaymentRequestView prv = (PaymentRequestView)this.businessObjectService.findByPrimaryKey(PaymentRequestView.class, keys);
        RelatedViewsTest.assertEquals((String)preq.getApplicationDocumentStatus(), (String)prv.getApplicationDocumentStatus());
    }

    public void testPurchaseOrderView() throws Exception {
        PurchaseOrderDocument po = this.createBasicPurchaseOrderDocument();
        po.setApplicationDocumentStatus("Pending Amendment");
        this.documentService.saveDocument((Document)po);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("documentNumber", po.getDocumentNumber());
        keys.put("purapDocumentIdentifier", po.getPurapDocumentIdentifier().toString());
        PurchaseOrderView pov = (PurchaseOrderView)this.businessObjectService.findByPrimaryKey(PurchaseOrderView.class, keys);
        RelatedViewsTest.assertEquals((String)po.getApplicationDocumentStatus(), (String)pov.getApplicationDocumentStatus());
    }

    public void testVendorCreditMemoView() throws Exception {
        VendorCreditMemoDocument vcm = this.createBasicVendorCreditMemoDocument();
        vcm.setApplicationDocumentStatus("Awaiting AP Review");
        this.documentService.saveDocument((Document)vcm);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("documentNumber", vcm.getDocumentNumber());
        keys.put("purapDocumentIdentifier", vcm.getPurapDocumentIdentifier().toString());
        CreditMemoView cmv = (CreditMemoView)this.businessObjectService.findByPrimaryKey(CreditMemoView.class, keys);
        RelatedViewsTest.assertEquals((String)vcm.getApplicationDocumentStatus(), (String)cmv.getApplicationDocumentStatus());
    }

    public void testBulkReceivingView() throws Exception {
        BulkReceivingDocument br = this.createBasicBulkReceivingDocument();
        br.setApplicationDocumentStatus("Awaiting AP Review");
        this.documentService.saveDocument((Document)br);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("documentNumber", br.getDocumentNumber());
        BulkReceivingView brv = (BulkReceivingView)this.businessObjectService.findByPrimaryKey(BulkReceivingView.class, keys);
        RelatedViewsTest.assertEquals((String)br.getApplicationDocumentStatus(), (String)brv.getApplicationDocumentStatus());
    }

    public void testElectronicInvoiceRejectView() throws Exception {
        ElectronicInvoiceRejectDocument eirt = this.createBasicElectronicInvoiceRejectDocument();
        eirt.setApplicationDocumentStatus("Awaiting AP Review");
        this.documentService.saveDocument((Document)eirt);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("documentNumber", eirt.getDocumentNumber());
        ElectronicInvoiceRejectView erv = (ElectronicInvoiceRejectView)this.businessObjectService.findByPrimaryKey(ElectronicInvoiceRejectView.class, keys);
        RelatedViewsTest.assertEquals((String)eirt.getApplicationDocumentStatus(), (String)erv.getApplicationDocumentStatus());
    }

    public void testLineItemReceivingView() throws Exception {
        LineItemReceivingDocument lird = this.createBasicLineItemReceivingDocument();
        lird.setApplicationDocumentStatus("In Process");
        this.documentService.saveDocument((Document)lird);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("documentNumber", lird.getDocumentNumber());
        LineItemReceivingView lirv = (LineItemReceivingView)this.businessObjectService.findByPrimaryKey(LineItemReceivingView.class, keys);
        RelatedViewsTest.assertEquals((String)lird.getApplicationDocumentStatus(), (String)lirv.getApplicationDocumentStatus());
    }

    public void testRequisitionView() throws Exception {
        RequisitionDocument reqs = this.createBasicRequisitionDocument();
        reqs.setApplicationDocumentStatus("Awaiting Base Org Review");
        this.documentService.saveDocument((Document)reqs);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("documentNumber", reqs.getDocumentNumber());
        RequisitionView reqsv = (RequisitionView)this.businessObjectService.findByPrimaryKey(RequisitionView.class, keys);
        RelatedViewsTest.assertEquals((String)reqs.getApplicationDocumentStatus(), (String)reqsv.getApplicationDocumentStatus());
    }
}

