/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.fixture.PurapTestConstants;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public enum AmountsLimitsFixture {
    ZERO_AMOUNT_SMALL_LIMIT(PurapTestConstants.AmountsLimits.ZERO, PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT),
    SMALL_AMOUNT_SMALL_LIMIT(PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT, PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT),
    LARGE_AMOUNT_SMALL_LIMIT(PurapTestConstants.AmountsLimits.LARGE_POSITIVE_AMOUNT, PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT);

    private KualiDecimal totalAmount;
    private KualiDecimal poLimit;

    private AmountsLimitsFixture(KualiDecimal amt, KualiDecimal lim) {
        this.totalAmount = amt;
        this.poLimit = lim;
    }

    public RequisitionDocument populateRequisition() {
        RequisitionDocument req = new RequisitionDocument();
        RequisitionItem item = new RequisitionItem();
        item.setItemUnitPrice(new BigDecimal(this.totalAmount.doubleValue()));
        item.setItemQuantity(new KualiDecimal(1));
        item.setItemTypeCode("ITEM");
        item.refreshNonUpdateableReferences();
        item.getItemType().setQuantityBasedGeneralLedgerIndicator(true);
        ArrayList<RequisitionItem> items = new ArrayList<RequisitionItem>();
        items.add(item);
        req.setItems(items);
        req.setPurchaseOrderTotalLimit(this.poLimit);
        req.refreshNonUpdateableReferences();
        return req;
    }

    public PurchaseOrderDocument populatePurchaseOrder() {
        PurchaseOrderDocument po = new PurchaseOrderDocument();
        PurchaseOrderItem item = new PurchaseOrderItem();
        item.setItemUnitPrice(new BigDecimal(this.totalAmount.doubleValue()));
        item.setItemQuantity(new KualiDecimal(1));
        item.setItemTypeCode("ITEM");
        item.refreshNonUpdateableReferences();
        item.getItemType().setQuantityBasedGeneralLedgerIndicator(true);
        ArrayList<PurchaseOrderItem> items = new ArrayList<PurchaseOrderItem>();
        items.add(item);
        po.setItems(items);
        po.setPurchaseOrderTotalLimit(this.poLimit);
        po.fixItemReferences();
        return po;
    }
}

