/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import org.kuali.kfs.coa.document.validation.impl.MaintenancePreRulesBase;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ReceivingAddress;
import org.kuali.kfs.module.purap.document.service.ReceivingAddressService;
import org.kuali.kfs.sys.context.SpringContext;

public class ReceivingAddressPreRules
extends MaintenancePreRulesBase {
    protected boolean doCustomPreRules(MaintenanceDocument document) {
        boolean existOther;
        ReceivingAddress raOld = (ReceivingAddress)document.getOldMaintainableObject().getBusinessObject();
        ReceivingAddress raNew = (ReceivingAddress)document.getNewMaintainableObject().getBusinessObject();
        boolean isNew = document.isNew();
        boolean isEdit = document.isEdit();
        boolean wasActive = isEdit && raOld.isActive();
        boolean wasDefault = isEdit && raOld.isDefaultIndicator();
        boolean isActive = raNew.isActive();
        boolean isDefault = raNew.isDefaultIndicator();
        boolean stayActive = wasActive && isActive;
        boolean stayDefault = wasDefault && isDefault;
        boolean setActive = (isNew || !wasActive) && isActive;
        boolean unsetActive = wasActive && !isActive;
        boolean setDefault = (isNew || !wasDefault) && isDefault;
        boolean unsetDefault = wasDefault && !isDefault;
        int count = ((ReceivingAddressService)SpringContext.getBean(ReceivingAddressService.class)).countActiveByChartOrg(raNew.getChartOfAccountsCode(), raNew.getOrganizationCode());
        boolean bl = wasActive ? count > 1 : (existOther = count > 0);
        if (setActive && !isDefault && !existOther) {
            raNew.setDefaultIndicator(true);
        } else if (stayActive && setDefault || setActive && isDefault && existOther) {
            if (!super.askOrAnalyzeYesNoQuestion("confirm.change.dflt.rcvng.addr", "Setting this receiving address to be default will unset the current default address. Do you want to proceed?")) {
                this.abortRulesCheck();
            }
        } else {
            if (stayActive && unsetDefault) {
                this.putFieldError("defaultIndicator", "error.rcvng.addr.unset.dflt");
                this.abortRulesCheck();
                return false;
            }
            if (unsetActive && wasDefault && existOther) {
                this.putFieldError("active", "error.rcvng.addr.deactivate.dflt");
                this.abortRulesCheck();
                return false;
            }
        }
        return true;
    }

    protected void putFieldError(String propertyName, String errorConstant) {
        GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("document.newMaintainableObject." + propertyName, errorConstant, new String[0]);
    }
}

