/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.businessobject.PurApItemBase;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingCapitalAssetItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItem;
import org.kuali.kfs.module.purap.document.PurchasingDocument;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.kuali.kfs.vnd.businessobject.CommodityCode;

public abstract class PurchasingItemBase
extends PurApItemBase
implements PurchasingItem {
    private String purchasingCommodityCode;
    private CommodityCode commodityCode;
    private UnitOfMeasure itemUnitOfMeasure;

    @Override
    public boolean isConsideredEntered() {
        PurchaseOrderItem poi;
        if (this instanceof PurchaseOrderItem && !(poi = (PurchaseOrderItem)this).isItemActiveIndicator()) {
            return false;
        }
        return !this.getItemType().isAdditionalChargeIndicator() || !ObjectUtils.isNull((Object)this.getItemUnitPrice()) || !StringUtils.isBlank((String)this.getItemDescription()) || !this.getSourceAccountingLines().isEmpty();
    }

    public boolean isEmpty() {
        return !StringUtils.isNotEmpty((String)this.getItemUnitOfMeasureCode()) && !StringUtils.isNotEmpty((String)this.getItemCatalogNumber()) && !StringUtils.isNotEmpty((String)this.getItemDescription()) && !StringUtils.isNotEmpty((String)this.getItemAuxiliaryPartIdentifier()) && !ObjectUtils.isNotNull((Object)this.getItemQuantity()) && (!ObjectUtils.isNotNull((Object)this.getItemUnitPrice()) || this.getItemUnitPrice().compareTo(BigDecimal.ZERO) == 0) && this.isAccountListEmpty();
    }

    public boolean isItemDetailEmpty() {
        boolean empty = true;
        empty &= ObjectUtils.isNull((Object)this.getItemQuantity()) || StringUtils.isEmpty((String)this.getItemQuantity().toString());
        empty &= StringUtils.isEmpty((String)this.getItemUnitOfMeasureCode());
        empty &= StringUtils.isEmpty((String)this.getItemCatalogNumber());
        empty &= StringUtils.isEmpty((String)this.getItemDescription());
        return empty &= ObjectUtils.isNull((Object)this.getItemUnitPrice()) || this.getItemUnitPrice().compareTo(BigDecimal.ZERO) == 0;
    }

    public CommodityCode getCommodityCode() {
        if (ObjectUtils.isNull((Object)this.commodityCode) || !StringUtils.equalsIgnoreCase((String)this.commodityCode.getPurchasingCommodityCode(), (String)this.getPurchasingCommodityCode())) {
            this.refreshReferenceObject("commodityCode");
        }
        return this.commodityCode;
    }

    public void setCommodityCode(CommodityCode commodityCode) {
        this.commodityCode = commodityCode;
    }

    public String getPurchasingCommodityCode() {
        return this.purchasingCommodityCode;
    }

    public void setPurchasingCommodityCode(String purchasingCommodityCode) {
        this.purchasingCommodityCode = StringUtils.isNotBlank((String)purchasingCommodityCode) ? purchasingCommodityCode.toUpperCase() : purchasingCommodityCode;
    }

    @Override
    public PurchasingCapitalAssetItem getPurchasingCapitalAssetItem() {
        PurchasingDocument pd = (PurchasingDocument)this.getPurapDocument();
        if (this.getItemIdentifier() != null) {
            return pd.getPurchasingCapitalAssetItem(this.getItemIdentifier());
        }
        return null;
    }

    public UnitOfMeasure getItemUnitOfMeasure() {
        if (ObjectUtils.isNull((Object)this.itemUnitOfMeasure) || !StringUtils.equalsIgnoreCase((String)this.itemUnitOfMeasure.getItemUnitOfMeasureCode(), (String)this.getItemUnitOfMeasureCode())) {
            this.refreshReferenceObject("itemUnitOfMeasure");
        }
        return this.itemUnitOfMeasure;
    }

    public void setItemUnitOfMeasure(UnitOfMeasure itemUnitOfMeasure) {
        this.itemUnitOfMeasure = itemUnitOfMeasure;
    }

    public boolean isNewItemForAmendment() {
        return false;
    }
}

