/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.rest;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.kuali.kfs.module.purap.service.MyOrdersService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.web.WebUtilities;
import org.kuali.rice.kim.api.identity.Person;

@Path(value="/myorders")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MyOrdersResource {
    protected static volatile MyOrdersService myOrdersService;

    @GET
    public Response getLatestOrdersForCurrentUser(@DefaultValue(value="4") @QueryParam(value="count") Integer count, @Context HttpServletRequest request) {
        Person user = WebUtilities.retrieveUserSession((HttpServletRequest)request).getPerson();
        List<Map<String, Object>> latestOrders = this.getMyOrdersService().getLatestOrders(user, count);
        return Response.ok(latestOrders).build();
    }

    protected MyOrdersService getMyOrdersService() {
        if (myOrdersService == null) {
            myOrdersService = (MyOrdersService)SpringContext.getBean(MyOrdersService.class);
        }
        return myOrdersService;
    }
}

