/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.authorization;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.document.authorization.PurchasingAccountsPayableDocumentPresentationController;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemWorkflowHelperService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.kew.api.WorkflowDocument;

public class VendorCreditMemoDocumentPresentationController
extends PurchasingAccountsPayableDocumentPresentationController {
    public boolean canSave(Document document) {
        VendorCreditMemoDocument vendorCreditMemoDocument = (VendorCreditMemoDocument)document;
        if (StringUtils.equals((String)vendorCreditMemoDocument.getApplicationDocumentStatus(), (String)"Initiated")) {
            return false;
        }
        if (this.canEditPreExtraction(vendorCreditMemoDocument)) {
            return true;
        }
        return super.canSave(document);
    }

    public boolean canReload(Document document) {
        VendorCreditMemoDocument vendorCreditMemoDocument = (VendorCreditMemoDocument)document;
        if (StringUtils.equals((String)vendorCreditMemoDocument.getApplicationDocumentStatus(), (String)"Initiated")) {
            return false;
        }
        if (this.canEditPreExtraction(vendorCreditMemoDocument)) {
            return true;
        }
        return super.canReload(document);
    }

    public boolean canCancel(Document document) {
        return false;
    }

    public boolean canDisapprove(Document document) {
        return false;
    }

    @Override
    public boolean canEdit(Document document) {
        if (((PurapService)SpringContext.getBean(PurapService.class)).isFullDocumentEntryCompleted((VendorCreditMemoDocument)document)) {
            return false;
        }
        return super.canEdit(document);
    }

    public Set<String> getEditModes(Document document) {
        boolean salesTaxInd;
        Set editModes = super.getEditModes(document);
        VendorCreditMemoDocument vendorCreditMemoDocument = (VendorCreditMemoDocument)document;
        WorkflowDocument workflowDocument = vendorCreditMemoDocument.getFinancialSystemDocumentHeader().getWorkflowDocument();
        if (this.canCancel(vendorCreditMemoDocument)) {
            editModes.add("processorCancel");
        }
        if (this.canHold(vendorCreditMemoDocument)) {
            editModes.add("requestVendorCreditMemoHold");
        }
        if (this.canRemoveHold(vendorCreditMemoDocument)) {
            editModes.add("vendorCreditMemoHoldRemoval");
        }
        if (((PurapService)SpringContext.getBean(PurapService.class)).isFullDocumentEntryCompleted(vendorCreditMemoDocument)) {
            editModes.add("fullDocumentEntryCompleted");
        } else if (ObjectUtils.isNotNull((Object)vendorCreditMemoDocument.getPurchaseOrderDocument()) && !vendorCreditMemoDocument.isSourceVendor() && "Closed".equals(vendorCreditMemoDocument.getPurchaseOrderDocument().getApplicationDocumentStatus())) {
            editModes.add("allowReopenPurchaseOrder");
        }
        if (StringUtils.equals((String)vendorCreditMemoDocument.getApplicationDocumentStatus(), (String)"Initiated")) {
            editModes.add("displayInitTab");
        }
        if (this.canEditPreExtraction(vendorCreditMemoDocument)) {
            editModes.add("editPreExtract");
        }
        if (!vendorCreditMemoDocument.isSourceDocumentPaymentRequest()) {
            editModes.add("lockVendorEntry");
        }
        if (salesTaxInd = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.PURCHASING_DOCUMENT.class, "ENABLE_SALES_TAX_IND").booleanValue()) {
            editModes.add("purapTaxEnabled");
            if (vendorCreditMemoDocument.isUseTaxIndicator()) {
                editModes.add("lockTaxAmountEntry");
            } else {
                editModes.add("clearAllTaxes");
            }
        }
        if (vendorCreditMemoDocument.isExtracted()) {
            editModes.remove("bankEntry");
        }
        return editModes;
    }

    protected boolean canHold(VendorCreditMemoDocument cmDocument) {
        return !cmDocument.isHoldIndicator() && !cmDocument.isExtracted() && !PurapConstants.CreditMemoStatuses.STATUSES_DISALLOWING_HOLD.contains(cmDocument.getApplicationDocumentStatus());
    }

    protected boolean canRemoveHold(VendorCreditMemoDocument cmDocument) {
        return cmDocument.isHoldIndicator();
    }

    protected boolean canCancel(VendorCreditMemoDocument cmDocument) {
        return !PurapConstants.CreditMemoStatuses.CANCELLED_STATUSES.contains(cmDocument.getApplicationDocumentStatus()) && !cmDocument.isExtracted() && !cmDocument.isHoldIndicator();
    }

    protected boolean canEditPreExtraction(VendorCreditMemoDocument vendorCreditMemoDocument) {
        return !vendorCreditMemoDocument.isExtracted() && !((FinancialSystemWorkflowHelperService)SpringContext.getBean(FinancialSystemWorkflowHelperService.class)).isAdhocApprovalRequestedForPrincipal(vendorCreditMemoDocument.getFinancialSystemDocumentHeader().getWorkflowDocument(), GlobalVariables.getUserSession().getPrincipalId()) && !PurapConstants.CreditMemoStatuses.CANCELLED_STATUSES.contains(vendorCreditMemoDocument.getApplicationDocumentStatus());
    }
}

