/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.fixture;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.module.purap.PurapConstants;
import org.kuali.kfs.module.purap.businessobject.CreditMemoAccount;
import org.kuali.kfs.module.purap.businessobject.CreditMemoItem;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestAccount;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchasingItem;
import org.kuali.kfs.module.purap.businessobject.RequisitionAccount;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.VendorCreditMemoDocument;
import org.kuali.kfs.module.purap.fixture.CreditMemoDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PaymentRequestDocumentFixture;
import org.kuali.kfs.module.purap.fixture.PurApAccountingLineFixture;
import org.kuali.kfs.module.purap.fixture.PurapTestConstants;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionItemFixture;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.fixture.AccountingLineFixture;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public enum PurapAccountingServiceFixture {
    PREQ_PRORATION_ONE_ACCOUNT(PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT, PurapConstants.PRORATION_SCALE, PaymentRequestAccount.class, PurApAccountingLineFixture.BASIC_ACCOUNT_1),
    PREQ_PRORATION_TWO_ACCOUNTS(PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT, PurapConstants.PRORATION_SCALE, PaymentRequestAccount.class, PurApAccountingLineFixture.ACCOUNT_50_PERCENT, PurApAccountingLineFixture.ACCOUNT_50_PERCENT),
    PREQ_PRORATION_THIRDS(PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT, PurapConstants.PRORATION_SCALE, PaymentRequestAccount.class, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD_PLUS_ONE_HUNDREDTH),
    PREQ_PRORATION_ONE_ACCOUNT_ZERO_TOTAL(PurapTestConstants.AmountsLimits.ZERO, PurapConstants.PRORATION_SCALE, PaymentRequestAccount.class, PurApAccountingLineFixture.BASIC_ACCOUNT_1),
    PREQ_PRORATION_TWO_ACCOUNTS_ZERO_TOTAL(PurapTestConstants.AmountsLimits.ZERO, PurapConstants.PRORATION_SCALE, PaymentRequestAccount.class, PurApAccountingLineFixture.ACCOUNT_50_PERCENT, PurApAccountingLineFixture.ACCOUNT_50_PERCENT),
    PREQ_PRORATION_THIRDS_ZERO_TOTAL(PurapTestConstants.AmountsLimits.ZERO, PurapConstants.PRORATION_SCALE, PaymentRequestAccount.class, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD_PLUS_ONE_HUNDREDTH),
    REQ_PRORATION_ONE_ACCOUNT(PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT, PurapConstants.PRORATION_SCALE, RequisitionAccount.class, PurApAccountingLineFixture.BASIC_ACCOUNT_1),
    REQ_PRORATION_TWO_ACCOUNTS(PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT, PurapConstants.PRORATION_SCALE, RequisitionAccount.class, PurApAccountingLineFixture.ACCOUNT_50_PERCENT, PurApAccountingLineFixture.ACCOUNT_50_PERCENT),
    REQ_PRORATION_THIRDS(PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT, PurapConstants.PRORATION_SCALE, RequisitionAccount.class, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD_PLUS_ONE_HUNDREDTH),
    REQ_PRORATION_ONE_ACCOUNT_ZERO_TOTAL(PurapTestConstants.AmountsLimits.ZERO, PurapConstants.PRORATION_SCALE, RequisitionAccount.class, PurApAccountingLineFixture.BASIC_ACCOUNT_1),
    REQ_PRORATION_TWO_ACCOUNTS_ZERO_TOTAL(PurapTestConstants.AmountsLimits.ZERO, PurapConstants.PRORATION_SCALE, RequisitionAccount.class, PurApAccountingLineFixture.ACCOUNT_50_PERCENT, PurApAccountingLineFixture.ACCOUNT_50_PERCENT),
    REQ_PRORATION_THIRDS_ZERO_TOTAL(PurapTestConstants.AmountsLimits.ZERO, PurapConstants.PRORATION_SCALE, RequisitionAccount.class, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD, PurApAccountingLineFixture.ACCOUNT_ONE_THIRD_PLUS_ONE_HUNDREDTH),
    CREDIT_MEMO_ONE_ACCOUNT(PurapTestConstants.AmountsLimits.SMALL_POSITIVE_AMOUNT, PurapConstants.PRORATION_SCALE, CreditMemoAccount.class, PurApAccountingLineFixture.BASIC_ACCOUNT_1),
    REQ_SUMMARY_ONE_ITEM_ONE_ACCOUNT(new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_1}, new AccountingLineFixture[]{AccountingLineFixture.PURAP_LINE1}, new Integer[]{0}),
    REQ_SUMMARY_ONE_ITEM_TWO_ACCOUNTS(new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_1}, new AccountingLineFixture[]{AccountingLineFixture.PURAP_LINE1, AccountingLineFixture.PURAP_LINE2}, new Integer[]{0, 0}),
    REQ_SUMMARY_TWO_ITEMS_ONE_ACCOUNT(new RequisitionItemFixture[]{RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_1, RequisitionItemFixture.REQ_QTY_UNRESTRICTED_ITEM_2}, new AccountingLineFixture[]{AccountingLineFixture.PURAP_LINE1}, new Integer[]{0, 1});

    KualiDecimal totalAmount;
    Integer percentScale;
    Class accountClass;
    List<SourceAccountingLine> sourceAccountingLineList = new ArrayList<SourceAccountingLine>();
    List<PurApAccountingLine> purApAccountingLineList = new ArrayList<PurApAccountingLine>();
    AccountingLineFixture[] accountingLineFixture = new AccountingLineFixture[]{AccountingLineFixture.PURAP_LINE1, AccountingLineFixture.PURAP_LINE2, AccountingLineFixture.PURAP_LINE3};
    List<PurApItem> items = new ArrayList<PurApItem>();

    private PurapAccountingServiceFixture(KualiDecimal totalAmount, Integer percentScale, Class accountClass, PurApAccountingLineFixture ... purApAcctLineFixtures) {
        this.totalAmount = totalAmount;
        this.percentScale = percentScale;
        this.accountClass = accountClass;
        for (int i = 0; i < purApAcctLineFixtures.length; ++i) {
            PurApAccountingLineFixture purApAcctLineFixture = purApAcctLineFixtures[i];
            PurApAccountingLine purApAcctLine = purApAcctLineFixture.createPurApAccountingLine(accountClass, this.accountingLineFixture[i]);
            BigDecimal pct = purApAcctLine.getAccountLinePercent();
            pct = pct.divide(new BigDecimal(100));
            purApAcctLine.setAmount((KualiDecimal)totalAmount.multiply((AbstractKualiDecimal)new KualiDecimal(pct.setScale(2, 4))));
            this.purApAccountingLineList.add(purApAcctLine);
            this.sourceAccountingLineList.add(purApAcctLine.generateSourceAccountingLine());
        }
    }

    private PurapAccountingServiceFixture(RequisitionItemFixture[] itemFixtures, AccountingLineFixture[] acctLineFixtures, Integer[] positions) {
        for (RequisitionItemFixture itemFixture : itemFixtures) {
            PurchasingItem item = itemFixture.createRequisitionItem();
            this.items.add((PurApItem)item);
        }
        for (int i = 0; i < acctLineFixtures.length; ++i) {
            AccountingLineFixture acctLineFixture = acctLineFixtures[i];
            SourceAccountingLine sourceLine = null;
            try {
                sourceLine = acctLineFixture.createSourceAccountingLine();
                this.sourceAccountingLineList.add(sourceLine);
                PurApAccountingLine purApAccountingLine = PurApAccountingLineFixture.BASIC_ACCOUNT_1.createPurApAccountingLine(RequisitionAccount.class, acctLineFixture);
                if (positions[i] == null) continue;
                this.items.get(positions[i]).getSourceAccountingLines().add(purApAccountingLine);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private RequisitionDocument augmentRequisitionDocument(RequisitionDocument req) {
        ArrayList<RequisitionItem> augmentedItems = new ArrayList<RequisitionItem>();
        for (RequisitionItem item : req.getItems()) {
            item.setTotalAmount(this.totalAmount);
            for (PurApAccountingLine purApAccountingLine : this.purApAccountingLineList) {
                purApAccountingLine.setAmount((KualiDecimal)((KualiDecimal)item.calculateExtendedPrice().multiply((AbstractKualiDecimal)new KualiDecimal(purApAccountingLine.getAccountLinePercent()))).divide((AbstractKualiDecimal)new KualiDecimal(100)));
            }
            item.setSourceAccountingLines(this.purApAccountingLineList);
            augmentedItems.add(item);
        }
        req.setItems(augmentedItems);
        return req;
    }

    public RequisitionDocument generateRequisitionDocument_OneItem() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocument();
        return this.augmentRequisitionDocument(req);
    }

    public RequisitionDocument generateRequisitionDocument_TwoItems() {
        RequisitionDocument req = RequisitionDocumentFixture.REQ_TWO_ITEMS.createRequisitionDocument();
        return this.augmentRequisitionDocument(req);
    }

    private PaymentRequestDocument augmentPaymentRequestDocument(PaymentRequestDocument preq) {
        ArrayList<PaymentRequestItem> augmentedItems = new ArrayList<PaymentRequestItem>();
        for (PaymentRequestItem item : preq.getItems()) {
            item.setTotalAmount(this.totalAmount);
            item.setSourceAccountingLines(this.purApAccountingLineList);
            augmentedItems.add(item);
        }
        preq.setItems(augmentedItems);
        return preq;
    }

    public PaymentRequestDocument generatePaymentRequestDocument_OneItem() {
        PaymentRequestDocument preq = PaymentRequestDocumentFixture.PREQ_ONLY_REQUIRED_FIELDS.createPaymentRequestDocument();
        return this.augmentPaymentRequestDocument(preq);
    }

    public PaymentRequestDocument generatePaymentRequestDocument_TwoItems() {
        PaymentRequestDocument preq = PaymentRequestDocumentFixture.PREQ_TWO_ITEM.createPaymentRequestDocument();
        return this.augmentPaymentRequestDocument(preq);
    }

    private VendorCreditMemoDocument augmentVendorCreditMemoDocument(VendorCreditMemoDocument vcm) {
        ArrayList<CreditMemoItem> augmentedItems = new ArrayList<CreditMemoItem>();
        for (CreditMemoItem item : vcm.getItems()) {
            item.setTotalAmount(this.totalAmount);
            item.setSourceAccountingLines(this.purApAccountingLineList);
            augmentedItems.add(item);
        }
        vcm.setItems(augmentedItems);
        return vcm;
    }

    public VendorCreditMemoDocument generateVendorCreditMemoDocument_OneItem() {
        VendorCreditMemoDocument vcm = CreditMemoDocumentFixture.CM_ONLY_REQUIRED_FIELDS.createCreditMemoDocument();
        return this.augmentVendorCreditMemoDocument(vcm);
    }

    public KualiDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(KualiDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Integer getPercentScale() {
        return this.percentScale;
    }

    public void setPercentScale(Integer percentScale) {
        this.percentScale = percentScale;
    }

    public Class getAccountClass() {
        return this.accountClass;
    }

    public void setAccountClass(Class accountClass) {
        this.accountClass = accountClass;
    }

    public List<SourceAccountingLine> getSourceAccountingLineList() {
        return this.sourceAccountingLineList;
    }

    public void setSourceAccountingLineList(List<SourceAccountingLine> sourceAccountingLineList) {
        this.sourceAccountingLineList = sourceAccountingLineList;
    }

    public List<PurApAccountingLine> getPurApAccountingLineList() {
        return this.purApAccountingLineList;
    }

    public void setPurApAccountingLineList(List<PurApAccountingLine> purApAccountingLineList) {
        this.purApAccountingLineList = purApAccountingLineList;
    }

    public List<PurApItem> getItems() {
        return this.items;
    }

    public void setItems(List<PurApItem> items) {
        this.items = items;
    }
}

