/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.validation.impl;

import java.util.List;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.RequisitionItem;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.RequisitionService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class RequisitionAccountingLineExistsValidation
extends GenericValidation {
    private RequisitionService requisitionService;

    public boolean validate(AttributedDocumentEvent event) {
        String chart;
        String org;
        RequisitionDocument doc = (RequisitionDocument)event.getDocument();
        List<RequisitionItem> itemsMissingAccountingLines = doc.getListOfItemsMissingAccountingLines();
        if (!itemsMissingAccountingLines.isEmpty() && !this.requisitionService.hasContentReviewer(org = doc.getOrganizationCode(), chart = doc.getChartOfAccountsCode())) {
            for (RequisitionItem item : itemsMissingAccountingLines) {
                GlobalVariables.getMessageMap().putError("document.item*,newPurchasingItemLine*,itemQuantity,document.grandTotal,accountDistributionnewSourceLine*,distributePurchasingCommodityCode,accountNumber*,chartOfAccountsCode*", "message.requisition.no.accounting.lines", new String[]{item.getItemIdentifierString()});
            }
            return false;
        }
        return true;
    }

    public void setRequisitionService(RequisitionService reqs) {
        this.requisitionService = reqs;
    }

    public RequisitionService getRequisitionService() {
        return this.requisitionService;
    }
}

