/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderSensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveData;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignment;
import org.kuali.kfs.module.purap.businessobject.SensitiveDataAssignmentDetail;
import org.kuali.kfs.module.purap.dataaccess.SensitiveDataDao;
import org.kuali.kfs.module.purap.document.dataaccess.PurchaseOrderDao;
import org.kuali.kfs.module.purap.service.SensitiveDataService;
import org.kuali.kfs.sys.context.SpringContext;

public class SensitiveDataServiceImpl
implements SensitiveDataService {
    private static Logger LOG = Logger.getLogger(SensitiveDataServiceImpl.class);
    private SensitiveDataDao sensitiveDataDao;
    private PurchaseOrderDao purchaseOrderDao;

    public void setPurchaseOrderDao(PurchaseOrderDao purchaseOrderDao) {
        this.purchaseOrderDao = purchaseOrderDao;
    }

    public SensitiveDataDao getSensitiveDataDao() {
        return this.sensitiveDataDao;
    }

    public void setSensitiveDataDao(SensitiveDataDao sensitiveDataDao) {
        this.sensitiveDataDao = sensitiveDataDao;
    }

    @Override
    public SensitiveData getSensitiveDataByCode(String sensitiveDataCode) {
        LOG.debug((Object)"getSensitiveDataByCode(String) started");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("sensitiveDataCode", sensitiveDataCode);
        return (SensitiveData)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(SensitiveData.class, primaryKeys);
    }

    @Override
    public List<SensitiveData> getAllSensitiveDatas() {
        LOG.debug((Object)"getSensitiveDataByPoId(Integer) started");
        ArrayList<SensitiveData> sds = new ArrayList<SensitiveData>();
        Collection sdColl = ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findAll(SensitiveData.class);
        for (Object sd : sdColl) {
            sds.add((SensitiveData)((Object)sd));
        }
        return sds;
    }

    @Override
    public List<SensitiveData> getSensitiveDatasAssignedByRelatedDocId(Integer accountsPayablePurchasingDocumentLinkIdentifier) {
        Integer poId = this.purchaseOrderDao.getPurchaseOrderIdForCurrentPurchaseOrderByRelatedDocId(accountsPayablePurchasingDocumentLinkIdentifier);
        return this.getSensitiveDatasAssignedByPoId(poId);
    }

    @Override
    public List<SensitiveData> getSensitiveDatasAssignedByPoId(Integer poId) {
        LOG.debug((Object)"getSensitiveDatasAssignedByPoId(Integer) started");
        return this.sensitiveDataDao.getSensitiveDatasAssignedByPoId(poId);
    }

    @Override
    public List<SensitiveData> getSensitiveDatasAssignedByReqId(Integer reqId) {
        LOG.debug((Object)"getSensitiveDatasAssignedByReqId(Integer) started");
        return this.sensitiveDataDao.getSensitiveDatasAssignedByReqId(reqId);
    }

    @Override
    public void deletePurchaseOrderSensitiveDatas(Integer poId) {
        LOG.debug((Object)"deletePurchaseOrderSensitiveDatas(Integer) started");
        this.sensitiveDataDao.deletePurchaseOrderSensitiveDatas(poId);
    }

    @Override
    public void savePurchaseOrderSensitiveDatas(List<PurchaseOrderSensitiveData> posds) {
        LOG.debug((Object)"savePurchaseOrderSensitiveDatas(List<PurchaseOrderSensitiveData>) started");
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save(posds);
    }

    @Override
    public SensitiveDataAssignment getLastSensitiveDataAssignment(Integer poId) {
        LOG.debug((Object)"getLastSensitiveDataAssignment(Integer) started");
        return this.sensitiveDataDao.getLastSensitiveDataAssignment(poId);
    }

    @Override
    public Integer getLastSensitiveDataAssignmentId(Integer poId) {
        LOG.debug((Object)"getLastSensitiveDataAssignmentId(Integer) started");
        return this.getLastSensitiveDataAssignment(poId).getSensitiveDataAssignmentIdentifier();
    }

    @Override
    public void saveSensitiveDataAssignment(SensitiveDataAssignment sda) {
        LOG.debug((Object)"saveSensitiveDataAssignment(SensitiveDataAssignment) started");
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save((PersistableBusinessObject)sda);
    }

    @Override
    public List<SensitiveDataAssignmentDetail> getLastSensitiveDataAssignmentDetails(Integer poId) {
        LOG.debug((Object)"getLastSensitiveDataAssignmentDetails(Integer) started");
        Integer sdaId = this.getLastSensitiveDataAssignmentId(poId);
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put("sensitiveDataAssignmentIdentifier", sdaId);
        return (List)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findMatching(SensitiveDataAssignmentDetail.class, fieldValues);
    }

    @Override
    public void saveSensitiveDataAssignmentDetails(List<SensitiveDataAssignmentDetail> sdads) {
        LOG.debug((Object)"saveSensitiveDataAssignmentDetails(List<SensitiveDataAssignmentDetail>) started");
        ((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).save(sdads);
    }
}

