/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.businessobject;

import java.util.LinkedHashMap;
import java.util.List;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.purap.businessobject.PurchasingItemBase;
import org.kuali.kfs.module.purap.document.ContractManagerAssignmentDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.vnd.businessobject.CommodityContractManager;
import org.kuali.kfs.vnd.businessobject.ContractManager;
import org.kuali.rice.core.web.format.DateViewDateObjectFormatter;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class ContractManagerAssignmentDetail
extends PersistableBusinessObjectBase {
    private String documentNumber;
    private Integer requisitionIdentifier;
    private Integer contractManagerCode;
    private String deliveryCampusCode;
    private String vendorName;
    private RequisitionDocument requisition;
    private ContractManager contractManager;
    private ContractManagerAssignmentDocument contractManagerAssignmentDocument;
    private String createDate;

    public ContractManagerAssignmentDetail() {
    }

    public ContractManagerAssignmentDetail(ContractManagerAssignmentDocument acmDocument, RequisitionDocument requisitionDocument) {
        this.documentNumber = acmDocument.getDocumentNumber();
        this.contractManagerAssignmentDocument = acmDocument;
        this.requisition = requisitionDocument;
        this.requisitionIdentifier = requisitionDocument.getPurapDocumentIdentifier();
        this.deliveryCampusCode = requisitionDocument.getDeliveryCampusCode();
        this.vendorName = requisitionDocument.getVendorName();
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Integer getRequisitionIdentifier() {
        return this.requisitionIdentifier;
    }

    public void setRequisitionIdentifier(Integer requisitionIdentifier) {
        this.requisitionIdentifier = requisitionIdentifier;
    }

    public Integer getContractManagerCode() {
        List commodityContractManagers;
        String paramName = "ENABLE_DEFAULT_CONTRACT_MANAGER_IND";
        String paramValue = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(ContractManagerAssignmentDocument.class, paramName);
        if (paramValue.equals("Y") && this.contractManagerCode == null && this.getFirstLineItem().getCommodityCode() != null && (commodityContractManagers = this.getFirstLineItem().getCommodityCode().getCommodityContractManagers()) != null && commodityContractManagers.size() > 0) {
            int count = 0;
            Integer matchingContractManagerCode = null;
            for (CommodityContractManager commodityContractManager : commodityContractManagers) {
                if (!this.getRequisition().getDeliveryCampusCode().equals(commodityContractManager.getCampusCode())) continue;
                ++count;
                matchingContractManagerCode = commodityContractManager.getContractManagerCode();
            }
            if (count == 1) {
                this.setContractManagerCode(matchingContractManagerCode);
                return this.contractManagerCode;
            }
        }
        return this.contractManagerCode;
    }

    public void setContractManagerCode(Integer contractManagerCode) {
        this.contractManagerCode = contractManagerCode;
    }

    public ContractManager getContractManager() {
        return this.contractManager;
    }

    public void setContractManager(ContractManager contractManager) {
        this.contractManager = contractManager;
    }

    public RequisitionDocument getRequisition() {
        return this.requisition;
    }

    public void setRequisition(RequisitionDocument requisition) {
        this.requisition = requisition;
    }

    public ContractManagerAssignmentDocument getContractManagerAssignmentDocument() {
        return this.contractManagerAssignmentDocument;
    }

    public void setContractManagerAssignmentDocument(ContractManagerAssignmentDocument contractManagerAssignmentDocument) {
        this.contractManagerAssignmentDocument = contractManagerAssignmentDocument;
    }

    public String getCreateDate() throws WorkflowException {
        if (this.createDate == null) {
            DateViewDateObjectFormatter formatter = new DateViewDateObjectFormatter();
            this.createDate = (String)formatter.format((Object)this.getRequisition().getFinancialSystemDocumentHeader().getWorkflowDocument().getDateCreated().toDate());
        }
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    private PurchasingItemBase getFirstLineItem() {
        return (PurchasingItemBase)this.getRequisition().getItem(0);
    }

    public String getDeliveryCampusCode() {
        return this.deliveryCampusCode;
    }

    public void setDeliveryCampusCode(String deliveryCampusCode) {
        this.deliveryCampusCode = deliveryCampusCode;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("documentNumber", this.documentNumber);
        if (this.requisitionIdentifier != null) {
            m.put("requisitionIdentifier", this.requisitionIdentifier.toString());
        }
        return m;
    }
}

