/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderCloseDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class GenerateEntriesClosePurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl purapGeneralLedgerService;
    private PurapAccountingService purapAccountingService;
    private GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    private BusinessObjectService businessObjectService;
    private PurchaseOrderCloseDocument poClose;

    @Before
    public void setUp() {
        this.purapGeneralLedgerService = new PurapGeneralLedgerServiceImpl();
        this.purapAccountingService = (PurapAccountingService)EasyMock.createMock(PurapAccountingService.class);
        this.purapGeneralLedgerService.setPurapAccountingService(this.purapAccountingService);
        this.generalLedgerPendingEntryService = (GeneralLedgerPendingEntryService)EasyMock.createMock(GeneralLedgerPendingEntryService.class);
        this.purapGeneralLedgerService.setGeneralLedgerPendingEntryService(this.generalLedgerPendingEntryService);
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.purapGeneralLedgerService.setBusinessObjectService(this.businessObjectService);
        this.poClose = (PurchaseOrderCloseDocument)EasyMock.createMock(PurchaseOrderCloseDocument.class);
    }

    private void setUpBaseExpectations(List<PurchaseOrderItem> purchaseOrderItems, List<PurApItem> activePurchaseOrderItems, List<SourceAccountingLine> accountingLines, List<GeneralLedgerPendingEntry> pendingEntries) {
        EasyMock.expect((Object)this.poClose.getItems()).andReturn(purchaseOrderItems).times(2);
        EasyMock.expect((Object)this.poClose.getItemsActiveOnly()).andReturn(activePurchaseOrderItems);
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(activePurchaseOrderItems)).andReturn(accountingLines);
        this.poClose.setGlOnlySourceAccountingLines(accountingLines);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.poClose.getGlOnlySourceAccountingLines()).andReturn(accountingLines);
        EasyMock.expect((Object)this.generalLedgerPendingEntryService.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.poClose)).andReturn((Object)Boolean.TRUE);
        EasyMock.expect((Object)this.businessObjectService.save(pendingEntries)).andReturn(null);
    }

    private void verifyAll(List<PurchaseOrderItem> purchaseOrderItems) {
        EasyMock.verify((Object[])new Object[]{this.purapAccountingService, this.poClose});
        for (PurchaseOrderItem purchaseOrderItem : purchaseOrderItems) {
            EasyMock.verify((Object[])new Object[]{purchaseOrderItem});
        }
    }

    private void replayAll(List<PurchaseOrderItem> purchaseOrderItems) {
        EasyMock.replay((Object[])new Object[]{this.purapAccountingService, this.poClose});
        for (PurchaseOrderItem purchaseOrderItem : purchaseOrderItems) {
            EasyMock.replay((Object[])new Object[]{purchaseOrderItem});
        }
    }

    protected PurchaseOrderItem buildBaseMockedPurchaseOrderItem() {
        PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem)EasyMock.partialMockBuilder(PurchaseOrderItem.class).addMockedMethod("getItemType").createMock();
        purchaseOrderItem.setItemLineNumber(Integer.valueOf(1));
        purchaseOrderItem.setItemDescription("Stuff");
        purchaseOrderItem.setItemActiveIndicator(true);
        purchaseOrderItem.setDocumentNumber("1");
        purchaseOrderItem.setItemIdentifier(Integer.valueOf(1));
        purchaseOrderItem.setSourceAccountingLines(new ArrayList());
        return purchaseOrderItem;
    }

    protected PurchaseOrderItem buildQuantityMockedPurchaseOrderItem(KualiDecimal itemQuantity, BigDecimal itemUnitPrice) {
        PurchaseOrderItem purchaseOrderItem = this.buildBaseMockedPurchaseOrderItem();
        purchaseOrderItem.setItemQuantity(itemQuantity);
        purchaseOrderItem.setItemUnitPrice(itemUnitPrice);
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(true);
        EasyMock.expect((Object)purchaseOrderItem.getItemType()).andReturn((Object)itemType);
        return purchaseOrderItem;
    }

    protected PurchaseOrderItem buildNonQuantityMockedPurchaseOrderItem(KualiDecimal invoicedAmount) {
        PurchaseOrderItem purchaseOrderItem = this.buildBaseMockedPurchaseOrderItem();
        purchaseOrderItem.setItemInvoicedTotalAmount(invoicedAmount);
        ItemType itemType = new ItemType();
        itemType.setQuantityBasedGeneralLedgerIndicator(false);
        EasyMock.expect((Object)purchaseOrderItem.getItemType()).andReturn((Object)itemType);
        return purchaseOrderItem;
    }

    private PurchaseOrderAccount buildMockAccountingLine(BigDecimal accountingLinePercent, KualiDecimal amount) {
        PurchaseOrderAccount accountingLine = new PurchaseOrderAccount();
        accountingLine.setAccountLinePercent(accountingLinePercent);
        accountingLine.setAmount(amount);
        return accountingLine;
    }

    @Test
    public void testPurchaseOrderCloseWithNoItems() {
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        this.replayAll(purchaseOrderItems);
        this.purapGeneralLedgerService.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poClose);
        this.verifyAll(purchaseOrderItems);
        Assert.assertEquals((String)"Purchase Order Close should have no general ledger pending entries", (long)0L, (long)pendingEntries.size());
    }

    @Test
    public void testPurchaseOrderCloseWithOneQuantityItemOneAccountingLine() {
        PurchaseOrderItem purchaseOrderItem = this.buildQuantityMockedPurchaseOrderItem(new KualiDecimal(20), new BigDecimal(5.0));
        PurchaseOrderAccount accountingLine = this.buildMockAccountingLine(new BigDecimal(100.0), new KualiDecimal(100.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        EasyMock.expect((Object)this.poClose.getGeneralLedgerPendingEntries()).andReturn(pendingEntries);
        this.replayAll(purchaseOrderItems);
        EasyMock.replay((Object[])new Object[]{this.generalLedgerPendingEntryService});
        EasyMock.replay((Object[])new Object[]{this.businessObjectService});
        this.purapGeneralLedgerService.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poClose);
        this.verifyAll(purchaseOrderItems);
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 100.00", (Object)new KualiDecimal(100.0), (Object)accountingLine.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    public void testPurchaseOrderCloseWithOneQuantityItemTwoAccountingLines() {
        PurchaseOrderItem purchaseOrderItem = this.buildQuantityMockedPurchaseOrderItem(new KualiDecimal(20), new BigDecimal(5));
        PurchaseOrderAccount accountingLine1 = this.buildMockAccountingLine(new BigDecimal(50.0), new KualiDecimal(50.0));
        PurchaseOrderAccount accountingLine2 = this.buildMockAccountingLine(new BigDecimal(50.0), new KualiDecimal(50.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        EasyMock.expect((Object)this.poClose.getGeneralLedgerPendingEntries()).andReturn(pendingEntries);
        this.replayAll(purchaseOrderItems);
        EasyMock.replay((Object[])new Object[]{this.generalLedgerPendingEntryService});
        EasyMock.replay((Object[])new Object[]{this.businessObjectService});
        this.purapGeneralLedgerService.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poClose);
        this.verifyAll(purchaseOrderItems);
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 50", (Object)new KualiDecimal(50), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 50", (Object)new KualiDecimal(50), (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    public void testPurchaseOrderCloseWithTwoItems() {
        PurchaseOrderItem purchaseOrderItem1 = this.buildQuantityMockedPurchaseOrderItem(new KualiDecimal(20), new BigDecimal(5.0));
        PurchaseOrderAccount accountingLine1 = this.buildMockAccountingLine(new BigDecimal(100.0), new KualiDecimal(100.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem1.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem1.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem1.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItems.add(purchaseOrderItem1);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem1);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        PurchaseOrderItem purchaseOrderItem2 = this.buildQuantityMockedPurchaseOrderItem(new KualiDecimal(5), new BigDecimal(5));
        PurchaseOrderAccount accountingLine2 = this.buildMockAccountingLine(new BigDecimal(100), new KualiDecimal(25));
        purchaseOrderItem2.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem2.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem2.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem2);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem2);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        EasyMock.expect((Object)this.poClose.getGeneralLedgerPendingEntries()).andReturn(pendingEntries);
        this.replayAll(purchaseOrderItems);
        EasyMock.replay((Object[])new Object[]{this.generalLedgerPendingEntryService});
        EasyMock.replay((Object[])new Object[]{this.businessObjectService});
        this.purapGeneralLedgerService.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poClose);
        this.verifyAll(purchaseOrderItems);
        Assert.assertEquals((String)"Purchase Order Item 1 should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item 1 should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line 1 should be 100.00", (Object)new KualiDecimal(100.0), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line 1 should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assert.assertEquals((String)"Purchase Order Item 2 should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item 2 should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line 2 should be 25.00", (Object)new KualiDecimal(100.0), (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line 2 should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    public void testPurchaseOrderCloseWithOneActiveOneInactiveItem() {
        PurchaseOrderItem purchaseOrderItem1 = this.buildQuantityMockedPurchaseOrderItem(new KualiDecimal(20), new BigDecimal(5.0));
        PurchaseOrderAccount accountingLine1 = this.buildMockAccountingLine(new BigDecimal(100.0), new KualiDecimal(100.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem1.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem1.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem1.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItems.add(purchaseOrderItem1);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem1);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        PurchaseOrderItem purchaseOrderItem2 = this.buildQuantityMockedPurchaseOrderItem(new KualiDecimal(5), new BigDecimal(5));
        PurchaseOrderAccount accountingLine2 = this.buildMockAccountingLine(new BigDecimal(100), new KualiDecimal(25));
        purchaseOrderItem2.setItemOutstandingEncumberedQuantity(new KualiDecimal(1.0));
        purchaseOrderItem2.setItemOutstandingEncumberedAmount(new KualiDecimal(100.0));
        purchaseOrderItem2.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem2);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem2);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        purchaseOrderItem2.setItemActiveIndicator(false);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        EasyMock.expect((Object)this.poClose.getGeneralLedgerPendingEntries()).andReturn(pendingEntries);
        this.replayAll(purchaseOrderItems);
        EasyMock.replay((Object[])new Object[]{this.generalLedgerPendingEntryService});
        EasyMock.replay((Object[])new Object[]{this.businessObjectService});
        this.purapGeneralLedgerService.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poClose);
        this.verifyAll(purchaseOrderItems);
        Assert.assertEquals((String)"Purchase Order Item 1 should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item 1 should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem1.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line 1 should be 100.00", (Object)new KualiDecimal(100.0), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line 1 should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assert.assertEquals((String)"Purchase Order Item 2 should have outstanding encumbered quantity set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item 2 should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem2.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line 2 should be zero", (Object)KualiDecimal.ZERO, (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line 2 should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    public void testPurchaseOrderCloseWithOneNonQuantityItemOneAccountingLine() {
        PurchaseOrderItem purchaseOrderItem = this.buildNonQuantityMockedPurchaseOrderItem(new KualiDecimal(105.0));
        PurchaseOrderAccount accountingLine = this.buildMockAccountingLine(new BigDecimal(100.0), new KualiDecimal(105.0));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(105.0));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        EasyMock.expect((Object)this.poClose.getGeneralLedgerPendingEntries()).andReturn(pendingEntries);
        this.replayAll(purchaseOrderItems);
        EasyMock.replay((Object[])new Object[]{this.generalLedgerPendingEntryService});
        EasyMock.replay((Object[])new Object[]{this.businessObjectService});
        this.purapGeneralLedgerService.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poClose);
        this.verifyAll(purchaseOrderItems);
        Assert.assertNull((String)"Purchase Order Item should have outstanding encumbered quantity set to null", (Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 105.00", (Object)new KualiDecimal(105.0), (Object)accountingLine.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine.getItemAccountOutstandingEncumbranceAmount());
    }

    @Test
    public void testPurchaseOrderCloseWithOneNonQuantityItemTwoAccountingLines() {
        PurchaseOrderItem purchaseOrderItem = this.buildNonQuantityMockedPurchaseOrderItem(new KualiDecimal(200.07));
        PurchaseOrderAccount accountingLine1 = this.buildMockAccountingLine(new BigDecimal(50.0), new KualiDecimal(100.03));
        PurchaseOrderAccount accountingLine2 = this.buildMockAccountingLine(new BigDecimal(50.0), new KualiDecimal(100.03));
        ArrayList<PurchaseOrderItem> purchaseOrderItems = new ArrayList<PurchaseOrderItem>();
        ArrayList<PurApItem> activePurchaseOrderItems = new ArrayList<PurApItem>();
        ArrayList<SourceAccountingLine> accountingLines = new ArrayList<SourceAccountingLine>();
        ArrayList<GeneralLedgerPendingEntry> pendingEntries = new ArrayList<GeneralLedgerPendingEntry>();
        purchaseOrderItem.setItemOutstandingEncumberedAmount(new KualiDecimal(200.07));
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine1);
        purchaseOrderItem.getSourceAccountingLines().add(accountingLine2);
        purchaseOrderItems.add(purchaseOrderItem);
        activePurchaseOrderItems.add((PurApItem)purchaseOrderItem);
        accountingLines.add((SourceAccountingLine)accountingLine1);
        accountingLines.add((SourceAccountingLine)accountingLine2);
        this.setUpBaseExpectations(purchaseOrderItems, activePurchaseOrderItems, accountingLines, pendingEntries);
        EasyMock.expect((Object)this.poClose.getGeneralLedgerPendingEntries()).andReturn(pendingEntries);
        this.replayAll(purchaseOrderItems);
        EasyMock.replay((Object[])new Object[]{this.generalLedgerPendingEntryService});
        EasyMock.replay((Object[])new Object[]{this.businessObjectService});
        this.purapGeneralLedgerService.generateEntriesClosePurchaseOrder((PurchaseOrderDocument)this.poClose);
        this.verifyAll(purchaseOrderItems);
        Assert.assertNull((String)"Purchase Order Item should have outstanding encumbered quantity set to null", (Object)purchaseOrderItem.getItemOutstandingEncumberedQuantity());
        Assert.assertEquals((String)"Purchase Order Item should have outstanding encumbered amount set to zero", (Object)KualiDecimal.ZERO, (Object)purchaseOrderItem.getItemOutstandingEncumberedAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 100.03", (Object)new KualiDecimal(100.04), (Object)accountingLine1.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine1.getItemAccountOutstandingEncumbranceAmount());
        Assert.assertEquals((String)"GL Amount on accounting line should be 100.04", (Object)new KualiDecimal(100.03), (Object)accountingLine2.getAlternateAmountForGLEntryCreation());
        Assert.assertEquals((String)"Outstanding encumbrance amount on accounting line should be zero'd out", (Object)KualiDecimal.ZERO, (Object)accountingLine2.getItemAccountOutstandingEncumbranceAmount());
    }
}

