/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApAccountingLine;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.service.PurapAccountingService;
import org.kuali.kfs.module.purap.service.impl.PurapGeneralLedgerServiceImpl;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.SourceAccountingLine;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class GenerateEntriesVoidPurchaseOrderTest {
    private PurapGeneralLedgerServiceImpl purapGeneralLedgerService;
    private PurchaseOrderDocument po;
    private PurapAccountingService purapAccountingService;
    private GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    private BusinessObjectService businessObjectService;
    private List<PurApItem> poItems;
    private List<PurApItem> poActiveItems;
    private List<GeneralLedgerPendingEntry> glpes;
    private List<SourceAccountingLine> sourceAccountingLines;
    private List<Object> dynamicMocks;

    @Before
    public void setUp() {
        this.purapGeneralLedgerService = new PurapGeneralLedgerServiceImpl();
        this.purapAccountingService = (PurapAccountingService)EasyMock.createMock(PurapAccountingService.class);
        this.purapGeneralLedgerService.setPurapAccountingService(this.purapAccountingService);
        this.generalLedgerPendingEntryService = (GeneralLedgerPendingEntryService)EasyMock.createMock(GeneralLedgerPendingEntryService.class);
        this.purapGeneralLedgerService.setGeneralLedgerPendingEntryService(this.generalLedgerPendingEntryService);
        this.businessObjectService = (BusinessObjectService)EasyMock.createMock(BusinessObjectService.class);
        this.purapGeneralLedgerService.setBusinessObjectService(this.businessObjectService);
        this.po = (PurchaseOrderDocument)EasyMock.createMock(PurchaseOrderDocument.class);
        this.poItems = new ArrayList<PurApItem>();
        this.poActiveItems = new ArrayList<PurApItem>();
        this.glpes = new ArrayList<GeneralLedgerPendingEntry>();
        this.sourceAccountingLines = new ArrayList<SourceAccountingLine>();
        this.dynamicMocks = new ArrayList<Object>();
    }

    private void execute() {
        EasyMock.replay((Object[])new Object[]{this.po, this.purapAccountingService, this.generalLedgerPendingEntryService, this.businessObjectService});
        for (Object mock : this.dynamicMocks) {
            EasyMock.replay((Object[])new Object[]{mock});
        }
        this.purapGeneralLedgerService.generateEntriesVoidPurchaseOrder(this.po);
        EasyMock.verify((Object[])new Object[]{this.po, this.purapAccountingService, this.generalLedgerPendingEntryService, this.businessObjectService});
        for (Object mock : this.dynamicMocks) {
            EasyMock.verify((Object[])new Object[]{mock});
        }
    }

    private void preparePO() {
        EasyMock.expect((Object)this.po.getItems()).andReturn(this.poItems).anyTimes();
        EasyMock.expect((Object)this.po.getItemsActiveOnly()).andReturn(this.poActiveItems).anyTimes();
        this.po.setGlOnlySourceAccountingLines(this.sourceAccountingLines);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.po.getGeneralLedgerPendingEntries()).andReturn(this.glpes).anyTimes();
    }

    private void prepareItem(int lineNumber, double outstandingAmount, List<PurApAccountingLine> accountingLines, boolean active) {
        PurchaseOrderItem item = (PurchaseOrderItem)EasyMock.createMock(PurchaseOrderItem.class);
        EasyMock.expect((Object)item.getItemLineNumber()).andReturn((Object)lineNumber).anyTimes();
        EasyMock.expect((Object)item.isItemActiveIndicator()).andReturn((Object)active).anyTimes();
        if (active) {
            EasyMock.expect((Object)item.getItemOutstandingEncumberedAmount()).andReturn((Object)new KualiDecimal(outstandingAmount)).anyTimes();
            EasyMock.expect((Object)item.getSourceAccountingLines()).andReturn(accountingLines).anyTimes();
            this.poActiveItems.add((PurApItem)item);
        }
        this.poItems.add((PurApItem)item);
        this.dynamicMocks.add(item);
    }

    private PurchaseOrderAccount createPoAccountingLine(double percent, double newOutstandingAmount, Double altAmount) {
        PurchaseOrderAccount account = (PurchaseOrderAccount)EasyMock.mock(PurchaseOrderAccount.class);
        EasyMock.expect((Object)account.isEmpty()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)account.getAccountLinePercent()).andReturn((Object)new BigDecimal(percent)).anyTimes();
        EasyMock.expect((Object)account.compareTo(EasyMock.isA(PurchaseOrderAccount.class))).andReturn((Object)0).anyTimes();
        account.setAlternateAmountForGLEntryCreation(new KualiDecimal(newOutstandingAmount));
        EasyMock.expectLastCall();
        if (altAmount != null) {
            EasyMock.expect((Object)account.getAlternateAmountForGLEntryCreation()).andReturn((Object)new KualiDecimal(newOutstandingAmount));
            account.setAlternateAmountForGLEntryCreation(new KualiDecimal(altAmount.doubleValue()));
            EasyMock.expectLastCall();
        }
        this.sourceAccountingLines.add((SourceAccountingLine)account);
        this.dynamicMocks.add(account);
        return account;
    }

    private void prepareItemsNoAccountingLines() {
        this.prepareItem(1, 10.0, new ArrayList<PurApAccountingLine>(), true);
        this.prepareItem(2, 15.0, new ArrayList<PurApAccountingLine>(), false);
    }

    private void prepareItemsWithAccountingLines() {
        ArrayList<Object> accountingLines = new ArrayList<PurApAccountingLine>();
        accountingLines.add(this.createPoAccountingLine(100.0, 10.0, 10.0));
        this.prepareItem(1, 10.0, accountingLines, true);
        accountingLines = new ArrayList();
        accountingLines.add((PurApAccountingLine)this.createPoAccountingLine(50.0, 5.0, null));
        accountingLines.add(this.createPoAccountingLine(50.0, 5.0, 5.0));
        this.prepareItem(2, 10.0, accountingLines, true);
        accountingLines = new ArrayList();
        accountingLines.add((PurApAccountingLine)this.createPoAccountingLine(66.66, 6666.0, null));
        accountingLines.add(this.createPoAccountingLine(33.33, 3333.0, 3334.0));
        this.prepareItem(3, 10000.0, accountingLines, true);
    }

    private void baseExpectations() {
        this.preparePO();
        EasyMock.expect((Object)this.purapAccountingService.generateSummaryWithNoZeroTotalsUsingAlternateAmount(this.poActiveItems)).andReturn(this.sourceAccountingLines);
        EasyMock.expect((Object)this.generalLedgerPendingEntryService.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)this.po)).andReturn((Object)true);
        EasyMock.expect((Object)this.businessObjectService.save(this.glpes)).andReturn(null);
    }

    @Test
    public void testBaseCase() {
        this.baseExpectations();
        this.execute();
    }

    @Test
    public void testPoWithItems() {
        this.baseExpectations();
        this.prepareItemsNoAccountingLines();
        this.execute();
    }

    @Test
    public void testPoWithAccountingLines() {
        this.baseExpectations();
        this.prepareItemsWithAccountingLines();
        this.execute();
    }
}

