/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.service.impl.purapgeneralledgerserviceimpl;

import java.math.BigDecimal;
import org.kuali.kfs.module.purap.businessobject.ItemType;
import org.kuali.kfs.module.purap.businessobject.PaymentRequestItem;
import org.kuali.kfs.module.purap.businessobject.PurApItem;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderAccount;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderItem;
import org.kuali.kfs.module.purap.document.PaymentRequestDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PurapGeneralLedgerTest {
    public static final String ITEM = "ITEM";
    public static final String MISC = "MISC";
    public static final KualiDecimal KDONE = new KualiDecimal("1.00");
    public static final KualiDecimal KDTWO = new KualiDecimal("2.00");

    protected PurchaseOrderAccount getPurchaseOrderAccount(KualiDecimal amount, KualiDecimal itemAccountOutstandingEncumbranceAmount) {
        PurchaseOrderAccount al = new PurchaseOrderAccount();
        al.setAmount(amount);
        al.setItemAccountOutstandingEncumbranceAmount(itemAccountOutstandingEncumbranceAmount);
        return al;
    }

    protected PurApItem getPurchaseOrderItem(PurchaseOrderDocument document, int lineNumber, KualiDecimal quantity, BigDecimal itemUnitPrice, KualiDecimal encumberedQuantity, KualiDecimal itemInvoicedTotalQuantity, KualiDecimal encumberedAmount, KualiDecimal itemInvoicedTotalAmount, String itemTypeCode) {
        PurchaseOrderItem item = new PurchaseOrderItem(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        item.setItemInvoicedTotalQuantity(itemInvoicedTotalQuantity);
        item.setItemInvoicedTotalAmount(itemInvoicedTotalAmount);
        item.setItemQuantity(quantity);
        item.setItemUnitPrice(itemUnitPrice);
        item.setItemOutstandingEncumberedQuantity(encumberedQuantity);
        item.setItemOutstandingEncumberedAmount(encumberedAmount);
        item.setItemLineNumber(Integer.valueOf(lineNumber));
        item.setPurapDocument((PurchasingAccountsPayableDocument)document);
        ItemType it = this.getItemType(itemTypeCode);
        item.setItemTypeCode(it.getItemTypeCode());
        item.setItemType(it);
        return item;
    }

    protected PurApItem getPaymentRequestItem(PaymentRequestDocument document, int lineNumber, KualiDecimal quantity, BigDecimal price, String itemTypeCode) {
        PaymentRequestItem item = new PaymentRequestItem(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        item.setItemQuantity(quantity);
        item.setItemUnitPrice(price);
        item.setItemLineNumber(Integer.valueOf(lineNumber));
        item.setPurapDocument((PurchasingAccountsPayableDocument)document);
        ItemType it = this.getItemType(itemTypeCode);
        item.setItemTypeCode(it.getItemTypeCode());
        item.setItemType(it);
        return item;
    }

    protected ItemType getItemType(String code) {
        ItemType it = new ItemType();
        if (ITEM.equals(code)) {
            it.setItemTypeCode(ITEM);
            it.setAdditionalChargeIndicator(false);
            it.setQuantityBasedGeneralLedgerIndicator(true);
            it.setTaxableIndicator(true);
            it.setActive(true);
        } else {
            it.setItemTypeCode(MISC);
            it.setAdditionalChargeIndicator(true);
            it.setQuantityBasedGeneralLedgerIndicator(false);
            it.setTaxableIndicator(true);
            it.setActive(true);
        }
        return it;
    }
}

