/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2017 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.purap.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

import java.util.LinkedHashMap;

/**
 * Delivery Required Date Reason Business Object. Defines the reason why a delivery date is required.
 */
public class DeliveryRequiredDateReason extends PersistableBusinessObjectBase implements MutableInactivatable {

    private String deliveryRequiredDateReasonCode;
    private String deliveryRequiredDateReasonDescription;
    private boolean active;

    /**
     * Default constructor.
     */
    public DeliveryRequiredDateReason() {

    }

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDeliveryRequiredDateReasonCode() {
        return deliveryRequiredDateReasonCode;
    }

    public void setDeliveryRequiredDateReasonCode(String deliveryRequiredDateReasonCode) {
        this.deliveryRequiredDateReasonCode = deliveryRequiredDateReasonCode;
    }

    public String getDeliveryRequiredDateReasonDescription() {
        return deliveryRequiredDateReasonDescription;
    }

    public void setDeliveryRequiredDateReasonDescription(String deliveryRequiredDateReasonDescription) {
        this.deliveryRequiredDateReasonDescription = deliveryRequiredDateReasonDescription;
    }

    /**
     * @see org.kuali.rice.krad.bo.BusinessObjectBase#toStringMapper()
     */
    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap m = new LinkedHashMap();
        m.put("deliveryRequiredDateReasonCode", this.deliveryRequiredDateReasonCode);
        return m;
    }
}
