/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document;

import java.util.List;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.purap.businessobject.ContractManagerAssignmentDetail;
import org.kuali.kfs.module.purap.businessobject.PurchaseOrderView;
import org.kuali.kfs.module.purap.document.ContractManagerAssignmentDocument;
import org.kuali.kfs.module.purap.document.PurchaseOrderDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.fixture.ContractManagerAssignmentDocumentFixture;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.AccountingDocumentTestUtils;
import org.kuali.kfs.sys.document.workflow.WorkflowTestUtils;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class PurapPerformanceDocumentTest
extends KualiTestBase {
    protected RequisitionDocument requisitionDocument = null;
    protected boolean SETUP_PERFORMANCE_TESTS = false;
    protected DocumentService documentService = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
    }

    protected void tearDown() throws Exception {
        this.requisitionDocument = null;
        super.tearDown();
    }

    @ConfigureContext(session=UserNameFixture.parke, shouldCommitTransactions=true)
    public final void testFullRoutePerformanceDocuments() throws Exception {
        if (!this.SETUP_PERFORMANCE_TESTS) {
            PurapPerformanceDocumentTest.assertTrue((boolean)true);
        } else {
            this.requisitionDocument = RequisitionDocumentFixture.REQ_PERFORMANCE.createRequisitionDocument();
            this.requisitionDocument.getDocumentHeader().setDocumentDescription("Load Testing");
            String docId = this.requisitionDocument.getDocumentNumber();
            AccountingDocumentTestUtils.routeDocument((AccountingDocument)this.requisitionDocument, (DocumentService)this.documentService);
            WorkflowTestUtils.waitForNodeChange((WorkflowDocument)this.requisitionDocument.getDocumentHeader().getWorkflowDocument(), (String)"Account");
            this.changeCurrentUser(UserNameFixture.rorenfro);
            this.requisitionDocument = (RequisitionDocument)this.documentService.getByDocumentHeaderId(docId);
            PurapPerformanceDocumentTest.assertTrue((String)"At incorrect node.", (boolean)WorkflowTestUtils.isAtNode((Document)this.requisitionDocument, (String)"Account"));
            PurapPerformanceDocumentTest.assertTrue((String)"Document should be enroute.", (boolean)this.requisitionDocument.getDocumentHeader().getWorkflowDocument().isEnroute());
            PurapPerformanceDocumentTest.assertTrue((String)"Fiscal Officer should have an approve request.", (boolean)this.requisitionDocument.getDocumentHeader().getWorkflowDocument().isApprovalRequested());
            ((DocumentService)SpringContext.getBean(DocumentService.class)).approveDocument((Document)this.requisitionDocument, "Test approving as Fiscal Officer.", null);
            WorkflowTestUtils.waitForDocumentApproval((String)this.requisitionDocument.getDocumentNumber());
            this.changeCurrentUser(UserNameFixture.parke);
            this.requisitionDocument = (RequisitionDocument)this.documentService.getByDocumentHeaderId(docId);
            PurapPerformanceDocumentTest.assertTrue((String)"Document should now be final.", (boolean)this.requisitionDocument.getDocumentHeader().getWorkflowDocument().isFinal());
            ContractManagerAssignmentDocument cmaDocument = this.buildContractManagerAssignmentDocument();
            cmaDocument.prepareForSave();
            PurapPerformanceDocumentTest.assertFalse((boolean)DocumentStatus.ENROUTE.equals((Object)cmaDocument.getDocumentHeader().getWorkflowDocument().getStatus()));
            this.routeDocument((Document)cmaDocument, "saving copy source document", this.documentService);
            WorkflowTestUtils.waitForDocumentApproval((String)cmaDocument.getDocumentNumber());
            cmaDocument = (ContractManagerAssignmentDocument)this.documentService.getByDocumentHeaderId(cmaDocument.getDocumentNumber());
            PurapPerformanceDocumentTest.assertTrue((String)"Document should now be final.", (boolean)cmaDocument.getDocumentHeader().getWorkflowDocument().isFinal());
            String poNumber = ((PurchaseOrderView)this.requisitionDocument.getRelatedViews().getRelatedPurchaseOrderViews().get(0)).getDocumentNumber();
            PurchaseOrderDocument poDoc = (PurchaseOrderDocument)this.documentService.getByDocumentHeaderId(poNumber);
            poDoc.setVendorName("KUALI UNIVERSITY");
            poDoc.setVendorHeaderGeneratedIdentifier(Integer.valueOf(1001));
            poDoc.setVendorDetailAssignedIdentifier(Integer.valueOf(0));
            poDoc.setVendorLine1Address("341 PINE TREE RD");
            poDoc.setVendorCityName("ITHACA");
            poDoc.setVendorStateCode("NY");
            poDoc.setVendorPostalCode("14850");
            poDoc.setVendorCountryCode("US");
            poDoc.setVendorPaymentTermsCode("00N30");
            poDoc.setPurchaseOrderVendorChoiceCode("ONLY");
            this.routeDocument((Document)poDoc, "Test routing as parke", this.documentService);
            this.changeCurrentUser(UserNameFixture.butt);
            poDoc = (PurchaseOrderDocument)this.documentService.getByDocumentHeaderId(poNumber);
            PurapPerformanceDocumentTest.assertTrue((String)"Document should be enroute.", (boolean)poDoc.getDocumentHeader().getWorkflowDocument().isEnroute());
            PurapPerformanceDocumentTest.assertTrue((String)"Budget Approver should have an approve request.", (boolean)poDoc.getDocumentHeader().getWorkflowDocument().isApprovalRequested());
            ((DocumentService)SpringContext.getBean(DocumentService.class)).approveDocument((Document)poDoc, "Test approving as Budget Approver.", null);
            WorkflowTestUtils.waitForDocumentApproval((String)poDoc.getDocumentNumber());
            this.changeCurrentUser(UserNameFixture.parke);
            poDoc = (PurchaseOrderDocument)this.documentService.getByDocumentHeaderId(poNumber);
            PurapPerformanceDocumentTest.assertTrue((String)"Document should now be final.", (boolean)poDoc.getDocumentHeader().getWorkflowDocument().isFinal());
        }
    }

    private ContractManagerAssignmentDocument buildContractManagerAssignmentDocument() throws Exception {
        ContractManagerAssignmentDocument cmaDocument = null;
        List<ContractManagerAssignmentDetail> details = ContractManagerAssignmentDocumentFixture.ACM_DOCUMENT_PERFORMANCE.getContractManagerAssignmentDetails();
        for (ContractManagerAssignmentDetail detail : details) {
            detail.setRequisitionIdentifier(this.requisitionDocument.getPurapDocumentIdentifier());
            detail.refreshNonUpdateableReferences();
        }
        cmaDocument = ContractManagerAssignmentDocumentFixture.ACM_DOCUMENT_PERFORMANCE.createContractManagerAssignmentDocument();
        for (ContractManagerAssignmentDetail detail : details) {
            detail.setContractManagerAssignmentDocument(cmaDocument);
        }
        cmaDocument.setContractManagerAssignmentDetailss(details);
        return cmaDocument;
    }

    private void routeDocument(Document document, String annotation, DocumentService documentService) throws WorkflowException {
        try {
            documentService.routeDocument(document, annotation, null);
        }
        catch (ValidationException e) {
            PurapPerformanceDocumentTest.fail((String)(e.getMessage() + ", " + GlobalVariables.getMessageMap()));
        }
    }
}

