/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.purap.document.service;

import java.sql.Date;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.coreservice.impl.parameter.ParameterBo;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.purap.businessobject.PurApItemUseTax;
import org.kuali.kfs.module.purap.document.PurchasingAccountsPayableDocument;
import org.kuali.kfs.module.purap.document.RequisitionDocument;
import org.kuali.kfs.module.purap.document.service.PurapService;
import org.kuali.kfs.module.purap.fixture.RequisitionDocumentFixture;
import org.kuali.kfs.module.purap.fixture.TaxFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.TaxRegion;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

@ConfigureContext(session=UserNameFixture.khuntley)
public class PurapServiceTest
extends KualiTestBase {
    private static final Logger LOG = LogManager.getLogger(PurapServiceTest.class);
    private Date currentDate;
    private Date compareDate;
    private int dayOffset = 60;
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private String NAMESPACE = "KFS-PURAP";
    private static final String[] TAXABLE_PARM_NMs = new String[]{"TAXABLE_DELIVERY_STATES", "TAXABLE_FUND_GROUPS_FOR_NON_TAXABLE_STATES", "TAXABLE_FUND_GROUPS_FOR_TAXABLE_STATES", "TAXABLE_OBJECT_CONSOLIDATIONS_FOR_NON_TAXABLE_STATES", "TAXABLE_OBJECT_CONSOLIDATIONS_FOR_TAXABLE_STATES", "TAXABLE_OBJECT_LEVELS_FOR_NON_TAXABLE_STATES", "TAXABLE_OBJECT_LEVELS_FOR_TAXABLE_STATES", "TAXABLE_SUB_FUND_GROUPS_FOR_NON_TAXABLE_STATES", "TAXABLE_SUB_FUND_GROUPS_FOR_TAXABLE_STATES"};

    protected void setUp() throws Exception {
        super.setUp();
        this.currentDate = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentSqlDate();
        Calendar calendar = ((DateTimeService)SpringContext.getBean(DateTimeService.class)).getCurrentCalendar();
        calendar.add(5, this.dayOffset);
        this.compareDate = new Date(calendar.getTimeInMillis());
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
        this.enableParameterConstraints(true);
    }

    protected void tearDown() throws Exception {
        this.currentDate = null;
        this.compareDate = null;
        super.tearDown();
    }

    public void testIsDateMoreThanANumberOfDaysAway_ManyFewerDays() {
        int daysAway = this.dayOffset - 5;
        PurapServiceTest.assertTrue((boolean)((PurapService)SpringContext.getBean(PurapService.class)).isDateMoreThanANumberOfDaysAway(this.compareDate, daysAway));
    }

    public void testIsDateMoreThanANumberOfDaysAway_OneLessDays() {
        int daysAway = this.dayOffset - 1;
        PurapServiceTest.assertTrue((boolean)((PurapService)SpringContext.getBean(PurapService.class)).isDateMoreThanANumberOfDaysAway(this.compareDate, daysAway));
    }

    public void testIsDateMoreThanANumberOfDaysAway_SameNumberOfDays() {
        int daysAway = this.dayOffset;
        PurapServiceTest.assertFalse((boolean)((PurapService)SpringContext.getBean(PurapService.class)).isDateMoreThanANumberOfDaysAway(this.compareDate, daysAway));
    }

    public void testIsDateMoreThanANumberOfDaysAway_OneMoreDays() {
        int daysAway = this.dayOffset + 1;
        PurapServiceTest.assertFalse((boolean)((PurapService)SpringContext.getBean(PurapService.class)).isDateMoreThanANumberOfDaysAway(this.compareDate, daysAway));
    }

    public void testIsDateMoreThanANumberOfDaysAway_ManyMoreDays() {
        int daysAway = this.dayOffset + 5;
        PurapServiceTest.assertFalse((boolean)((PurapService)SpringContext.getBean(PurapService.class)).isDateMoreThanANumberOfDaysAway(this.compareDate, daysAway));
    }

    public void testSalesTaxHappyPath() {
        try {
            TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202, TaxFixture.TaxRegionPostalCodeFixture.PO_46202_SHORT}, null);
            this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
        }
        catch (Exception e) {
            try {
                TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202}, null);
                this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.SalesTaxHappyPathTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertEquals((Object)new KualiDecimal("0.05"), (Object)reqDoc.getItem(0).getItemTaxAmount());
        PurapServiceTest.assertEquals((Object)new KualiDecimal("1.05"), (Object)reqDoc.getItem(0).getTotalAmount());
    }

    public void testUseTaxHappyPath() {
        TaxRegion taxRegionState = TaxFixture.TaxRegionFixture.TAX_REGION_WITH_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_07}, null, new TaxFixture.TaxRegionStateFixture[]{TaxFixture.TaxRegionStateFixture.IN});
        this.businessObjectService.save((PersistableBusinessObject)taxRegionState);
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.UseTaxHappyPathTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertNotNull((Object)reqDoc.getItem(0).getUseTaxItems());
        PurapServiceTest.assertEquals((int)1, (int)reqDoc.getItem(0).getUseTaxItems().size());
        PurApItemUseTax itemUseTax = (PurApItemUseTax)reqDoc.getItem(0).getUseTaxItems().get(0);
        PurapServiceTest.assertEquals((String)itemUseTax.getAccountNumber(), (String)"6044900");
        PurapServiceTest.assertEquals((String)itemUseTax.getChartOfAccountsCode(), (String)"BA");
        PurapServiceTest.assertEquals((String)itemUseTax.getFinancialObjectCode(), (String)"1500");
        PurapServiceTest.assertEquals((String)itemUseTax.getRateCode(), (String)"USETAX");
        PurapServiceTest.assertEquals((Object)itemUseTax.getTaxAmount(), (Object)new KualiDecimal("0.07"));
    }

    public void testSalesTaxWithItemTypeNotTaxable() {
        TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202}, null);
        this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.SalesTaxItemTypeNotTaxableTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertNull((Object)reqDoc.getItem(0).getItemTaxAmount());
        PurapServiceTest.assertEquals((Object)reqDoc.getItem(0).getTotalAmount(), (Object)new KualiDecimal("1.00"));
    }

    public void testSalesTaxWithItemTaxFieldNull() {
        TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202}, null);
        this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.SalesTaxItemTaxFieldNullTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertNotNull((Object)reqDoc.getItem(0).getItemTaxAmount());
        PurapServiceTest.assertEquals((Object)new KualiDecimal("100.00"), (Object)reqDoc.getItem(0).getItemTaxAmount());
        PurapServiceTest.assertEquals((Object)new KualiDecimal("101.00"), (Object)reqDoc.getItem(0).getTotalAmount());
    }

    public void testSalesTaxWithCommodityCodeNull() throws Exception {
        this.enableParameterConstraints(false);
        TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202}, null);
        this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.SalesTaxCommodityCodeNullTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertNull((Object)reqDoc.getItem(0).getItemTaxAmount());
        PurapServiceTest.assertEquals((Object)new KualiDecimal("1.00"), (Object)reqDoc.getItem(0).getTotalAmount());
        this.enableParameterConstraints(true);
    }

    public void testSalesTaxWithDeliveryStateNotTaxable() {
        try {
            TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202, TaxFixture.TaxRegionPostalCodeFixture.PO_46202_SHORT}, null);
            this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
        }
        catch (Exception e) {
            try {
                TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202}, null);
                this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
            }
            catch (Exception taxRegionPostalCode) {
                // empty catch block
            }
        }
        boolean isExists = ((ParameterService)SpringContext.getBean(ParameterService.class)).parameterExists(KfsParameterConstants.PURCHASING_DOCUMENT.class, "TAXABLE_DELIVERY_STATES");
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.SalesTaxDeliveryStateExemptTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertEquals((Object)new KualiDecimal("0.05"), (Object)reqDoc.getItem(0).getItemTaxAmount());
        PurapServiceTest.assertEquals((Object)new KualiDecimal("1.05"), (Object)reqDoc.getItem(0).getTotalAmount());
    }

    public void testSalesTaxDeliveryStateExemptWithNonTaxableFund() {
        TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202}, null);
        this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
        boolean isExists = ((ParameterService)SpringContext.getBean(ParameterService.class)).parameterExists(KfsParameterConstants.PURCHASING_DOCUMENT.class, "TAXABLE_DELIVERY_STATES");
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.SalesTaxDeliveryStateExemptWithNonTaxableFundTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertNull((Object)reqDoc.getItem(0).getItemTaxAmount());
        PurapServiceTest.assertEquals((Object)new KualiDecimal("1.00"), (Object)reqDoc.getItem(0).getTotalAmount());
    }

    public void testSalesTaxWithAccountNotTaxable() {
        TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202}, null);
        this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.SalesTaxAccountNotTaxableTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertNull((Object)reqDoc.getItem(0).getItemTaxAmount());
        PurapServiceTest.assertEquals((Object)new KualiDecimal("1.00"), (Object)reqDoc.getItem(0).getTotalAmount());
    }

    public void testSalesTaxWithObjectCodeNotTaxable() {
        TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202}, null);
        this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.SalesTaxObjectCodeNotTaxableTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertNull((Object)reqDoc.getItem(0).getItemTaxAmount());
        PurapServiceTest.assertEquals((Object)reqDoc.getItem(0).getTotalAmount(), (Object)new KualiDecimal("1.00"));
    }

    public void testUseTaxItemTypeNotTaxable() {
        TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202}, null);
        this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.UseTaxItemTypeNotTaxableTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertEquals((int)reqDoc.getItem(0).getUseTaxItems().size(), (int)0);
    }

    public void testSalesTaxWithSalesTaxParamDisabled() {
        TaxRegion taxRegionPostalCode = TaxFixture.TaxRegionFixture.TAX_REGION_NO_USE_TAX.createTaxRegion(new TaxFixture.TaxRegionRateFixture[]{TaxFixture.TaxRegionRateFixture.TAX_REGION_RATE_05}, new TaxFixture.TaxRegionPostalCodeFixture[]{TaxFixture.TaxRegionPostalCodeFixture.PO_46202}, null);
        this.businessObjectService.save((PersistableBusinessObject)taxRegionPostalCode);
        RequisitionDocument reqDoc = RequisitionDocumentFixture.REQ_ONLY_REQUIRED_FIELDS.createRequisitionDocumentForTax(TaxFixture.TaxTestCaseFixture.SalesTaxParamDisabledTest);
        ((PurapService)SpringContext.getBean(PurapService.class)).calculateTax((PurchasingAccountsPayableDocument)reqDoc);
        PurapServiceTest.assertNull((Object)reqDoc.getItem(0).getItemTaxAmount());
        PurapServiceTest.assertEquals((Object)reqDoc.getItem(0).getTotalAmount(), (Object)new KualiDecimal("1.00"));
    }

    private void enableParameterConstraints(boolean enabled) {
        for (String taxableParmName : TAXABLE_PARM_NMs) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("namespaceCode", this.NAMESPACE);
            fieldValues.put("componentCode", "Document");
            fieldValues.put("applicationId", "KFS");
            fieldValues.put("name", taxableParmName);
            ParameterBo parameter = (ParameterBo)this.businessObjectService.findByPrimaryKey(ParameterBo.class, fieldValues);
            if (enabled) {
                parameter.setEvaluationOperatorCode("A");
            } else {
                parameter.setEvaluationOperatorCode("D");
            }
            this.businessObjectService.save((PersistableBusinessObject)parameter);
        }
    }
}

